/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.service.impl;

import com.alibaba.ttl.TtlRunnable;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppType;
import com.xforceplus.ultraman.bocp.metadata.enums.PackageFlag;
import com.xforceplus.ultraman.bocp.metadata.validator.CommonValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.generate.base.codegen.CodeGenBase;
import com.xforceplus.ultraman.metadata.generate.base.codegen.CodeGenBaseExecutor;
import com.xforceplus.ultraman.metadata.generate.base.codegen.CodeGenForMultiTenantExecutor;
import com.xforceplus.ultraman.metadata.generate.service.ICodeGenService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeGenServiceImpl
extends CodeGenBase
implements ICodeGenService {
    private static final Logger log = LoggerFactory.getLogger(CodeGenServiceImpl.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private CommonValidator commonValidator;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private CodeGenBaseExecutor codeGenBaseExecutor;
    @Autowired
    private CodeGenForMultiTenantExecutor codeGenForMultiTenantExecutor;

    @Override
    public ServiceResponse mvnDeploy(Long appId, Long appVersionId) {
        return this.mvnDeploy(appId, appVersionId, Maps.newHashMap());
    }

    @Override
    public ServiceResponse mvnDeploy(Long appId, Long appVersionId, Map<Long, String> tenantAppVersionMap) {
        App app = this.appRepository.getAppWithValidate(appId.longValue());
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(appId, appVersionId);
        List versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId);
        if (versionChanges.isEmpty()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u7248\u672c\u7684\u5dee\u5f02\u4fe1\u606f");
        }
        appVersion.setPackageFlag(PackageFlag.PACKAGING.code());
        this.appVersionService.updateById((Object)appVersion);
        if (AppType.getMultiTenantTypeCodeList().contains(app.getType())) {
            return this.publishForMultiTenant(app, appVersion.getVersion(), tenantAppVersionMap);
        }
        Optional<AppVersionChange> boChangesOptl = versionChanges.stream().filter(vc -> MetadataType.BO.code().equals(vc.getResourceType())).findAny();
        Optional<AppVersionChange> dictChangesOptl = versionChanges.stream().filter(vc -> MetadataType.DICT.code().equals(vc.getResourceType())).findAny();
        return this.publish(appId, appVersion.getVersion(), boChangesOptl.isPresent() ? boChangesOptl.get().getResourceVersion() : null, dictChangesOptl.isPresent() ? dictChangesOptl.get().getResourceVersion() : null);
    }

    @Override
    public ServiceResponse publish(Long appId, String version, String moduleVersion, String dictVersion) {
        if (!this.commonValidator.checkApp(appId)) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u5e94\u7528");
        }
        Optional moduleOptional = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), moduleVersion);
        if (!moduleOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6a21\u5757");
        }
        App app = this.appRepository.getApp(appId.longValue()).orElse(null);
        Long moduleId = ((Module)moduleOptional.get()).getId();
        TtlRunnable runnable = TtlRunnable.get(() -> this.codeGenBaseExecutor.doGen1(app, moduleId, version, dictVersion));
        TtlRunnable runnable2 = TtlRunnable.get(() -> this.codeGenBaseExecutor.doGen2(app, moduleId, version, dictVersion));
        TtlRunnable runnable3 = TtlRunnable.get(() -> this.codeGenBaseExecutor.doGen3(app, moduleId, version, dictVersion));
        this.threadPool.execute((Runnable)runnable3);
        this.threadPool.execute((Runnable)runnable2);
        this.threadPool.execute((Runnable)runnable);
        return ServiceResponse.success((String)"");
    }

    private ServiceResponse publishForMultiTenant(App app, String appVersion, Map<Long, String> tenantAppVersionMap) {
        Optional appVersionChangeOptional = this.appVersionQuery.getAppVersionChange(app.getId(), appVersion, MetadataType.BO);
        if (!appVersionChangeOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u7248\u672c\u53d8\u66f4\u4fe1\u606f");
        }
        Optional moduleOptional = this.defaultModuleService.getPublishedModuleByAppId(app.getId().longValue(), ((AppVersionChange)appVersionChangeOptional.get()).getResourceVersion());
        if (!moduleOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6a21\u5757");
        }
        Long moduleId = ((Module)moduleOptional.get()).getId();
        TtlRunnable runnable = TtlRunnable.get(() -> this.codeGenForMultiTenantExecutor.doGen1(app, moduleId, appVersion));
        TtlRunnable runnable2 = TtlRunnable.get(() -> this.codeGenForMultiTenantExecutor.doGen2(app, moduleId, appVersion, tenantAppVersionMap));
        TtlRunnable runnable3 = TtlRunnable.get(() -> this.codeGenForMultiTenantExecutor.doGen3(app, moduleId, appVersion, tenantAppVersionMap));
        this.threadPool.execute((Runnable)runnable3);
        this.threadPool.execute((Runnable)runnable2);
        this.threadPool.execute((Runnable)runnable);
        return ServiceResponse.success((String)"");
    }
}

