/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.service.impl;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppService;
import com.xforceplus.ultraman.metadata.generate.base.ddlgen.DdlGenBaseExecutor;
import com.xforceplus.ultraman.metadata.generate.service.IDdlGenService;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DdlGenServiceImpl
implements IDdlGenService {
    @Autowired
    private IAppService appService;
    @Autowired
    private DdlGenBaseExecutor ddlGenBaseExecutor;

    @Override
    public String genDdlByAppVersion(Long appId, Long appVersionId) {
        App app = (App)this.appService.getById((Serializable)appId);
        if (app == null) {
            return "\u67e5\u8be2\u4e0d\u5230\u5e94\u7528";
        }
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.ddlGenBaseExecutor.genDdlListByAppVersion(appVersionId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61";
        }
        return this.generateSqlString(tpl);
    }

    @Override
    public String genDdlByDiff(Long appId, Long currentVersionId, Long comparedVersionId) {
        App app = (App)this.appService.getById((Serializable)appId);
        if (app == null) {
            return "\u67e5\u8be2\u4e0d\u5230\u5e94\u7528";
        }
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.ddlGenBaseExecutor.genDdlListByDiff(currentVersionId, comparedVersionId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u6ca1\u6709\u5dee\u5f02\uff0c\u4e0d\u9700\u8981\u66f4\u65b0";
        }
        return this.generateSqlString(tpl);
    }

    @Override
    public String genDdlNewest(Long appId) {
        App app = (App)this.appService.getById((Serializable)appId);
        if (app == null) {
            return "\u67e5\u8be2\u4e0d\u5230\u5e94\u7528";
        }
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.ddlGenBaseExecutor.genDdlListNewest(appId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61";
        }
        return this.generateSqlString(tpl);
    }

    private String generateSqlString(Tuple2<List<StringBuffer>, List<StringBuffer>> tpl) {
        StringBuffer resultSql = new StringBuffer();
        resultSql.append("# \u540c\u6b65\u5143\u6570\u636e\u7ed3\u6784DDL").append("\n");
        resultSql.append(((List)tpl._1).stream().collect(Collectors.joining()));
        resultSql.append("\n").append("/* \u7528\u4e8e\u56de\u6eda\u4e0a\u9762\u7684DDL\uff0c\u614e\u7528\uff01").append("\n");
        resultSql.append(((List)tpl._2).stream().collect(Collectors.joining()));
        resultSql.append("*/");
        return resultSql.toString();
    }
}

