/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.service.impl;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.generate.base.ddlgen.TenantDdlGenExecutor;
import com.xforceplus.ultraman.metadata.generate.service.ITenantDdlGenService;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import io.vavr.Tuple2;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantDdlGenServiceImpl
implements ITenantDdlGenService {
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private TenantDdlGenExecutor tenantDdlGenExecutor;

    @Override
    public String genDdlByAppVersion(Long appId, Long appVersionId) {
        App app = this.appRepository.getAppWithValidate(appId.longValue());
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.tenantDdlGenExecutor.genDdlListByAppVersion(appVersionId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u6ca1\u6709\u5dee\u5f02\uff0c\u4e0d\u9700\u8981\u66f4\u65b0";
        }
        return this.generateSqlString(tpl);
    }

    @Override
    public String genDdlByDiff(Long appId, Long currentVersionId, Long comparedVersionId) {
        App app = this.appRepository.getAppWithValidate(appId.longValue());
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.tenantDdlGenExecutor.genDdlListByDiff(currentVersionId, comparedVersionId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u6ca1\u6709\u5dee\u5f02\uff0c\u4e0d\u9700\u8981\u66f4\u65b0";
        }
        return this.generateSqlString(tpl);
    }

    @Override
    public String genDdlNewest(Long appId) {
        App app = this.appRepository.getAppWithValidate(appId.longValue());
        String appCodeForDB = AppDBUtil.getAppCodeForDB((String)app.getCode());
        Tuple2<List<StringBuffer>, List<StringBuffer>> tpl = this.tenantDdlGenExecutor.genDdlListNewest(appId, appCodeForDB);
        if (((List)tpl._1).isEmpty()) {
            return "\u6ca1\u6709\u5dee\u5f02\uff0c\u4e0d\u9700\u8981\u66f4\u65b0";
        }
        return this.generateSqlString(tpl);
    }

    private String generateSqlString(Tuple2<List<StringBuffer>, List<StringBuffer>> tpl) {
        StringBuffer resultSql = new StringBuffer();
        resultSql.append("# \u540c\u6b65\u5143\u6570\u636e\u7ed3\u6784DDL").append("\n");
        resultSql.append(String.join((CharSequence)"", (Iterable)tpl._1));
        resultSql.append("\n").append("/* \u7528\u4e8e\u56de\u6eda\u4e0a\u9762\u7684DDL\uff0c\u614e\u7528\uff01").append("\n");
        resultSql.append(String.join((CharSequence)"", (Iterable)tpl._2));
        resultSql.append("*/");
        return resultSql.toString();
    }
}

