/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.util;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.global.common.util.AppUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CodeGenUtil {
    public static String getOutputDir() {
        return CodeGenUtil.getOutputDir(CodeGenUtil.getDateHour());
    }

    public static String getOutputDir(String dateHour) {
        String osName = System.getProperty("os.name");
        if (StringUtils.isNotEmpty((CharSequence)osName)) {
            if (osName.contains("Mac")) {
                return "/tmp";
            }
            if (osName.contains("Windows")) {
                return "D:\\ultraman\\";
            }
        }
        return "/ultraman/" + dateHour;
    }

    public static String getAppDir(App app) {
        return CodeGenUtil.buildAppDir(app, CodeGenUtil.getDateHour(), false);
    }

    public static String getAppDirForSdk(App app) {
        return CodeGenUtil.buildAppDir(app, CodeGenUtil.getDateHour(), true);
    }

    public static String getDateHour() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHH");
    }

    private static String buildAppDir(App app, String dataHour, boolean isForSdk) {
        String appCode = AppUtil.getLowerHyphenAppCode((String)app.getCode());
        String outputDir = CodeGenUtil.getOutputDir(dataHour);
        String osName = System.getProperty("os.name");
        if (StringUtils.isNotEmpty((CharSequence)osName) && osName.contains("Windows")) {
            String appDir = isForSdk ? String.format("%s\\%s\\%s-metadata\\pom.xml", outputDir, appCode, appCode) : String.format("%s\\%s\\ultraman\\pom.xml", outputDir, appCode);
            return appDir;
        }
        String appDir = isForSdk ? String.format("%s/ultraman/%s/%s-metadata/pom.xml", outputDir, appCode, appCode) : String.format("%s/ultraman/%s/pom.xml", outputDir, appCode);
        return appDir;
    }
}

