/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.global.common.util;

import com.google.common.base.CaseFormat;
import com.xforceplus.ultraman.metadata.global.common.util.TenantUtil;
import org.apache.commons.lang3.StringUtils;

public class AppDBUtil {
    public static final String HYPHEN = "-";
    public static final String TABLE_FORMAT = "oqs_%s_%s";
    public static final String TABLE_VIEW_SUFFIX_FORMAT = "%s_view";

    public static String getAppCodeForDB(String appCode) {
        String appCodeForDB = appCode.contains(HYPHEN) ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, appCode) : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, appCode);
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, appCodeForDB);
    }

    public static String getTableName(String appCode, String boCode) {
        String appCodeForDB = AppDBUtil.getAppCodeForDB(appCode);
        return String.format(TABLE_FORMAT, appCodeForDB, boCode);
    }

    public static String getTableName(String appCode, String boCode, String tenantCode) {
        String appCodeForDB = AppDBUtil.getAppCodeForDB(appCode);
        String tenantBoCode = AppDBUtil.getTenantBoCode(boCode, tenantCode);
        return String.format(TABLE_FORMAT, appCodeForDB, tenantBoCode);
    }

    public static String getTableViewName(String appCode, String boCode) {
        String tableName = AppDBUtil.getTableName(appCode, boCode);
        return AppDBUtil.getTableViewName(tableName);
    }

    public static String getTableViewName(String tableName) {
        return String.format(TABLE_VIEW_SUFFIX_FORMAT, tableName);
    }

    public static String getWriteTableName(String appCode, String boCode) {
        return AppDBUtil.getTableName(appCode, boCode);
    }

    public static String getReadTableName(String appCode, String boCode) {
        String tableName = AppDBUtil.getTableName(appCode, boCode);
        return AppDBUtil.getTableViewName(tableName);
    }

    public static String getWriteTableName(String appCode, String boCode, String tenantCode) {
        if (!StringUtils.isEmpty((CharSequence)tenantCode)) {
            boCode = AppDBUtil.getTenantBoCode(boCode, tenantCode);
        }
        return AppDBUtil.getTableName(appCode, boCode);
    }

    public static String getReadTableName(String appCode, String boCode, String tenantCode) {
        if (!StringUtils.isEmpty((CharSequence)tenantCode)) {
            boCode = AppDBUtil.getTenantBoCode(boCode, tenantCode);
        }
        String tableName = AppDBUtil.getTableName(appCode, boCode);
        return AppDBUtil.getTableViewName(tableName);
    }

    public static String getTenantBoCode(String boCode, String tenantCode) {
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return boCode;
        }
        tenantCode = TenantUtil.convertSpecialSymbolToUnderscore(tenantCode);
        return String.format("%s_%s", boCode, tenantCode);
    }
}

