/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.jsonschema.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum SchemaMetadataType {
    APP("app", "\u5e94\u7528", "apps"),
    DICT("dict", "\u679a\u4e3e", "dicts"),
    ENTITY("entity", "\u5bf9\u8c61", "entities"),
    PAGE("page", "\u89c6\u56fe", "pages"),
    FORM("form", "\u89c6\u56fe", "forms"),
    FLOW("flow", "\u6d41\u7a0b", "flows"),
    ACTION("action", "ACTION", "actions"),
    API("api", "API", "apis"),
    RULE("rule", "\u89c4\u5219", "rules"),
    TAG("tag", "\u6807\u7b7e", "tags"),
    APP_EVENT("appEvent", "\u5e94\u7528\u4e8b\u4ef6", "appEvents"),
    SDK_SETTING("sdkSetting", "SDK\u914d\u7f6e", "sdkSettings"),
    PAGE_SETTING("pageSetting", "\u9875\u9762\u914d\u7f6e", "pageSettings");

    private String code;
    private String desc;
    private String plural;

    private SchemaMetadataType(String code, String desc, String plural) {
        this.code = code;
        this.desc = desc;
        this.plural = plural;
    }

    public String code() {
        return this.code;
    }

    public String plural() {
        return this.plural;
    }

    public static SchemaMetadataType fromCode(String code) {
        return Arrays.stream(SchemaMetadataType.values()).filter(t -> t.code.equals(code)).findAny().orElse(null);
    }

    public static List<SchemaMetadataType> getTypesHaveTenant() {
        return Arrays.asList(ENTITY, DICT, PAGE, FORM, FLOW);
    }

    public static List<String> getTypeCodesHaveTenant() {
        return SchemaMetadataType.getTypesHaveTenant().stream().map(SchemaMetadataType::code).collect(Collectors.toList());
    }
}

