/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.jsonschema.service.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.metadata.jsonschema.core.MetadataSchemaManager;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.mapstruct.SchemaStructMapper;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAction;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppEvent;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaFlow;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaForm;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaPage;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaRule;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTag;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantPage;
import com.xforceplus.ultraman.metadata.jsonschema.service.IJsonSchemaService;
import com.xforceplus.ultraman.metadata.jsonschema.service.IMetadataManageService;
import com.xforceplus.ultraman.metadata.jsonschema.vo.SchemaContextVo;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisAuthTplEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisAuthTplRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEventRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoIndexRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionParamRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SdkSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleParamRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueTagRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class JsonSchemaServiceImpl
implements IJsonSchemaService {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaServiceImpl.class);
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoApiRepository boApiRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoIndexRepository boIndexRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private FlowActionRepository flowActionRepository;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private FlowActionParamRepository flowActionParamRepository;
    @Autowired
    private ApisRepository apisRepository;
    @Autowired
    private ApisAuthTplRepository apisAuthTplRepository;
    @Autowired
    private ApisAuthTplEnvRepository apisAuthTplEnvRepository;
    @Autowired
    private SueRuleRepository sueRuleRepository;
    @Autowired
    private SueRuleParamRepository sueRuleParamRepository;
    @Autowired
    private SueTagRepository sueTagRepository;
    @Autowired
    private MetadataSchemaManager metadataSchemaManager;
    @Autowired
    private IMetadataManageService metadataManageService;
    @Autowired
    private AppEventRepository appEventRepository;
    @Autowired
    private SdkSettingRepository sdkSettingRepository;

    @Override
    public ServiceResponse getSchemaAppData(SchemaContextVo schemaContext) {
        Optional<SchemaApp> schemaAppOptl = this.buildSchemaApp(schemaContext);
        if (schemaAppOptl.isPresent()) {
            return this.metadataSchemaManager.validate(schemaAppOptl.get());
        }
        return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createAppBySchema(SchemaContextVo schemaContext, MultipartFile file) {
        SchemaApp schemaApp = this.metadataSchemaManager.convertFileToSchemaApp(file);
        ServiceResponse serviceResponse = this.metadataSchemaManager.validate(schemaApp);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        Optional appOptl = this.appRepository.getApp(schemaApp.getCode());
        if (appOptl.isPresent()) {
            return ServiceResponse.fail((String)"\u5e94\u7528\u4ee3\u7801\u5df2\u5b58\u5728");
        }
        List<SchemaBo> schemaBos = this.filterSchemaBos(schemaApp.getBos(), schemaContext.getIncludeBoIds(), schemaContext.getExcludeBoIds());
        List<SchemaDict> schemaDicts = this.filterSchemaDicts(schemaApp.getDicts(), schemaContext.getIncludeDictIds(), schemaContext.getExcludeDictIds());
        schemaApp.setBos(schemaBos);
        schemaApp.setDicts(schemaDicts);
        return this.metadataManageService.createApp(schemaApp);
    }

    @Override
    public ServiceResponse updateAppBySchema(SchemaContextVo schemaContext, MultipartFile file) {
        SchemaApp schemaApp = this.metadataSchemaManager.convertFileToSchemaApp(file);
        ServiceResponse serviceResponse = this.metadataSchemaManager.validate(schemaApp);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        Optional appOptl = this.appRepository.getApp(schemaContext.getAppId().longValue());
        if (!appOptl.isPresent()) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528");
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("updateAppBySchema");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.DICT)) {
                List<SchemaDict> schemaDicts = this.filterSchemaDicts(schemaApp.getDicts(), schemaContext.getIncludeDictIds(), schemaContext.getExcludeDictIds());
                serviceResponse = this.metadataManageService.createDicts(schemaContext.getAppId(), schemaDicts);
                if (!serviceResponse.isSuccess()) {
                    throw new RuntimeException(serviceResponse.getMessage());
                }
            }
            if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ENTITY)) {
                List<SchemaBo> schemaBos = this.filterSchemaBos(schemaApp.getBos(), schemaContext.getIncludeBoIds(), schemaContext.getExcludeBoIds());
                serviceResponse = this.metadataManageService.createBos((App)appOptl.get(), schemaBos);
                if (!serviceResponse.isSuccess()) {
                    throw new RuntimeException(serviceResponse.getMessage());
                }
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ACTION)) && !(serviceResponse = this.metadataManageService.createActions(schemaContext.getAppId(), schemaApp.getActions())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.API)) && !(serviceResponse = this.metadataManageService.createApis(schemaContext.getAppId(), schemaApp.getApis())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.RULE)) && !(serviceResponse = this.metadataManageService.createRules(schemaContext.getAppId(), schemaApp.getRules())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.TAG)) && !(serviceResponse = this.metadataManageService.createTags(schemaContext.getAppId(), schemaApp.getTags())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.APP_EVENT)) && !(serviceResponse = this.metadataManageService.createAppEvents(schemaContext.getAppId(), schemaApp.getAppEvents())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
            if ((CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.SDK_SETTING)) && !(serviceResponse = this.metadataManageService.createSdkSettings(schemaContext.getAppId(), schemaApp.getSdkSettings())).isSuccess()) {
                throw new RuntimeException(serviceResponse.getMessage());
            }
        }
        catch (RuntimeException ex) {
            this.transactionManager.rollback(status);
            return ServiceResponse.fail((String)ex.getMessage());
        }
        this.transactionManager.commit(status);
        return serviceResponse;
    }

    private Optional<SchemaApp> buildSchemaApp(SchemaContextVo schemaContext) {
        Optional appOptl = this.appRepository.getApp(schemaContext.getAppId().longValue());
        if (!appOptl.isPresent()) {
            return Optional.empty();
        }
        SchemaApp appSchema = SchemaStructMapper.MAPPER.toSchemaApp((App)appOptl.get());
        boolean isEmptyType = CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes());
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.DICT)) {
            List dicts = this.dictRepository.getDicts(schemaContext.getAppId());
            if (!schemaContext.getIsIncludeSystemScope().booleanValue()) {
                dicts = dicts.stream().filter(dict -> !SysType.SYSTEM.code().equals(dict.getSystemType())).collect(Collectors.toList());
            }
            List<SchemaDict> schemaDicts = this.buildSchemaDicts(dicts, schemaContext.getIncludeDictIds(), schemaContext.getExcludeDictIds());
            appSchema.setDicts(schemaDicts);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ENTITY)) {
            List bos = this.boRepository.getBos(schemaContext.getAppId().longValue());
            if (!schemaContext.getIsIncludeSystemScope().booleanValue()) {
                bos = bos.stream().filter(bo -> !SysType.SYSTEM.code().equals(bo.getSysType())).collect(Collectors.toList());
            }
            List<SchemaBo> schemaBos = this.buildSchemaBos(bos, schemaContext.getIncludeBoIds(), schemaContext.getExcludeBoIds());
            appSchema.setBos(schemaBos);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.PAGE)) {
            List pages = this.ultPageRepository.getPages(schemaContext.getAppId());
            List<SchemaPage> schemaPages = this.buildSchemaPages(pages);
            appSchema.setPages(schemaPages);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.FORM)) {
            List forms = this.ultFormRepository.getForms(schemaContext.getAppId());
            List<SchemaForm> schemaForms = this.buildSchemaForms(forms);
            appSchema.setForms(schemaForms);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ACTION)) {
            List actions = this.flowActionRepository.getFlowActions(schemaContext.getAppId());
            List<SchemaAction> schemaActions = this.buildSchemaActions(actions, schemaContext.getIncludeActionIds(), schemaContext.getExcludeActionIds());
            appSchema.setActions(schemaActions);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.API)) {
            List apis = this.apisRepository.getApis(schemaContext.getAppId());
            List<SchemaApi> schemaApis = this.buildSchemaApis(apis, schemaContext.getIncludeApiIds(), schemaContext.getExcludeApiIds());
            appSchema.setApis(schemaApis);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.RULE)) {
            List rules = this.sueRuleRepository.getSueRules(schemaContext.getAppId());
            List<SchemaRule> schemaRules = this.buildSchemaRules(rules, schemaContext.getIncludeRuleIds(), schemaContext.getExcludeRuleIds());
            appSchema.setRules(schemaRules);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.TAG)) {
            List tags = this.sueTagRepository.getSueTags(schemaContext.getAppId());
            List<SchemaTag> schemaTags = this.buildSchemaTags(tags, schemaContext.getIncludeTagIds(), schemaContext.getExcludeTagIds());
            appSchema.setTags(schemaTags);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.FLOW)) {
            List flowSettingsWithoutFrontSetting = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(schemaContext.getAppId());
            List<SchemaFlow> schemaFlows = this.buildSchemaFlowSettings(flowSettingsWithoutFrontSetting);
            appSchema.setFlowSettings(schemaFlows);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.APP_EVENT)) {
            List appEvents = this.appEventRepository.getAppEvents(schemaContext.getAppId());
            List<SchemaAppEvent> schemaAppEvents = this.buildSchemaAppEvents(appEvents);
            appSchema.setAppEvents(schemaAppEvents);
        }
        if (isEmptyType || schemaContext.getMetadataTypes().contains(SchemaMetadataType.SDK_SETTING)) {
            List sdkSettings = this.sdkSettingRepository.getSdkSettings(schemaContext.getAppId());
            List<SchemaSdkSetting> schemaSdkSettings = this.buildSchemaSdkSettings(sdkSettings);
            appSchema.setSdkSettings(schemaSdkSettings);
        }
        return Optional.ofNullable(appSchema);
    }

    private List<SchemaBo> buildSchemaBos(List<Bo> bos, Long[] includeBoIds, Long[] excludeBoIds) {
        List mainBos = bos.stream().filter(bo -> StringUtils.isEmpty((Object)bo.getRefBoId())).collect(Collectors.toList());
        Map<Long, List<Bo>> tenantBoMap = bos.stream().filter(bo -> !StringUtils.isEmpty((Object)bo.getRefBoId())).collect(Collectors.groupingBy(Bo::getRefBoId));
        List<SchemaBo> schemaBos = mainBos.stream().map(bo -> {
            SchemaBo schemaBo = this.buildSchemaBo((Bo)bo);
            if (tenantBoMap.containsKey(bo.getId())) {
                schemaBo.setTenantBos(((List)tenantBoMap.get(bo.getId())).stream().map(tenantBo -> this.buildSchemaTenantBo((Bo)tenantBo)).collect(Collectors.toList()));
            }
            return schemaBo;
        }).collect(Collectors.toList());
        return this.filterSchemaBos(schemaBos, includeBoIds, excludeBoIds);
    }

    private List<SchemaDict> buildSchemaDicts(List<Dict> dicts, Long[] includeDictIds, Long[] excludeDictIds) {
        List mainDicts = dicts.stream().filter(dict -> StringUtils.isEmpty((Object)dict.getTenantCode())).collect(Collectors.toList());
        Map<String, List<Dict>> tenantDictMap = dicts.stream().filter(dict -> !StringUtils.isEmpty((Object)dict.getTenantCode())).collect(Collectors.groupingBy(Dict::getCode));
        List<SchemaDict> schemaDicts = mainDicts.stream().map(dict -> {
            SchemaDict schemaDict = this.buildSchemaDict((Dict)dict);
            if (tenantDictMap.containsKey(dict.getCode())) {
                schemaDict.setTenantDicts(((List)tenantDictMap.get(dict.getCode())).stream().map(tenantDict -> this.buildSchemaTenantDict((Dict)tenantDict)).collect(Collectors.toList()));
            }
            return schemaDict;
        }).collect(Collectors.toList());
        return this.filterSchemaDicts(schemaDicts, includeDictIds, excludeDictIds);
    }

    private List<SchemaPage> buildSchemaPages(List<UltPage> pages) {
        List mainPages = pages.stream().filter(page -> StringUtils.isEmpty((Object)page.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltPage>> tenantMap = pages.stream().filter(page -> !StringUtils.isEmpty((Object)page.getTenantCode())).collect(Collectors.groupingBy(UltPage::getRefPageId));
        return mainPages.stream().map(page -> {
            SchemaPage schemaPage = this.buildSchemaPage((UltPage)page);
            if (tenantMap.containsKey(page.getId())) {
                schemaPage.setTenantPages(((List)tenantMap.get(page.getId())).stream().map(tenantPage -> this.buildSchemaTenantPage((UltPage)tenantPage)).collect(Collectors.toList()));
            }
            return schemaPage;
        }).collect(Collectors.toList());
    }

    private List<SchemaForm> buildSchemaForms(List<UltForm> forms) {
        List mainFlows = forms.stream().filter(form -> StringUtils.isEmpty((Object)form.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltForm>> tenantMap = forms.stream().filter(form -> !StringUtils.isEmpty((Object)form.getTenantCode())).collect(Collectors.groupingBy(UltForm::getRefFormId));
        return mainFlows.stream().map(form -> {
            SchemaForm schemaForm = SchemaStructMapper.MAPPER.toSchemaForm(form);
            if (tenantMap.containsKey(form.getId())) {
                schemaForm.setTenantForms(((List)tenantMap.get(form.getId())).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantForm(arg_0)).collect(Collectors.toList()));
            }
            return schemaForm;
        }).collect(Collectors.toList());
    }

    private List<SchemaAction> buildSchemaActions(List<FlowAction> entitys, Long[] includeIds, Long[] excludeIds) {
        List<SchemaAction> schemaItems = entitys.stream().map(entity -> this.buildSchemaAction((FlowAction)entity)).collect(Collectors.toList());
        return this.filterSchemaActions(schemaItems, includeIds, excludeIds);
    }

    private List<SchemaApi> buildSchemaApis(List<Apis> entitys, Long[] includeIds, Long[] excludeIds) {
        List<SchemaApi> schemaItems = entitys.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaApi(arg_0)).collect(Collectors.toList());
        return this.filterSchemaApis(schemaItems, includeIds, excludeIds);
    }

    private List<SchemaRule> buildSchemaRules(List<SueRule> entitys, Long[] includeIds, Long[] excludeIds) {
        List<SchemaRule> schemaItems = entitys.stream().map(entity -> this.buildSchemaRule((SueRule)entity)).collect(Collectors.toList());
        return this.filterSchemaRules(schemaItems, includeIds, excludeIds);
    }

    private List<SchemaTag> buildSchemaTags(List<SueTag> entitys, Long[] includeIds, Long[] excludeIds) {
        return entitys.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTag(arg_0)).collect(Collectors.toList());
    }

    private List<SchemaFlow> buildSchemaFlowSettings(List<FlowSetting> flowSettings) {
        List mainFlows = flowSettings.stream().filter(flow -> StringUtils.isEmpty((Object)flow.getTenantCode())).collect(Collectors.toList());
        Map<String, List<FlowSetting>> tenantMap = flowSettings.stream().filter(flow -> !StringUtils.isEmpty((Object)flow.getTenantCode())).collect(Collectors.groupingBy(FlowSetting::getCode));
        return mainFlows.stream().map(flow -> {
            SchemaFlow schemaFlow = SchemaStructMapper.MAPPER.toSchemaFlow(flow);
            if (tenantMap.containsKey(flow.getCode())) {
                schemaFlow.setTenantFlows(((List)tenantMap.get(flow.getCode())).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantFlow(arg_0)).collect(Collectors.toList()));
            }
            return schemaFlow;
        }).collect(Collectors.toList());
    }

    private List<SchemaSdkSetting> buildSchemaSdkSettings(List<SdkSetting> sdkSettings) {
        return sdkSettings.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaSdkSetting(arg_0)).collect(Collectors.toList());
    }

    private List<SchemaAppEvent> buildSchemaAppEvents(List<AppEvent> appEvents) {
        List mainAppEvents = appEvents.stream().filter(event -> StringUtils.isEmpty((Object)event.getTenantCode())).collect(Collectors.toList());
        Map<String, List<AppEvent>> tenantMap = appEvents.stream().filter(flow -> !StringUtils.isEmpty((Object)flow.getTenantCode())).collect(Collectors.groupingBy(AppEvent::getEventCode));
        return mainAppEvents.stream().map(appEvent -> {
            SchemaAppEvent schemaAppEvent = SchemaStructMapper.MAPPER.toSchemaAppEvent(appEvent);
            if (tenantMap.containsKey(appEvent.getEventCode())) {
                schemaAppEvent.setTenantAppEvents(((List)tenantMap.get(appEvent.getEventCode())).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantAppEvent(arg_0)).collect(Collectors.toList()));
            }
            return schemaAppEvent;
        }).collect(Collectors.toList());
    }

    private SchemaBo buildSchemaBo(Bo bo) {
        SchemaBo schemaBo = SchemaStructMapper.MAPPER.toSchemaBo(bo);
        List schemaBoFields = this.boFieldRepository.getBoFieldsWithDetail(bo.getId()).stream().map(tpl -> SchemaStructMapper.MAPPER.toSchemaBoField((BoField)tpl._1, (BoFieldAttribute)tpl._2, (BoFieldDomainAttribute)tpl._3, (BoFieldValidate)tpl._4)).collect(Collectors.toList());
        List schemaBoRelationships = this.boRelationshipRepository.getBoRelationships(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoRelationship(arg_0)).collect(Collectors.toList());
        List schemaBoApis = this.boApiRepository.getBoApisWithDetail(bo.getId()).stream().map(tpl -> {
            SchemaBoApi schemaBoApi = SchemaStructMapper.MAPPER.toSchemaBoApi((BoApi)tpl._1);
            List schemaBoApiDetails = ((List)tpl._2).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoApiDetail(arg_0)).collect(Collectors.toList());
            schemaBoApi.setDetails(schemaBoApiDetails);
            return schemaBoApi;
        }).collect(Collectors.toList());
        List schemaBoIndexes = this.boIndexRepository.getBoIndexes(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoIndex(arg_0)).collect(Collectors.toList());
        List schemaBoDataRules = this.dataRuleRepository.getDefaultDataRule(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoDataRule(arg_0)).collect(Collectors.toList());
        schemaBo.setBoFields(schemaBoFields);
        schemaBo.setBoRelationships(schemaBoRelationships);
        schemaBo.setBoIndexes(schemaBoIndexes);
        schemaBo.setBoApis(schemaBoApis);
        schemaBo.setBoDataRules(schemaBoDataRules);
        return schemaBo;
    }

    private SchemaTenantBo buildSchemaTenantBo(Bo bo) {
        SchemaTenantBo schemaBo = SchemaStructMapper.MAPPER.toSchemaTenantBo(bo);
        List schemaBoFields = this.boFieldRepository.getBoFieldsWithDetail(bo.getId()).stream().map(tpl -> SchemaStructMapper.MAPPER.toSchemaBoField((BoField)tpl._1, (BoFieldAttribute)tpl._2, (BoFieldDomainAttribute)tpl._3, (BoFieldValidate)tpl._4)).collect(Collectors.toList());
        List schemaBoRelationships = this.boRelationshipRepository.getBoRelationships(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoRelationship(arg_0)).collect(Collectors.toList());
        List schemaBoApis = this.boApiRepository.getBoApisWithDetail(bo.getId()).stream().map(tpl -> {
            SchemaBoApi schemaBoApi = SchemaStructMapper.MAPPER.toSchemaBoApi((BoApi)tpl._1);
            List schemaBoApiDetails = ((List)tpl._2).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoApiDetail(arg_0)).collect(Collectors.toList());
            schemaBoApi.setDetails(schemaBoApiDetails);
            return schemaBoApi;
        }).collect(Collectors.toList());
        List schemaBoIndexes = this.boIndexRepository.getBoIndexes(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoIndex(arg_0)).collect(Collectors.toList());
        List schemaBoDataRules = this.dataRuleRepository.getDefaultDataRule(bo.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoDataRule(arg_0)).collect(Collectors.toList());
        schemaBo.setBoFields(schemaBoFields);
        schemaBo.setBoRelationships(schemaBoRelationships);
        schemaBo.setBoIndexes(schemaBoIndexes);
        schemaBo.setBoApis(schemaBoApis);
        schemaBo.setBoDataRules(schemaBoDataRules);
        return schemaBo;
    }

    private SchemaDict buildSchemaDict(Dict dict) {
        SchemaDict schemaDict = SchemaStructMapper.MAPPER.toSchemaDict(dict);
        List schemaDictDetails = this.dictDetailRepository.getDictDetails(dict.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaDictDetail(arg_0)).collect(Collectors.toList());
        schemaDict.setDetails(schemaDictDetails);
        return schemaDict;
    }

    private SchemaPage buildSchemaPage(UltPage page) {
        SchemaPage schemaPage = SchemaStructMapper.MAPPER.toSchemaPage(page);
        List schemaPageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(page.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaPageBoSetting(arg_0)).collect(Collectors.toList());
        schemaPage.setPageBoSettings(schemaPageBoSettings);
        return schemaPage;
    }

    private SchemaAction buildSchemaAction(FlowAction entity) {
        SchemaAction schemaItem = SchemaStructMapper.MAPPER.toSchemaAction(entity);
        List schemaSubItems = this.flowActionParamRepository.getActionParams(entity.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaActionParam(arg_0)).collect(Collectors.toList());
        schemaItem.setParams(schemaSubItems);
        return schemaItem;
    }

    private SchemaRule buildSchemaRule(SueRule entity) {
        SchemaRule schemaItem = SchemaStructMapper.MAPPER.toSchemaRule(entity);
        List schemaSubItems = this.sueRuleParamRepository.getRuleParams(entity.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaRuleParam(arg_0)).collect(Collectors.toList());
        schemaItem.setParams(schemaSubItems);
        return schemaItem;
    }

    private SchemaTenantDict buildSchemaTenantDict(Dict dict) {
        SchemaTenantDict schemaDict = SchemaStructMapper.MAPPER.toSchemaTenantDict(dict);
        List schemaDictDetails = this.dictDetailRepository.getDictDetails(dict.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaDictDetail(arg_0)).collect(Collectors.toList());
        schemaDict.setDetails(schemaDictDetails);
        return schemaDict;
    }

    private SchemaTenantPage buildSchemaTenantPage(UltPage page) {
        SchemaTenantPage schemaPage = SchemaStructMapper.MAPPER.toSchemaTenantPage(page);
        List schemaPageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(page.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaPageBoSetting(arg_0)).collect(Collectors.toList());
        schemaPage.setPageBoSettings(schemaPageBoSettings);
        return schemaPage;
    }

    private List<SchemaBo> filterSchemaBos(List<SchemaBo> schemaBos, Long[] includeBoIds, Long[] excludeBoIds) {
        if (null != includeBoIds && includeBoIds.length > 0) {
            return schemaBos.stream().filter(b -> Arrays.asList(includeBoIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        if (null != excludeBoIds && excludeBoIds.length > 0) {
            return schemaBos.stream().filter(b -> !Arrays.asList(excludeBoIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        return schemaBos;
    }

    private List<SchemaDict> filterSchemaDicts(List<SchemaDict> schemaDicts, Long[] includeDictIds, Long[] excludeDictIds) {
        if (null != includeDictIds && includeDictIds.length > 0) {
            return schemaDicts.stream().filter(b -> Arrays.asList(includeDictIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        if (null != excludeDictIds && excludeDictIds.length > 0) {
            return schemaDicts.stream().filter(b -> !Arrays.asList(excludeDictIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        return schemaDicts;
    }

    private List<SchemaAction> filterSchemaActions(List<SchemaAction> schemaEntitys, Long[] includeIds, Long[] excludeIds) {
        if (null != includeIds && includeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> Arrays.asList(includeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        if (null != excludeIds && excludeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> !Arrays.asList(excludeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        return schemaEntitys;
    }

    private List<SchemaApi> filterSchemaApis(List<SchemaApi> schemaEntitys, Long[] includeIds, Long[] excludeIds) {
        if (null != includeIds && includeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> Arrays.asList(includeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        if (null != excludeIds && excludeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> !Arrays.asList(excludeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        return schemaEntitys;
    }

    private List<SchemaRule> filterSchemaRules(List<SchemaRule> schemaEntitys, Long[] includeIds, Long[] excludeIds) {
        if (null != includeIds && includeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> Arrays.asList(includeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        if (null != excludeIds && excludeIds.length > 0) {
            return schemaEntitys.stream().filter(b -> !Arrays.asList(excludeIds).contains(Long.valueOf(b.getId()))).collect(Collectors.toList());
        }
        return schemaEntitys;
    }
}

