/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.jsonschema.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.metadata.jsonschema.core.MetadataSchemaManager;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.mapstruct.SchemaStructMapper;
import com.xforceplus.ultraman.metadata.jsonschema.mapstruct.SchemaVersionStructMapper;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAction;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppEvent;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaFlow;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaForm;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaPage;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaRule;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTag;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantPage;
import com.xforceplus.ultraman.metadata.jsonschema.service.IJsonSchemaVersionService;
import com.xforceplus.ultraman.metadata.jsonschema.vo.SchemaContextVo;
import com.xforceplus.ultraman.metadata.repository.bocp.mapper.BoFieldExMapper;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoIndexRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionParamRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleParamRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsonSchemaVersionServiceImpl
implements IJsonSchemaVersionService {
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private BoApiRepository boApiRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoIndexRepository boIndexRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;
    @Autowired
    private FlowActionParamRepository flowActionParamRepository;
    @Autowired
    private SueRuleParamRepository sueRuleParamRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;
    @Autowired
    private MetadataSchemaManager metadataSchemaManager;
    @Autowired
    private BoFieldExMapper boFieldExMapper;
    private final ThreadLocal<Map<String, String>> idStrMapThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse getSchemaAppData(SchemaContextVo schemaContext) {
        try {
            Optional<SchemaApp> schemaAppOptl;
            if (null == this.idStrMapThreadLocal.get()) {
                this.idStrMapThreadLocal.set(Maps.newHashMap());
            }
            if ((schemaAppOptl = this.buildSchemaApp(schemaContext)).isPresent()) {
                ServiceResponse serviceResponse = this.metadataSchemaManager.validate(schemaAppOptl.get());
                return serviceResponse;
            }
            ServiceResponse serviceResponse = ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528");
            return serviceResponse;
        }
        finally {
            this.idStrMapThreadLocal.remove();
        }
    }

    private Optional<SchemaApp> buildSchemaApp(SchemaContextVo schemaContext) {
        Optional appOptl = this.appRepository.getApp(schemaContext.getAppId().longValue());
        if (!appOptl.isPresent()) {
            return Optional.empty();
        }
        SchemaApp appSchema = SchemaStructMapper.MAPPER.toSchemaApp((App)appOptl.get());
        appSchema.setVersion(schemaContext.getVersion());
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.DICT)) {
            List dicts = this.metadataVersionQuery.getDicts(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaDict> schemaDicts = this.buildSchemaDicts(dicts);
            appSchema.setDicts(schemaDicts);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ENTITY)) {
            List bos = this.metadataVersionQuery.getBos(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaBo> schemaBos = this.buildSchemaBos(bos);
            appSchema.setBos(schemaBos);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.PAGE)) {
            List pages = this.metadataVersionQuery.getPages(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaPage> schemaPages = this.buildSchemaPages(pages);
            appSchema.setPages(schemaPages);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.FORM)) {
            List forms = this.metadataVersionQuery.getForms(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaForm> schemaForms = this.buildSchemaForms(forms);
            appSchema.setForms(schemaForms);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.ACTION)) {
            List actions = this.metadataVersionQuery.getFlowActions(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaAction> schemaActions = this.buildSchemaActions(actions);
            appSchema.setActions(schemaActions);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.API)) {
            List apis = this.metadataVersionQuery.getApis(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaApi> schemaApis = this.buildSchemaApis(apis);
            appSchema.setApis(schemaApis);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.RULE)) {
            List rules = this.metadataVersionQuery.getRules(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaRule> schemaRules = this.buildSchemaRules(rules);
            appSchema.setRules(schemaRules);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.TAG)) {
            List tags = this.metadataVersionQuery.getTags(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaTag> schemaTags = this.buildSchemaTags(tags);
            appSchema.setTags(schemaTags);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.FLOW)) {
            List flows = this.metadataVersionQuery.getFlowSettings(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaFlow> schemaFlows = this.buildSchemaFlows(flows);
            appSchema.setFlowSettings(schemaFlows);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.APP_EVENT)) {
            List appEvents = this.metadataVersionQuery.getAppEvents(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaAppEvent> schemaAppEvents = this.buildSchemaAppEvents(appEvents);
            appSchema.setAppEvents(schemaAppEvents);
        }
        if (CollectionUtils.isEmpty((Collection)schemaContext.getMetadataTypes()) || schemaContext.getMetadataTypes().contains(SchemaMetadataType.SDK_SETTING)) {
            List sdkSettings = this.metadataVersionQuery.getSdkSettings(schemaContext.getAppId(), schemaContext.getVersion());
            List<SchemaSdkSetting> schemaSdkSettings = this.buildSchemaSdkSettings(sdkSettings);
            appSchema.setSdkSettings(schemaSdkSettings);
        }
        this.updateBoAndFieldId(appSchema);
        return Optional.ofNullable(appSchema);
    }

    private List<SchemaBo> buildSchemaBos(List<Bo> bos) {
        bos.forEach(b -> this.idStrMapThreadLocal.get().put(String.valueOf(b.getId()), String.valueOf(b.getPublishBoId())));
        List boIds = bos.stream().map(Bo::getId).collect(Collectors.toList());
        Map<Long, List<BoRelationship>> boRelationshipsMap = this.boRelationshipRepository.getBoRelationshipsByBoIds(boIds).stream().collect(Collectors.groupingBy(BoRelationship::getBoId));
        Map<Long, List<BoIndex>> boIndexesMap = this.boIndexRepository.getBoIndexesByBoIds(boIds).stream().collect(Collectors.groupingBy(BoIndex::getBoId));
        Map<Long, List<BoDataRule>> boDataRulesMap = this.dataRuleRepository.getDefaultDataRulesByBoIds(boIds).stream().collect(Collectors.groupingBy(BoDataRule::getBoId));
        boRelationshipsMap.values().forEach(l -> l.forEach(o -> this.idStrMapThreadLocal.get().put(String.valueOf(o.getId()), String.valueOf(o.getUniqueId()))));
        List mainBos = bos.stream().filter(bo -> null == bo.getRefBoId()).collect(Collectors.toList());
        Map<Long, List<Bo>> tenantBoMap = bos.stream().filter(bo -> null != bo.getRefBoId()).collect(Collectors.groupingBy(Bo::getRefBoId));
        return mainBos.stream().map(bo -> {
            SchemaBo schemaBo = this.buildSchemaBo((Bo)bo, (List)boRelationshipsMap.get(bo.getId()), (List)boIndexesMap.get(bo.getId()), (List)boDataRulesMap.get(bo.getId()));
            if (tenantBoMap.containsKey(bo.getId())) {
                schemaBo.setTenantBos(((List)tenantBoMap.get(bo.getId())).stream().map(tenantBo -> this.buildSchemaTenantBo((Bo)tenantBo, (List)boRelationshipsMap.get(tenantBo.getId()), (List)boIndexesMap.get(tenantBo.getId()), (List)boDataRulesMap.get(tenantBo.getId()))).collect(Collectors.toList()));
            }
            return schemaBo;
        }).collect(Collectors.toList());
    }

    private List<SchemaDict> buildSchemaDicts(List<Dict> dicts) {
        dicts.forEach(d -> this.idStrMapThreadLocal.get().put(String.valueOf(d.getId()), String.valueOf(d.getPublishDictId())));
        List mainDicts = dicts.parallelStream().filter(dict -> StringUtils.isEmpty((CharSequence)dict.getTenantCode())).collect(Collectors.toList());
        Map<String, List<Dict>> tenantDictMap = dicts.stream().filter(dict -> !StringUtils.isEmpty((CharSequence)dict.getTenantCode())).collect(Collectors.groupingBy(Dict::getCode));
        return mainDicts.stream().map(dict -> {
            SchemaDict schemaDict = this.buildSchemaDict((Dict)dict);
            if (tenantDictMap.containsKey(dict.getCode())) {
                schemaDict.setTenantDicts(((List)tenantDictMap.get(dict.getCode())).stream().map(tenantDict -> this.buildSchemaTenantDict((Dict)tenantDict)).collect(Collectors.toList()));
            }
            return schemaDict;
        }).collect(Collectors.toList());
    }

    private List<SchemaPage> buildSchemaPages(List<UltPage> pages) {
        pages.forEach(o -> this.idStrMapThreadLocal.get().put(String.valueOf(o.getId()), String.valueOf(o.getPublishRefPageId())));
        List mainPages = pages.parallelStream().filter(page -> StringUtils.isEmpty((CharSequence)page.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltPage>> tenantMap = pages.stream().filter(page -> !StringUtils.isEmpty((CharSequence)page.getTenantCode())).collect(Collectors.groupingBy(UltPage::getRefPageId));
        return mainPages.stream().map(page -> {
            SchemaPage schemaPage = this.buildSchemaPage((UltPage)page);
            if (tenantMap.containsKey(page.getId())) {
                schemaPage.setTenantPages(((List)tenantMap.get(page.getId())).stream().map(tenantPage -> this.buildSchemaTenantPage((UltPage)tenantPage)).collect(Collectors.toList()));
            }
            return schemaPage;
        }).collect(Collectors.toList());
    }

    private List<SchemaForm> buildSchemaForms(List<UltForm> forms) {
        forms.forEach(o -> this.idStrMapThreadLocal.get().put(String.valueOf(o.getId()), String.valueOf(o.getPublishRefFormId())));
        List mainForms = forms.parallelStream().filter(form -> StringUtils.isEmpty((CharSequence)form.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltForm>> tenantMap = forms.stream().filter(form -> !StringUtils.isEmpty((CharSequence)form.getTenantCode())).collect(Collectors.groupingBy(UltForm::getRefFormId));
        return mainForms.stream().map(form -> {
            SchemaForm schemaForm = SchemaStructMapper.MAPPER.toSchemaForm(form);
            if (tenantMap.containsKey(form.getId())) {
                schemaForm.setTenantForms(((List)tenantMap.get(form.getId())).parallelStream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantForm(arg_0)).collect(Collectors.toList()));
            }
            return schemaForm;
        }).collect(Collectors.toList());
    }

    private List<SchemaAction> buildSchemaActions(List<FlowAction> entitys) {
        return entitys.stream().map(entity -> this.buildSchemaAction((FlowAction)entity)).collect(Collectors.toList());
    }

    private List<SchemaApi> buildSchemaApis(List<Apis> entitys) {
        return entitys.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaApi(arg_0)).collect(Collectors.toList());
    }

    private List<SchemaRule> buildSchemaRules(List<SueRule> entitys) {
        return entitys.stream().map(entity -> this.buildSchemaRule((SueRule)entity)).collect(Collectors.toList());
    }

    private List<SchemaTag> buildSchemaTags(List<SueTag> entitys) {
        return entitys.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTag(arg_0)).collect(Collectors.toList());
    }

    private List<SchemaFlow> buildSchemaFlows(List<FlowSetting> flowSettings) {
        flowSettings.forEach(o -> this.idStrMapThreadLocal.get().put(String.valueOf(o.getId()), String.valueOf(o.getPublishFlowId())));
        List mainFlows = flowSettings.parallelStream().filter(flow -> StringUtils.isEmpty((CharSequence)flow.getTenantCode())).collect(Collectors.toList());
        Map<String, List<FlowSetting>> tenantMap = flowSettings.stream().filter(flow -> !StringUtils.isEmpty((CharSequence)flow.getTenantCode())).collect(Collectors.groupingBy(FlowSetting::getCode));
        return mainFlows.stream().map(flow -> {
            SchemaFlow schemaFlow = SchemaStructMapper.MAPPER.toSchemaFlow(flow);
            if (tenantMap.containsKey(flow.getCode())) {
                schemaFlow.setTenantFlows(((List)tenantMap.get(flow.getCode())).parallelStream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantFlow(arg_0)).collect(Collectors.toList()));
            }
            return schemaFlow;
        }).collect(Collectors.toList());
    }

    private List<SchemaAppEvent> buildSchemaAppEvents(List<AppEvent> appEvents) {
        List mainAppEvents = appEvents.parallelStream().filter(event -> StringUtils.isEmpty((CharSequence)event.getTenantCode())).collect(Collectors.toList());
        Map<String, List<AppEvent>> tenantMap = appEvents.stream().filter(event -> !StringUtils.isEmpty((CharSequence)event.getTenantCode())).collect(Collectors.groupingBy(AppEvent::getEventCode));
        return mainAppEvents.stream().map(appEvent -> {
            SchemaAppEvent schemaAppEvent = SchemaStructMapper.MAPPER.toSchemaAppEvent(appEvent);
            if (tenantMap.containsKey(appEvent.getEventCode())) {
                schemaAppEvent.setTenantAppEvents(((List)tenantMap.get(appEvent.getEventCode())).parallelStream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaTenantAppEvent(arg_0)).collect(Collectors.toList()));
            }
            return schemaAppEvent;
        }).collect(Collectors.toList());
    }

    private List<SchemaSdkSetting> buildSchemaSdkSettings(List<SdkSetting> sdkSettings) {
        return sdkSettings.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaSdkSetting(arg_0)).collect(Collectors.toList());
    }

    private SchemaBo buildSchemaBo(Bo bo, List<BoRelationship> boRelationships, List<BoIndex> boIndexes, List<BoDataRule> boDataRules) {
        List boFieldDetailDTOList = this.boFieldExMapper.getBoFieldDetailListByBoId(bo.getId());
        boFieldDetailDTOList.forEach(t -> this.idStrMapThreadLocal.get().put(String.valueOf(t.getId()), String.valueOf(t.getPublishFieldId())));
        List schemaBoFields = boFieldDetailDTOList.stream().map(arg_0 -> ((SchemaVersionStructMapper)SchemaVersionStructMapper.MAPPER).toSchemaBoField(arg_0)).collect(Collectors.toList());
        ArrayList schemaBoRelationships = null == boRelationships ? Lists.newArrayList() : boRelationships.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoRelationship(arg_0)).collect(Collectors.toList());
        List schemaBoApis = this.boApiRepository.getBoApisWithDetail(bo.getId()).stream().map(tpl -> {
            SchemaBoApi schemaBoApi = SchemaStructMapper.MAPPER.toSchemaBoApi((BoApi)tpl._1);
            List schemaBoApiDetails = ((List)tpl._2).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoApiDetail(arg_0)).collect(Collectors.toList());
            schemaBoApi.setDetails(schemaBoApiDetails);
            return schemaBoApi;
        }).collect(Collectors.toList());
        ArrayList schemaBoIndexes = null == boIndexes ? Lists.newArrayList() : boIndexes.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoIndex(arg_0)).collect(Collectors.toList());
        ArrayList schemaBoDataRules = null == boDataRules ? Lists.newArrayList() : boDataRules.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoDataRule(arg_0)).collect(Collectors.toList());
        SchemaBo schemaBo = SchemaStructMapper.MAPPER.toSchemaBo(bo);
        schemaBo.setBoFields(schemaBoFields);
        schemaBo.setBoRelationships((List)schemaBoRelationships);
        schemaBo.setBoIndexes((List)schemaBoIndexes);
        schemaBo.setBoApis(schemaBoApis);
        schemaBo.setBoDataRules((List)schemaBoDataRules);
        return schemaBo;
    }

    private SchemaTenantBo buildSchemaTenantBo(Bo bo, List<BoRelationship> boRelationships, List<BoIndex> boIndexes, List<BoDataRule> boDataRules) {
        SchemaTenantBo schemaBo = SchemaStructMapper.MAPPER.toSchemaTenantBo(bo);
        List boFieldDetailDTOList = this.boFieldExMapper.getBoFieldDetailListByBoId(bo.getId());
        boFieldDetailDTOList.forEach(t -> this.idStrMapThreadLocal.get().put(String.valueOf(t.getId()), String.valueOf(t.getPublishFieldId())));
        List schemaBoFields = boFieldDetailDTOList.stream().map(arg_0 -> ((SchemaVersionStructMapper)SchemaVersionStructMapper.MAPPER).toSchemaBoField(arg_0)).collect(Collectors.toList());
        ArrayList schemaBoRelationships = null == boRelationships ? Lists.newArrayList() : boRelationships.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoRelationship(arg_0)).collect(Collectors.toList());
        List schemaBoApis = this.boApiRepository.getBoApisWithDetail(bo.getId()).stream().map(tpl -> {
            SchemaBoApi schemaBoApi = SchemaStructMapper.MAPPER.toSchemaBoApi((BoApi)tpl._1);
            List schemaBoApiDetails = ((List)tpl._2).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoApiDetail(arg_0)).collect(Collectors.toList());
            schemaBoApi.setDetails(schemaBoApiDetails);
            return schemaBoApi;
        }).collect(Collectors.toList());
        ArrayList schemaBoIndexes = null == boIndexes ? Lists.newArrayList() : boIndexes.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoIndex(arg_0)).collect(Collectors.toList());
        ArrayList schemaBoDataRules = null == boDataRules ? Lists.newArrayList() : boDataRules.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaBoDataRule(arg_0)).collect(Collectors.toList());
        schemaBo.setBoFields(schemaBoFields);
        schemaBo.setBoRelationships((List)schemaBoRelationships);
        schemaBo.setBoIndexes((List)schemaBoIndexes);
        schemaBo.setBoApis(schemaBoApis);
        schemaBo.setBoDataRules((List)schemaBoDataRules);
        return schemaBo;
    }

    private SchemaDict buildSchemaDict(Dict dict) {
        SchemaDict schemaDict = SchemaStructMapper.MAPPER.toSchemaDict(dict);
        List schemaDictDetails = this.dictDetailRepository.getDictDetails(dict.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaDictDetail(arg_0)).collect(Collectors.toList());
        schemaDict.setDetails(schemaDictDetails);
        return schemaDict;
    }

    private SchemaPage buildSchemaPage(UltPage page) {
        SchemaPage schemaPage = SchemaStructMapper.MAPPER.toSchemaPage(page);
        List schemaPageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(page.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaPageBoSetting(arg_0)).collect(Collectors.toList());
        schemaPage.setPageBoSettings(schemaPageBoSettings);
        return schemaPage;
    }

    private SchemaAction buildSchemaAction(FlowAction entity) {
        SchemaAction schemaItem = SchemaStructMapper.MAPPER.toSchemaAction(entity);
        List schemaSubItems = this.flowActionParamRepository.getActionParams(entity.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaActionParam(arg_0)).collect(Collectors.toList());
        schemaItem.setParams(schemaSubItems);
        return schemaItem;
    }

    private SchemaRule buildSchemaRule(SueRule entity) {
        SchemaRule schemaItem = SchemaStructMapper.MAPPER.toSchemaRule(entity);
        List schemaSubItems = this.sueRuleParamRepository.getRuleParams(entity.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaRuleParam(arg_0)).collect(Collectors.toList());
        schemaItem.setParams(schemaSubItems);
        return schemaItem;
    }

    private SchemaTenantDict buildSchemaTenantDict(Dict dict) {
        SchemaTenantDict schemaDict = SchemaStructMapper.MAPPER.toSchemaTenantDict(dict);
        List schemaDictDetails = this.dictDetailRepository.getDictDetails(dict.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaDictDetail(arg_0)).collect(Collectors.toList());
        schemaDict.setDetails(schemaDictDetails);
        return schemaDict;
    }

    private SchemaTenantPage buildSchemaTenantPage(UltPage page) {
        SchemaTenantPage schemaPage = SchemaStructMapper.MAPPER.toSchemaTenantPage(page);
        List schemaPageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(page.getId()).stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toSchemaPageBoSetting(arg_0)).collect(Collectors.toList());
        schemaPage.setPageBoSettings(schemaPageBoSettings);
        return schemaPage;
    }

    private void updateBoAndFieldId(SchemaApp appSchema) {
        Optional.ofNullable(appSchema.getBos()).ifPresent(bos -> bos.forEach(bo -> {
            bo.setId(this.idStrMapThreadLocal.get().get(bo.getId()));
            bo.setParentBoId(this.idStrMapThreadLocal.get().get(bo.getParentBoId()));
            bo.setSyncBoId(this.idStrMapThreadLocal.get().get(bo.getSyncBoId()));
            Optional.ofNullable(bo.getBoFields()).ifPresent(fields -> fields.forEach(field -> {
                field.setId(this.idStrMapThreadLocal.get().get(field.getId()));
                Optional.ofNullable(field.getCalculator()).ifPresent(calculator -> {
                    calculator.setAggregationBoId(this.idStrMapThreadLocal.get().get(calculator.getAggregationBoId()));
                    calculator.setAggregationFieldId(this.idStrMapThreadLocal.get().get(calculator.getAggregationFieldId()));
                    calculator.setAggregationRelationId(this.idStrMapThreadLocal.get().get(calculator.getAggregationRelationId()));
                    calculator.setLookupBoId(this.idStrMapThreadLocal.get().get(calculator.getLookupBoId()));
                    calculator.setLookupFieldId(this.idStrMapThreadLocal.get().get(calculator.getLookupFieldId()));
                    calculator.setLookupRelationId(this.idStrMapThreadLocal.get().get(calculator.getLookupRelationId()));
                });
            }));
            Optional.ofNullable(bo.getBoRelationships()).ifPresent(rels -> rels.forEach(rel -> {
                rel.setId(this.idStrMapThreadLocal.get().get(rel.getId()));
                rel.setBoId(this.idStrMapThreadLocal.get().get(rel.getBoId()));
                rel.setJoinBoId(this.idStrMapThreadLocal.get().get(rel.getJoinBoId()));
            }));
            Optional.ofNullable(bo.getTenantBos()).ifPresent(tBos -> tBos.forEach(tBo -> {
                tBo.setId(this.idStrMapThreadLocal.get().get(tBo.getId()));
                Optional.ofNullable(tBo.getBoFields()).ifPresent(tFields -> tFields.forEach(tField -> {
                    tField.setId(this.idStrMapThreadLocal.get().get(tField.getId()));
                    Optional.ofNullable(tField.getCalculator()).ifPresent(calculator -> {
                        calculator.setAggregationBoId(this.idStrMapThreadLocal.get().get(calculator.getAggregationBoId()));
                        calculator.setAggregationFieldId(this.idStrMapThreadLocal.get().get(calculator.getAggregationFieldId()));
                        calculator.setAggregationRelationId(this.idStrMapThreadLocal.get().get(calculator.getAggregationRelationId()));
                        calculator.setLookupBoId(this.idStrMapThreadLocal.get().get(calculator.getLookupBoId()));
                        calculator.setLookupFieldId(this.idStrMapThreadLocal.get().get(calculator.getLookupFieldId()));
                        calculator.setLookupRelationId(this.idStrMapThreadLocal.get().get(calculator.getLookupRelationId()));
                    });
                }));
                Optional.ofNullable(tBo.getBoRelationships()).ifPresent(tRels -> tRels.forEach(tRel -> {
                    tRel.setId(this.idStrMapThreadLocal.get().get(tRel.getId()));
                    tRel.setBoId(this.idStrMapThreadLocal.get().get(tRel.getBoId()));
                    tRel.setJoinBoId(this.idStrMapThreadLocal.get().get(tRel.getJoinBoId()));
                }));
            }));
        }));
        Optional.ofNullable(appSchema.getDicts()).ifPresent(dicts -> dicts.forEach(dict -> {
            dict.setId(this.idStrMapThreadLocal.get().get(dict.getId()));
            Optional.ofNullable(dict.getTenantDicts()).ifPresent(tDicts -> tDicts.forEach(tDict -> tDict.setId(this.idStrMapThreadLocal.get().get(tDict.getId()))));
        }));
        Optional.ofNullable(appSchema.getPages()).ifPresent(pages -> pages.forEach(page -> page.setId(this.idStrMapThreadLocal.get().get(page.getId()))));
        Optional.ofNullable(appSchema.getForms()).ifPresent(forms -> forms.forEach(form -> form.setId(this.idStrMapThreadLocal.get().get(form.getId()))));
        Optional.ofNullable(appSchema.getFlowSettings()).ifPresent(flows -> flows.forEach(flow -> flow.setId(this.idStrMapThreadLocal.get().get(flow.getId()))));
    }
}

