/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.jsonschema.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoApiType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoCreateType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IAppExService;
import com.xforceplus.ultraman.bocp.metadata.setting.BoFieldSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApiDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRuleParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldDomainAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldValidateService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoIndexService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IModuleBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import com.xforceplus.ultraman.metadata.jsonschema.mapstruct.SchemaStructMapper;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAction;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaActionParam;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppEvent;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoApi;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoDataRule;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoField;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoIndex;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBoRelationship;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDictDetail;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaRule;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaRuleParam;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTag;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenantDict;
import com.xforceplus.ultraman.metadata.jsonschema.service.IMetadataManageService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MetadataManageServiceImpl
implements IMetadataManageService {
    @Autowired
    private IAppExService appExService;
    @Autowired
    private IModuleBoService moduleBoService;
    @Autowired
    private IBoService boService;
    @Autowired
    private IBoFieldService boFieldService;
    @Autowired
    private IBoFieldAttributeService boFieldAttributeService;
    @Autowired
    private IBoFieldDomainAttributeService boFieldDomainAttributeService;
    @Autowired
    private IBoFieldValidateService boFieldValidateService;
    @Autowired
    private IBoApiService boApiService;
    @Autowired
    private IBoApiDetailService boApiDetailService;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoIndexService boIndexService;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private IFlowActionParamService flowActionParamService;
    @Autowired
    private IApisService apisService;
    @Autowired
    private ISueRuleService sueRuleService;
    @Autowired
    private ISueRuleParamService sueRuleParamService;
    @Autowired
    private ISueTagService sueTagService;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private ISdkSettingService sdkSettingService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DictRepository dictRepository;
    private final ThreadLocal<Map<Long, Long>> idMapThreadLocal = new ThreadLocal();

    private void initIdMapThreadLocal() {
        if (null == this.idMapThreadLocal.get()) {
            this.idMapThreadLocal.set(Maps.newHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createApp(SchemaApp schemaApp) {
        App app = SchemaStructMapper.MAPPER.toNewApp(schemaApp);
        ServiceResponse serviceResponse = this.appExService.saveApp(app);
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create app error, %s", serviceResponse.getMessage()));
        }
        try {
            this.initIdMapThreadLocal();
            serviceResponse = this.doCreateDicts(app.getId(), schemaApp.getDicts());
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create dicts error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateBos(app, schemaApp.getBos());
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create bos error, %s", serviceResponse.getMessage()));
            }
        }
        finally {
            this.idMapThreadLocal.remove();
        }
        serviceResponse = this.createActions(app.getId(), schemaApp.getActions());
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create actions error, %s", serviceResponse.getMessage()));
        }
        serviceResponse = this.createApis(app.getId(), schemaApp.getApis());
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create apis error, %s", serviceResponse.getMessage()));
        }
        serviceResponse = this.createRules(app.getId(), schemaApp.getRules());
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create rules error, %s", serviceResponse.getMessage()));
        }
        serviceResponse = this.createTags(app.getId(), schemaApp.getTags());
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create tags error, %s", serviceResponse.getMessage()));
        }
        return serviceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createBos(App app, List<SchemaBo> schemaBos) {
        try {
            this.initIdMapThreadLocal();
            ServiceResponse serviceResponse = this.doCreateBos(app, schemaBos);
            return serviceResponse;
        }
        finally {
            this.idMapThreadLocal.remove();
        }
    }

    private ServiceResponse doCreateBos(App app, List<SchemaBo> schemaBos) {
        ServiceResponse serviceResponse = this.validateBos(app.getId(), schemaBos);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        Optional moduleOptl = this.defaultModuleService.getModule(app.getId().longValue());
        Long moduleId = ((Module)moduleOptl.get()).getId();
        ArrayList moduleBos = Lists.newArrayList();
        ArrayList bos = Lists.newArrayList();
        ArrayList boFields = Lists.newArrayList();
        ArrayList boFieldAttributes = Lists.newArrayList();
        ArrayList boFieldDomainAttributes = Lists.newArrayList();
        ArrayList boFieldValidates = Lists.newArrayList();
        ArrayList boRelationships = Lists.newArrayList();
        ArrayList boIndexes = Lists.newArrayList();
        ArrayList boApis = Lists.newArrayList();
        ArrayList boApiDetails = Lists.newArrayList();
        ArrayList boDataRules = Lists.newArrayList();
        schemaBos.stream().filter(schemaBo -> SysType.USER.code().equals(schemaBo.getSysType())).forEach(schemaBo -> {
            Bo bo = this.createBo(app.getId(), (SchemaBo)schemaBo);
            moduleBos.add(new ModuleBo().setModuleId(moduleId).setBoId(bo.getId()));
            bos.add(bo);
            Optional.ofNullable(schemaBo.getBoFields()).ifPresent(schemaBoFields -> schemaBoFields.forEach(schemaBoField -> {
                Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> tpl = this.createBoField(bo.getId(), (SchemaBoField)schemaBoField);
                boFields.add(tpl._1);
                boFieldAttributes.add(tpl._2);
                Optional.ofNullable(tpl._3).ifPresent(t3 -> boFieldDomainAttributes.add(tpl._3));
                boFieldValidates.add(tpl._4);
            }));
            Optional.ofNullable(schemaBo.getBoRelationships()).ifPresent(schemaBoRelationships -> schemaBoRelationships.forEach(schemaBoRelationship -> boRelationships.add(this.createBoRelationship(bo.getId(), (SchemaBoRelationship)schemaBoRelationship))));
            Optional.ofNullable(schemaBo.getBoApis()).ifPresent(schemaBoApis -> {
                boApis.addAll(this.commonService.buildDefaultBoApis(app.getCode(), bo.getId()));
                schemaBoApis.stream().filter(schemaBoApi -> BoApiType.EXTERNAL.code().equals(schemaBoApi.getApiType())).forEach(schemaBoApi -> {
                    Tuple2<BoApi, List<BoApiDetail>> tpl = this.createBoApi(bo.getId(), (SchemaBoApi)schemaBoApi);
                    boApis.add(tpl._1);
                    boApiDetails.addAll((Collection)tpl._2);
                });
            });
            Optional.ofNullable(schemaBo.getBoIndexes()).ifPresent(schemaBoIndexes -> schemaBoIndexes.forEach(schemaBoIndex -> boIndexes.add(this.createBoIndex(bo.getId(), (SchemaBoIndex)schemaBoIndex))));
            Optional.ofNullable(schemaBo.getBoDataRules()).ifPresent(schemaBoDataRules -> schemaBoDataRules.forEach(schemaBoDataRule -> boDataRules.add(this.createBoDataRule(app.getId(), bo.getId(), (SchemaBoDataRule)schemaBoDataRule))));
            Optional.ofNullable(schemaBo.getTenantBos()).ifPresent(schemaTenantBos -> schemaTenantBos.forEach(schemaTenantBo -> {
                Bo tenantBo = this.createTenantBo(bo, (SchemaTenantBo)schemaTenantBo);
                moduleBos.add(new ModuleBo().setModuleId(moduleId).setBoId(tenantBo.getId()));
                bos.add(tenantBo);
                Optional.ofNullable(schemaTenantBo.getBoFields()).ifPresent(schemaBoFields -> schemaBoFields.forEach(schemaBoField -> {
                    Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> tpl = this.createBoField(tenantBo.getId(), (SchemaBoField)schemaBoField);
                    boFields.add(tpl._1);
                    boFieldAttributes.add(tpl._2);
                    Optional.ofNullable(tpl._3).ifPresent(t3 -> boFieldDomainAttributes.add(tpl._3));
                    boFieldValidates.add(tpl._4);
                }));
                Optional.ofNullable(schemaTenantBo.getBoRelationships()).ifPresent(schemaBoRelationships -> schemaBoRelationships.forEach(schemaBoRelationship -> boRelationships.add(this.createBoRelationship(tenantBo.getId(), (SchemaBoRelationship)schemaBoRelationship))));
                Optional.ofNullable(schemaTenantBo.getBoIndexes()).ifPresent(schemaBoIndexes -> schemaBoIndexes.forEach(schemaBoIndex -> boIndexes.add(this.createBoIndex(tenantBo.getId(), (SchemaBoIndex)schemaBoIndex))));
                Optional.ofNullable(schemaTenantBo.getBoDataRules()).ifPresent(schemaBoDataRules -> schemaBoDataRules.forEach(schemaBoDataRule -> boDataRules.add(this.createBoDataRule(app.getId(), tenantBo.getId(), (SchemaBoDataRule)schemaBoDataRule))));
            }));
        });
        this.prepareIdsForBos(app.getId());
        bos.forEach(bo -> {
            if (null != bo.getParentBoId()) {
                bo.setParentBoId(this.idMapThreadLocal.get().get(bo.getParentBoId()));
            }
            if (null != bo.getSyncBoId()) {
                bo.setParentBoId(this.idMapThreadLocal.get().get(bo.getSyncBoId()));
            }
            if (null != bo.getRefBoId()) {
                bo.setParentBoId(this.idMapThreadLocal.get().get(bo.getParentBoId()));
            }
        });
        boFields.forEach(boField -> {
            if (null != boField.getDictId()) {
                boField.setDictId(this.idMapThreadLocal.get().get(boField.getDictId()));
            }
        });
        boFieldDomainAttributes.forEach(boFieldDomainAttribute -> {
            if (null != boFieldDomainAttribute.getLookupBoId()) {
                boFieldDomainAttribute.setLookupBoId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupBoId()));
            }
            if (null != boFieldDomainAttribute.getLookupFieldId()) {
                boFieldDomainAttribute.setLookupFieldId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupFieldId()));
            }
            if (null != boFieldDomainAttribute.getLookupRelationId()) {
                boFieldDomainAttribute.setLookupRelationId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupRelationId()));
            }
            if (null != boFieldDomainAttribute.getAggregationFieldId()) {
                boFieldDomainAttribute.setAggregationBoId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationBoId()));
            }
            if (null != boFieldDomainAttribute.getAggregationFieldId()) {
                boFieldDomainAttribute.setAggregationFieldId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationFieldId()));
            }
            if (null != boFieldDomainAttribute.getAggregationRelationId()) {
                boFieldDomainAttribute.setAggregationRelationId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationRelationId()));
            }
        });
        boRelationships.forEach(boRelationship -> {
            if (null != boRelationship.getJoinBoId()) {
                boRelationship.setJoinBoId(this.idMapThreadLocal.get().get(boRelationship.getJoinBoId()));
            }
        });
        this.moduleBoService.saveBatch((Collection)moduleBos);
        this.boService.saveBatch((Collection)bos);
        this.boFieldService.saveBatch((Collection)boFields);
        this.boFieldAttributeService.saveBatch((Collection)boFieldAttributes);
        this.boFieldDomainAttributeService.saveBatch((Collection)boFieldDomainAttributes);
        this.boFieldValidateService.saveBatch((Collection)boFieldValidates);
        this.boRelationshipService.saveBatch((Collection)boRelationships);
        this.boApiService.saveBatch((Collection)boApis);
        this.boApiDetailService.saveBatch((Collection)boApiDetails);
        this.boIndexService.saveBatch((Collection)boIndexes);
        this.boDataRuleService.saveBatch((Collection)boDataRules);
        return ServiceResponse.success();
    }

    private Bo createBo(Long appId, SchemaBo schemaBo) {
        Long boId = IdWorker.getId();
        Bo bo = SchemaStructMapper.MAPPER.toBo(schemaBo);
        this.idMapThreadLocal.get().put(bo.getId(), boId);
        bo.setId(boId);
        bo.setUniqueId(boId);
        bo.setAppId(appId);
        if (bo.getParentBoId() != null) {
            bo.setCreateType(BoCreateType.EXTEND.code());
        } else if (bo.getSyncBoId() != null) {
            bo.setCreateType(BoCreateType.SYNC.code());
        } else if (bo.getRefBoId() != null) {
            bo.setCreateType(BoCreateType.DEFAULT.code());
        } else {
            bo.setCreateType(BoCreateType.DEFAULT.code());
        }
        return bo;
    }

    private Bo createTenantBo(Bo mainBo, SchemaTenantBo schemaTenantBo) {
        Long tenantBoId = IdWorker.getId();
        Bo tenantBo = BoStructMapper.MAPPER.clone(mainBo);
        SchemaStructMapper.MAPPER.fillSchemaTenantBo(schemaTenantBo, tenantBo);
        this.idMapThreadLocal.get().put(tenantBo.getId(), tenantBoId);
        tenantBo.setId(tenantBoId);
        tenantBo.setUniqueId(tenantBoId);
        tenantBo.setRefBoId(mainBo.getId());
        return tenantBo;
    }

    @Override
    public Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> createBoField(Long boId, SchemaBoField schemaBoField) {
        Long boFieldId = IdWorker.getId();
        BoField boField = SchemaStructMapper.MAPPER.toBoField(schemaBoField);
        this.idMapThreadLocal.get().put(boField.getId(), boFieldId);
        boField.setId(boFieldId);
        boField.setUniqueId(boFieldId);
        boField.setBoId(boId);
        BoFieldAttribute boFieldAttribute = SchemaStructMapper.MAPPER.toBoFieldAttribute(schemaBoField);
        boFieldAttribute.setFieldId(boFieldId);
        BoFieldDomainAttribute boFieldDomainAttribute = null;
        if (BoFieldSetting.computeFieldTypeCodes.contains(boField.getFieldType()) || BoFieldSetting.businessFieldTypeCodes.contains(boField.getFieldType())) {
            boFieldDomainAttribute = SchemaStructMapper.MAPPER.toBoFieldDomainAttribute(schemaBoField);
            boFieldDomainAttribute.setFieldId(boFieldId);
        }
        BoFieldValidate boFieldValidate = SchemaStructMapper.MAPPER.toBoFieldValidate(schemaBoField);
        boFieldValidate.setFieldId(boFieldId);
        return new Tuple4((Object)boField, (Object)boFieldAttribute, (Object)boFieldDomainAttribute, (Object)boFieldValidate);
    }

    @Override
    public BoRelationship createBoRelationship(Long boId, SchemaBoRelationship schemaBoRelationship) {
        Long boRelationshipId = IdWorker.getId();
        BoRelationship boRelationship = SchemaStructMapper.MAPPER.toBoRelationship(schemaBoRelationship);
        this.idMapThreadLocal.get().put(boRelationship.getId(), boRelationshipId);
        boRelationship.setId(boRelationshipId);
        boRelationship.setUniqueId(boRelationshipId);
        boRelationship.setBoId(boId);
        return boRelationship;
    }

    @Override
    public Tuple2<BoApi, List<BoApiDetail>> createBoApi(Long boId, SchemaBoApi schemaBoApi) {
        Long boApiId = IdWorker.getId();
        BoApi boApi = SchemaStructMapper.MAPPER.toBoApi(schemaBoApi);
        boApi.setId(boApiId);
        boApi.setBoId(boId);
        List boApiDetails = Optional.ofNullable(schemaBoApi.getDetails()).map(schemaBoApiDetails -> schemaBoApiDetails.stream().map(arg_0 -> ((SchemaStructMapper)SchemaStructMapper.MAPPER).toBoApiDetail(arg_0)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        return new Tuple2((Object)boApi, (Object)boApiDetails);
    }

    @Override
    public BoIndex createBoIndex(Long boId, SchemaBoIndex schemaBoIndex) {
        BoIndex boIndex = SchemaStructMapper.MAPPER.toBoIndex(schemaBoIndex);
        boIndex.setBoId(boId);
        return boIndex;
    }

    @Override
    public BoDataRule createBoDataRule(Long appId, Long boId, SchemaBoDataRule schemaBoDataRule) {
        BoDataRule boDataRule = SchemaStructMapper.MAPPER.toBoDataRule(schemaBoDataRule);
        boDataRule.setAppId(appId);
        boDataRule.setBoId(boId);
        return boDataRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createDicts(Long appId, List<SchemaDict> schemaDicts) {
        try {
            this.initIdMapThreadLocal();
            ServiceResponse serviceResponse = this.doCreateDicts(appId, schemaDicts);
            return serviceResponse;
        }
        finally {
            this.idMapThreadLocal.remove();
        }
    }

    private ServiceResponse doCreateDicts(Long appId, List<SchemaDict> schemaDicts) {
        ServiceResponse serviceResponse = this.validateDicts(appId, schemaDicts);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList dicts = Lists.newArrayList();
        ArrayList dictDetails = Lists.newArrayList();
        schemaDicts.stream().filter(schemaDict -> SysType.USER.code().equals(schemaDict.getSystemType())).forEach(schemaDict -> {
            Tuple2<Dict, List<DictDetail>> tpl = this.createDict(appId, (SchemaDict)schemaDict);
            dicts.add(tpl._1);
            dictDetails.addAll((Collection)tpl._2);
            Optional.ofNullable(schemaDict.getTenantDicts()).ifPresent(schemaTenantDicts -> schemaTenantDicts.forEach(schemaTenantDict -> {
                Tuple2<Dict, List<DictDetail>> tenantTpl = this.createTenantDict((Dict)tpl._1, (SchemaTenantDict)schemaTenantDict);
                dicts.add(tenantTpl._1);
                dictDetails.addAll((Collection)tenantTpl._2);
            }));
        });
        this.dictService.saveBatch((Collection)dicts);
        this.dictDetailService.saveBatch((Collection)dictDetails);
        return ServiceResponse.success();
    }

    private Tuple2<Dict, List<DictDetail>> createDict(Long appId, SchemaDict schemaDict) {
        Long dictId = IdWorker.getId();
        Dict dict = SchemaStructMapper.MAPPER.toDict(schemaDict);
        this.idMapThreadLocal.get().put(dict.getId(), dictId);
        dict.setId(dictId);
        dict.setAppId(appId);
        List dictDetails = Optional.ofNullable(schemaDict.getDetails()).map(schemaBoApiDetails -> schemaBoApiDetails.stream().map(schemaDictDetail -> this.createDictDetail(dictId, (SchemaDictDetail)schemaDictDetail)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        return new Tuple2((Object)dict, (Object)dictDetails);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createActions(Long appId, List<SchemaAction> schemaEntitys) {
        ServiceResponse serviceResponse = this.validateActions(appId, schemaEntitys);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList entitys = Lists.newArrayList();
        ArrayList subEntitys = Lists.newArrayList();
        schemaEntitys.forEach(schemaEntity -> {
            Tuple2<FlowAction, List<FlowActionParam>> tpl = this.createAction(appId, (SchemaAction)schemaEntity);
            entitys.add(tpl._1);
            subEntitys.addAll((Collection)tpl._2);
        });
        this.flowActionService.saveBatch((Collection)entitys);
        this.flowActionParamService.saveBatch((Collection)subEntitys);
        return ServiceResponse.success();
    }

    private Tuple2<FlowAction, List<FlowActionParam>> createAction(Long appId, SchemaAction schemaEntity) {
        Long entityId = IdWorker.getId();
        FlowAction entity = SchemaStructMapper.MAPPER.toAction(schemaEntity);
        entity.setId(entityId);
        entity.setAppId(appId);
        List subItems = Optional.ofNullable(schemaEntity.getParams()).map(schemaSubItems -> schemaSubItems.stream().map(schemaSubItem -> this.createActionParam(entityId, (SchemaActionParam)schemaSubItem)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        return new Tuple2((Object)entity, (Object)subItems);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createApis(Long appId, List<SchemaApi> schemaEntitys) {
        ServiceResponse serviceResponse = this.validateApis(appId, schemaEntitys);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List entitys = schemaEntitys.stream().map(schemaEntity -> {
            Long entityId = IdWorker.getId();
            Apis entity = SchemaStructMapper.MAPPER.toApi(schemaEntity);
            entity.setId(entityId);
            entity.setApplicationId(String.valueOf(appId));
            return entity;
        }).collect(Collectors.toList());
        this.apisService.saveBatch(entitys);
        return ServiceResponse.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createRules(Long appId, List<SchemaRule> schemaEntitys) {
        ServiceResponse serviceResponse = this.validateRules(appId, schemaEntitys);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList entitys = Lists.newArrayList();
        ArrayList subEntitys = Lists.newArrayList();
        schemaEntitys.forEach(schemaEntity -> {
            Tuple2<SueRule, List<SueRuleParam>> tpl = this.createRule(appId, (SchemaRule)schemaEntity);
            entitys.add(tpl._1);
            subEntitys.addAll((Collection)tpl._2);
        });
        this.sueRuleService.saveBatch((Collection)entitys);
        this.sueRuleParamService.saveBatch((Collection)subEntitys);
        return ServiceResponse.success();
    }

    @Override
    public Tuple2<SueRule, List<SueRuleParam>> createRule(Long appId, SchemaRule schemaEntity) {
        Long entityId = IdWorker.getId();
        SueRule entity = SchemaStructMapper.MAPPER.toRule(schemaEntity);
        entity.setId(entityId);
        entity.setAppId(String.valueOf(appId));
        List subItems = Optional.ofNullable(schemaEntity.getParams()).map(schemaSubItems -> schemaSubItems.stream().map(schemaSubItem -> this.createRuleParam(entityId, (SchemaRuleParam)schemaSubItem)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        return new Tuple2((Object)entity, (Object)subItems);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createTags(Long appId, List<SchemaTag> schemaEntitys) {
        ServiceResponse serviceResponse = this.validateTags(appId, schemaEntitys);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List entitys = schemaEntitys.stream().map(schemaEntity -> {
            Long entityId = IdWorker.getId();
            SueTag entity = SchemaStructMapper.MAPPER.toTag(schemaEntity);
            entity.setId(entityId);
            entity.setAppId(String.valueOf(appId));
            return entity;
        }).collect(Collectors.toList());
        this.sueTagService.saveBatch(entitys);
        return ServiceResponse.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createAppEvents(Long appId, List<SchemaAppEvent> schemaEntitys) {
        ServiceResponse serviceResponse = this.validateAppEvents(appId, schemaEntitys);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List entitys = schemaEntitys.stream().map(schemaEntity -> {
            Long entityId = IdWorker.getId();
            AppEvent entity = SchemaStructMapper.MAPPER.toAppEvent(schemaEntity);
            entity.setId(entityId);
            entity.setUniqueId(entityId);
            entity.setAppId(appId);
            return entity;
        }).collect(Collectors.toList());
        this.appEventService.saveBatch(entitys);
        return ServiceResponse.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse createSdkSettings(Long appId, List<SchemaSdkSetting> schemaEntitys) {
        List entitys = schemaEntitys.stream().map(schemaEntity -> {
            Long entityId = IdWorker.getId();
            SdkSetting entity = SchemaStructMapper.MAPPER.toSdkSetting(schemaEntity);
            entity.setId(entityId);
            entity.setUniqueId(entityId);
            entity.setAppId(appId);
            return entity;
        }).collect(Collectors.toList());
        this.sdkSettingService.saveBatch(entitys);
        return ServiceResponse.success();
    }

    private void prepareIdsForBos(Long appId) {
        List<Long> dictIds = this.dictRepository.getDicts(appId).stream().map(Dict::getId).collect(Collectors.toList());
        dictIds.forEach(id -> this.idMapThreadLocal.get().putIfAbsent((Long)id, (Long)id));
    }

    private Tuple2<Dict, List<DictDetail>> createTenantDict(Dict mainDict, SchemaTenantDict schemaTenantDict) {
        Long tenantDictId = IdWorker.getId();
        Dict tenantDict = DictStructMapper.MAPPER.clone(mainDict);
        SchemaStructMapper.MAPPER.fillSchemaTenantDict(schemaTenantDict, tenantDict);
        this.idMapThreadLocal.get().put(tenantDict.getId(), tenantDictId);
        tenantDict.setId(tenantDictId);
        List dictDetails = Optional.ofNullable(schemaTenantDict.getDetails()).map(schemaDictDetails -> schemaDictDetails.stream().map(schemaDictDetail -> this.createDictDetail(tenantDictId, (SchemaDictDetail)schemaDictDetail)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        return new Tuple2((Object)tenantDict, (Object)dictDetails);
    }

    private DictDetail createDictDetail(Long dictId, SchemaDictDetail schemaDictDetail) {
        DictDetail dictDetail = SchemaStructMapper.MAPPER.toDictDetail(schemaDictDetail);
        dictDetail.setDictId(dictId);
        return dictDetail;
    }

    private FlowActionParam createActionParam(Long entityId, SchemaActionParam schemaSubEntity) {
        FlowActionParam subEntity = SchemaStructMapper.MAPPER.toActionParam(schemaSubEntity);
        subEntity.setActionId(entityId);
        return subEntity;
    }

    private SueRuleParam createRuleParam(Long entityId, SchemaRuleParam schemaSubEntity) {
        SueRuleParam subEntity = SchemaStructMapper.MAPPER.toRuleParam(schemaSubEntity);
        subEntity.setRuleId(entityId);
        return subEntity;
    }

    private ServiceResponse validateBos(Long appId, List<SchemaBo> schemaBos) {
        List bos = this.boService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getAppId, (Object)appId)).eq(Bo::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Bo::getDeleteFlag, (Object)"1"));
        if (bos.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaBoCodes = schemaBos.stream().map(SchemaBo::getCode).distinct().collect(Collectors.toList());
        List boCodes = bos.stream().map(Bo::getCode).distinct().collect(Collectors.toList());
        List exsitBocodes = schemaBoCodes.stream().filter(schemaDictCode -> boCodes.contains(schemaDictCode)).collect(Collectors.toList());
        if (!exsitBocodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u5bf9\u8c61\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitBocodes.stream().collect(Collectors.joining(","))));
        }
        for (SchemaBo schemaBo : schemaBos) {
            ServiceResponse serviceResponse = this.validateBoFields(Long.valueOf(schemaBo.getId()), schemaBo.getBoFields());
            if (!serviceResponse.isSuccess()) {
                return serviceResponse;
            }
            serviceResponse = this.validateBoRelationships(Long.valueOf(schemaBo.getId()), schemaBo.getBoRelationships());
            if (serviceResponse.isSuccess()) continue;
            return serviceResponse;
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateBoFields(Long boId, List<SchemaBoField> schemaBoFields) {
        if (CollectionUtils.isEmpty(schemaBoFields)) {
            return ServiceResponse.success();
        }
        List schemaCodes = schemaBoFields.stream().map(SchemaBoField::getCode).distinct().collect(Collectors.toList());
        return schemaBoFields.size() == schemaCodes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5bf9\u8c61-%s \u5b57\u6bb5\u4ee3\u7801\u91cd\u590d", boId));
    }

    private ServiceResponse validateBoRelationships(Long boId, List<SchemaBoRelationship> schemaBoRelationships) {
        if (CollectionUtils.isEmpty(schemaBoRelationships)) {
            return ServiceResponse.success();
        }
        List schemaCodes = schemaBoRelationships.stream().map(SchemaBoRelationship::getRelationCode).distinct().collect(Collectors.toList());
        return schemaBoRelationships.size() == schemaCodes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5bf9\u8c61-%s \u5173\u7cfb\u4ee3\u7801\u91cd\u590d", boId));
    }

    private ServiceResponse validateDicts(Long appId, List<SchemaDict> schemaDicts) {
        List dicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Dict::getDeleteFlag, (Object)"1"));
        if (dicts.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaDictCodes = schemaDicts.stream().map(SchemaDict::getCode).distinct().collect(Collectors.toList());
        List dictCodes = dicts.stream().map(Dict::getCode).distinct().collect(Collectors.toList());
        List exsitDictcodes = schemaDictCodes.stream().filter(schemaDictCode -> dictCodes.contains(schemaDictCode)).collect(Collectors.toList());
        if (!exsitDictcodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u5b57\u5178\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitDictcodes.stream().collect(Collectors.joining(","))));
        }
        for (SchemaDict schemaDict : schemaDicts) {
            ServiceResponse serviceResponse = this.validateDictDetails(Long.valueOf(schemaDict.getId()), schemaDict.getDetails());
            if (serviceResponse.isSuccess()) continue;
            return serviceResponse;
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateDictDetails(Long dictId, List<SchemaDictDetail> schemaDictDetails) {
        if (CollectionUtils.isEmpty(schemaDictDetails)) {
            return ServiceResponse.success();
        }
        List schemaCodes = schemaDictDetails.stream().map(SchemaDictDetail::getCode).distinct().collect(Collectors.toList());
        return schemaDictDetails.size() == schemaCodes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5b57\u5178-%s \u5b57\u5178\u9879\u4ee3\u7801\u91cd\u590d", dictId));
    }

    private ServiceResponse validateActions(Long appId, List<SchemaAction> schemaEntitys) {
        List actions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId));
        if (actions.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SchemaAction::getActionCode).distinct().collect(Collectors.toList());
        List entityCodes = actions.stream().map(FlowAction::getActionCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntitycodes = schemaEntityCodes.stream().filter(code -> entityCodes.contains(code)).collect(Collectors.toList());
        if (!exsitSchemaEntitycodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("ACTION\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitSchemaEntitycodes.stream().collect(Collectors.joining(","))));
        }
        for (SchemaAction item : schemaEntitys) {
            ServiceResponse serviceResponse = this.validateActionParams(Long.valueOf(item.getId()), item.getParams());
            if (serviceResponse.isSuccess()) continue;
            return serviceResponse;
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateActionParams(Long mainId, List<SchemaActionParam> schemaSubItems) {
        return ServiceResponse.success();
    }

    private ServiceResponse validateApis(Long appId, List<SchemaApi> schemaEntitys) {
        List entitys = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SchemaApi::getApiCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(Apis::getApiCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntitycodes = schemaEntityCodes.stream().filter(code -> entityCodes.contains(code)).collect(Collectors.toList());
        if (!exsitSchemaEntitycodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("API\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitSchemaEntitycodes.stream().collect(Collectors.joining(","))));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateRules(Long appId, List<SchemaRule> schemaEntitys) {
        List entitys = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SchemaRule::getRuleCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(SueRule::getRuleCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntitycodes = schemaEntityCodes.stream().filter(code -> entityCodes.contains(code)).collect(Collectors.toList());
        if (!exsitSchemaEntitycodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u89c4\u5219\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitSchemaEntitycodes.stream().collect(Collectors.joining(","))));
        }
        for (SchemaRule item : schemaEntitys) {
            ServiceResponse serviceResponse = this.validateRuleParams(Long.valueOf(item.getId()), item.getParams());
            if (serviceResponse.isSuccess()) continue;
            return serviceResponse;
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateRuleParams(Long mainId, List<SchemaRuleParam> schemaSubItems) {
        return ServiceResponse.success();
    }

    private ServiceResponse validateTags(Long appId, List<SchemaTag> schemaEntitys) {
        List entitys = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SchemaTag::getTagCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(SueTag::getTagCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntitycodes = schemaEntityCodes.stream().filter(code -> entityCodes.contains(code)).collect(Collectors.toList());
        if (!exsitSchemaEntitycodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u6807\u7b7e\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitSchemaEntitycodes.stream().collect(Collectors.joining(","))));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateAppEvents(Long appId, List<SchemaAppEvent> schemaEntitys) {
        List entitys = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SchemaAppEvent::getEventCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(AppEvent::getEventCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntityCodes = schemaEntityCodes.stream().filter(code -> entityCodes.contains(code)).collect(Collectors.toList());
        if (!exsitSchemaEntityCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u4e8b\u4ef6\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", exsitSchemaEntityCodes.stream().collect(Collectors.joining(","))));
        }
        return ServiceResponse.success();
    }
}

