/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.permissions.pojo.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class Result<C, V>
implements Serializable {
    private C status;
    private Collection<V> values = Collections.emptyList();
    private String message;

    public Result(C status) {
        this.status = status;
    }

    public Result(C status, String message) {
        this(status, Collections.emptyList(), message);
    }

    public Result(C status, V value) {
        this(status, value, null);
    }

    public Result(C status, V value, String message) {
        this(status, (Collection<V>)(value != null ? Arrays.asList(value) : null), message);
    }

    public Result(C status, Collection<V> values, String message) {
        this.status = status;
        this.message = message;
        if (this.message == null) {
            this.message = "";
        }
        if (values != null) {
            this.values = new ArrayList<V>(values);
        }
    }

    public C getStatus() {
        return this.status;
    }

    public void setStatus(C status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void addValue(V value) {
        if (this.values == Collections.emptyList()) {
            this.values = Arrays.asList(value);
        } else {
            this.values.add(value);
        }
    }

    public Stream streamValues() {
        return this.values.stream();
    }

    public V findFirst() {
        Optional<V> v = this.values.stream().findFirst();
        if (v.isPresent()) {
            return v.get();
        }
        return null;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public Collection<V> getValues() {
        return this.values;
    }

    public void addValues(List<V> values) {
        for (V value : values) {
            this.addValue(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result result = (Result)o;
        return Objects.equals(this.getStatus(), result.getStatus()) && Objects.equals(this.getValues(), result.getValues()) && Objects.equals(this.getMessage(), result.getMessage());
    }

    public int hashCode() {
        return Objects.hash(this.getStatus(), this.getValues(), this.getMessage());
    }

    public String toString() {
        return "Result{status=" + this.status + ", values=" + this.values + ", message='" + this.message + '\'' + '}';
    }
}

