/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.permissions.pojo.rule;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonSerialize(using=RuleConditionOperationJsonSerializer.class)
@JsonDeserialize(using=RuleConditionOperationJsonDeserialize.class)
public enum RuleConditionOperation {
    GREATER(">"),
    LESS("<"),
    EQUAL("="),
    NOT_EQUAL("!="),
    GREATER_EQUAL(">="),
    LESS_EQUAL("<="),
    LIST("[]"),
    BEFORE("^"),
    AFTER("$"),
    NOT_BEFORE("!^"),
    NOT_AFTER("!$"),
    CONTAINS("()");

    private String symbol;

    private RuleConditionOperation(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static RuleConditionOperation getInstance(String symbol) {
        String noSpaceSymbol = symbol.trim();
        for (RuleConditionOperation operator : RuleConditionOperation.values()) {
            if (!operator.getSymbol().equals(noSpaceSymbol)) continue;
            return operator;
        }
        return null;
    }

    public static class RuleConditionOperationJsonDeserialize
    extends JsonDeserializer<RuleConditionOperation> {
        public RuleConditionOperation deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String value = p.getValueAsString();
            RuleConditionOperation operation = RuleConditionOperation.getInstance(value);
            if (operation == null) {
                RuleConditionOperation[] values;
                for (RuleConditionOperation v : values = RuleConditionOperation.values()) {
                    if (!v.name().equals(value)) continue;
                    operation = v;
                    break;
                }
            }
            return operation;
        }
    }

    public static class RuleConditionOperationJsonSerializer
    extends JsonSerializer<RuleConditionOperation> {
        public void serialize(RuleConditionOperation value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getSymbol());
        }
    }
}

