/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.permissions.transfer.grpc.client;

import com.xforceplus.ultraman.permissions.pojo.auth.Authorization;
import com.xforceplus.ultraman.permissions.pojo.auth.Authorizations;
import com.xforceplus.ultraman.permissions.transfer.grpc.generate.AuthorizationGrpc;
import com.xforceplus.ultraman.permissions.transfer.grpc.generate.ForStatmentGrpc;
import com.xforceplus.ultraman.permissions.transfer.grpc.generate.StatmentCheckServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatmentCheckClientGrpc {
    final Logger logger = LoggerFactory.getLogger(StatmentCheckClientGrpc.class);
    private String host = "xplat-data-permissions";
    private int port = 8206;
    private long heartbeatIntervalSeconds = 30L;
    private long heartbeatTimeoutSeconds = 30L;
    private ManagedChannel channel;
    private StatmentCheckServiceGrpc.StatmentCheckServiceBlockingStub stub;

    public void init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().keepAliveTime(this.heartbeatIntervalSeconds, TimeUnit.SECONDS).keepAliveTimeout(this.heartbeatTimeoutSeconds, TimeUnit.SECONDS).build();
        this.stub = StatmentCheckServiceGrpc.newBlockingStub((Channel)this.channel);
        this.logger.info("Xplat-data-permissions-client successfully connects to {}:{}.!", (Object)this.host, (Object)this.port);
    }

    public void destroy() throws InterruptedException {
        this.channel.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
    }

    public ForStatmentGrpc.StatmentResult check(String sql, Authorizations authorizations) {
        ForStatmentGrpc.Statment.Builder builder = ForStatmentGrpc.Statment.newBuilder().setSql(sql);
        for (Authorization authorization : authorizations.getAuthorizations()) {
            builder.addAuthorization(AuthorizationGrpc.Authorization.newBuilder().setRole(authorization.getRole()).setTenant(authorization.getTenant()).build());
        }
        return this.stub.check(builder.build());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHeartbeatIntervalSeconds(long heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public void setHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }
}

