/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.impl;

import com.xforceplus.ultraman.oqsengine.calculation.Calculation;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.dto.AffectedInfo;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.factory.CalculationLogicFactory;
import com.xforceplus.ultraman.oqsengine.calculation.logic.CalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.utils.CalculationComparator;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.CalculationParticipant;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraphConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCalculationImpl
implements Calculation {
    private static int MAX_BUILD_INFUENCE_NUMBER = 1000;
    private final Logger logger = LoggerFactory.getLogger(DefaultCalculationImpl.class);

    @Override
    @Timed(value="oqs.calculation.logic.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"logic", "all", "action", "calculate"})
    public IEntity calculate(CalculationContext context) throws CalculationException {
        IEntity targetEntity = context.getFocusEntity();
        Collection<IEntityField> calculationFields = this.parseChangeFields(context, true);
        CalculationLogicFactory calculationLogicFactory = (CalculationLogicFactory)context.getResourceWithEx(() -> context.getCalculationLogicFactory());
        for (IEntityField field : calculationFields) {
            Optional<IValue> newValueOp;
            CalculationLogic logic = calculationLogicFactory.getCalculationLogic(field.calculationType());
            context.focusField(field);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Start using {} logic to compute instance {} fields {} of type {}.", new Object[]{logic.getClass().getSimpleName(), targetEntity.id(), field.name(), context.getFocusClass().code()});
            }
            Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            try {
                newValueOp = logic.calculate(context);
            }
            catch (CalculationException ex) {
                this.processTimer(logic, sample, "oqs.calculation.logic.delay.latency", "calculate", true);
                throw new CalculationException(String.format("An error occurred in the calculation field (%d-%s) due to %s.", field.id(), field.name(), ex.getMessage()));
            }
            this.processTimer(logic, sample, "oqs.calculation.logic.delay.latency", "calculate", false);
            if (newValueOp.isPresent()) {
                targetEntity.entityValue().addValue(newValueOp.get());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Instance {} field {} evaluates to {}.", new Object[]{targetEntity.id(), field.name(), newValueOp.get().getValue()});
                continue;
            }
            targetEntity.entityValue().remove(context.getFocusField());
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Instance {} field {} evaluates to {}.", new Object[]{targetEntity.id(), field.name(), "NULL"});
        }
        return targetEntity;
    }

    @Override
    @Timed(value="oqs.calculation.logic.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"logic", "all", "action", "maintain"})
    public void maintain(CalculationContext context) throws CalculationException {
        if (!this.doMaintain(context)) {
            throw new CalculationException("Conflicts are calculated and the attempt limit is reached. To give up!");
        }
    }

    private boolean doMaintain(CalculationContext context) throws CalculationException {
        InfuenceGraph graph = this.scope(context);
        CalculationLogicFactory calculationLogicFactory = (CalculationLogicFactory)context.getResourceWithEx(() -> context.getCalculationLogicFactory());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Maintain computed fields, whose impact graph is as follows.\n{}\n", (Object)graph);
        }
        graph.scan((parentParticipants, participant, inner) -> {
            long[] affectedEntityIds;
            if (participant.isSource() || participant.isNeedless()) {
                return InfuenceGraphConsumer.Action.CONTINUE;
            }
            if (CalculationType.STATIC == participant.getField().calculationType()) {
                return InfuenceGraphConsumer.Action.CONTINUE;
            }
            IEntity sourceEntity = context.getSourceEntity();
            IEntityClass sourceEntityClass = (IEntityClass)((MetaManager)context.getResourceWithEx(() -> context.getMetaManager())).load(sourceEntity.entityClassRef()).get();
            if (sourceEntityClass.field(participant.getField().id()).isPresent()) {
                this.collectingImpactInstances(parentParticipants).forEach(e -> participant.addAffectedEntity((IEntity)e));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The participant field ({}) belongs to the origin object ({}) and is no longer counted but propagates the impact.", (Object)participant.getField().name(), (Object)sourceEntityClass.name());
                }
                return InfuenceGraphConsumer.Action.CONTINUE;
            }
            CalculationLogic logic = calculationLogicFactory.getCalculationLogic(participant.getField().calculationType());
            Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            ArrayList<AffectedInfo> affectedInfos = null;
            try {
                Collection<IEntity> triggerEntities = this.collectingImpactInstances(parentParticipants);
                affectedInfos = new ArrayList<AffectedInfo>(logic.getMaintainTarget(context, participant, triggerEntities));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The participant {} is affected by {} instances by {} instances.", new Object[]{participant, triggerEntities.size(), affectedInfos.size()});
                }
            }
            catch (CalculationException ex) {
                this.processTimer(logic, sample, "oqs.calculation.logic.delay.latency", "getTarget", true);
                throw ex;
            }
            this.processTimer(logic, sample, "oqs.calculation.logic.delay.latency", "getTarget", false);
            if (!affectedInfos.isEmpty() && (affectedEntityIds = affectedInfos.stream().filter(a -> CalculationScenarios.BUILD != context.getScenariso() || a.getAffectedEntityId() != context.getSourceEntity().id()).mapToLong(a -> a.getAffectedEntityId()).distinct().toArray()).length > 0 && !context.tryLocksEntity(affectedEntityIds)) {
                throw new CalculationException(String.format("Conflicts are calculated and the attempt limit is reached [%d ms]. To give up!", context.getLockTimeoutMs()));
            }
            IEntity[] affectedEntities = this.loadEntities(context, affectedInfos);
            if (this.logger.isDebugEnabled() && affectedEntities.length == 0) {
                this.logger.debug("The number of instances affected by the field {} of entityclass {} is 0.", (Object)participant.getField().fieldName(), (Object)participant.getEntityClass().code());
            }
            for (IEntity affectedEntitiy : affectedEntities) {
                Optional<IValue> newValueOp;
                context.focusEntity(affectedEntitiy, participant.getEntityClass());
                context.focusField(participant.getField());
                Optional oldValueOp = affectedEntitiy.entityValue().getValue(participant.getField().id());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Start using {} logic to compute instance {} fields {} of type {}.", new Object[]{logic.getClass().getSimpleName(), affectedEntitiy.id(), participant.getField().name(), participant.getEntityClass().code()});
                }
                AffectedInfo affectedInfo = null;
                for (AffectedInfo a2 : affectedInfos) {
                    if (a2.getAffectedEntityId() != affectedEntitiy.id()) continue;
                    affectedInfo = a2;
                    break;
                }
                if (affectedInfo == null) {
                    throw new CalculationException("An unexpected error occurred and the expected instance was not found in the calculation.");
                }
                affectedInfos.remove(affectedInfo);
                context.startMaintenance(affectedInfo.getTriggerEntity());
                try {
                    newValueOp = logic.calculate(context);
                }
                catch (CalculationException ex) {
                    this.logger.error("Maintenance error occurred, the current impact tree is: \n {}.", (Object)inner.toString());
                    throw new CalculationException(String.format("An error occurred in the calculation field (%d-%s) due to %s.", participant.getField().id(), participant.getField().name(), ex.getMessage()));
                }
                context.stopMaintenance();
                if (newValueOp.isPresent()) {
                    EmptyTypedValue oldValue = oldValueOp.isPresent() ? (IValue)oldValueOp.get() : new EmptyTypedValue(participant.getField());
                    IValue newValue = newValueOp.get();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Instance {} field {} evaluates to {}.", new Object[]{affectedEntitiy.id(), participant.getField().name(), newValueOp.get().getValue()});
                    }
                    if (!this.valueEquals((IValue)oldValue, newValue)) {
                        context.addValueChange(ValueChange.build(affectedEntitiy.id(), (IValue)oldValue, newValue));
                        affectedEntitiy.entityValue().addValue(newValueOp.get());
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Calculate field {}, the result is the same before and after calculation so do not change.", (Object)context.getFocusField().name());
                    }
                    return InfuenceGraphConsumer.Action.OVER_SELF;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Instance {} field {} evaluates to {}.", new Object[]{affectedEntitiy.id(), participant.getField().name(), "NULL"});
            }
            for (IEntity affectedEntitiy : affectedEntities) {
                participant.addAffectedEntity(affectedEntitiy);
            }
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
        return true;
    }

    private boolean valueEquals(IValue oldValue, IValue newValue) {
        return Objects.equals(oldValue.getValue(), newValue.getValue());
    }

    private IEntity[] loadEntities(CalculationContext context, Collection<AffectedInfo> affectedInfos) throws CalculationException {
        long[] notCacheIds;
        if (affectedInfos.isEmpty()) {
            return new IEntity[0];
        }
        long[] ids = affectedInfos.stream().mapToLong(a -> a.getAffectedEntityId()).toArray();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Load instance. Identity list [{}]", (Object)ids);
        }
        if ((notCacheIds = Arrays.stream(ids).filter(id -> !context.getEntityToCache(id).isPresent()).distinct().toArray()).length > 0) {
            Collection entities;
            MasterStorage masterStorage = (MasterStorage)context.getResourceWithEx(() -> context.getMasterStorage());
            try {
                entities = masterStorage.selectMultiple(notCacheIds);
            }
            catch (SQLException e2) {
                throw new CalculationException(e2.getMessage(), e2);
            }
            entities.forEach(e -> context.putEntityToCache((IEntity)e));
        }
        return (IEntity[])Arrays.stream(ids).mapToObj(id -> context.getEntityToCache(id)).filter(op -> op.isPresent()).map(op -> (IEntity)op.get()).toArray(IEntity[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InfuenceGraph scope(CalculationContext context) throws CalculationException {
        Timer.Sample allSample = Timer.start((MeterRegistry)Metrics.globalRegistry);
        CalculationParticipant sourceParticipant = CalculationParticipant.Builder.anParticipant().withEntityClass(context.getFocusClass()).withField(EntityField.ILLUSORY_FIELD).withAffectedEntities(Arrays.asList(context.getFocusEntity())).build();
        sourceParticipant.source();
        InfuenceGraph graph = context.getInfuenceGraph() != null ? context.getInfuenceGraph() : new InfuenceGraph(sourceParticipant);
        try {
            Collection<IEntityField> fields = this.parseChangeFields(context, false);
            switch (context.getScenariso()) {
                case BUILD: {
                    context.addValueChange(ValueChange.build(context.getFocusEntity().id(), (IValue)new EmptyTypedValue(EntityField.ID_ENTITY_FIELD), (IValue)new LongValue(EntityField.ID_ENTITY_FIELD, context.getFocusEntity().id())));
                    fields.add(EntityField.ID_ENTITY_FIELD);
                    break;
                }
                case DELETE: {
                    context.addValueChange(ValueChange.build(context.getFocusEntity().id(), (IValue)new LongValue(EntityField.ID_ENTITY_FIELD, context.getFocusEntity().id()), (IValue)new EmptyTypedValue(EntityField.ID_ENTITY_FIELD)));
                    fields.add(EntityField.ID_ENTITY_FIELD);
                    break;
                }
                case REPLACE: {
                    LongValue value = new LongValue(EntityField.ID_ENTITY_FIELD, context.getFocusEntity().id());
                    context.addValueChange(ValueChange.build(context.getFocusEntity().id(), (IValue)value, (IValue)value));
                    fields.add(EntityField.ID_ENTITY_FIELD);
                    break;
                }
                default: {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("The current scenario {} does not affect the number of instances and does not add a variable number of influence trees.", (Object)context.getScenariso().name());
                }
            }
            CalculationLogicFactory calculationLogicFactory = (CalculationLogicFactory)context.getResourceWithEx(() -> context.getCalculationLogicFactory());
            Collection<CalculationLogic> logics = this.getNeedMaintainScenariosLogic(calculationLogicFactory, context.getScenariso());
            Collection changeFields = fields.stream().filter(f -> context.getValueChange(context.getFocusEntity(), (IEntityField)f).isPresent()).map(f -> {
                graph.impact(CalculationParticipant.Builder.anParticipant().withEntityClass(context.getFocusClass()).withField((IEntityField)f).withAffectedEntities(Arrays.asList(context.getFocusEntity())).build());
                return f;
            }).collect(Collectors.toList());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The current processing scenario is {}, and the field changed by object {} instance {} is {}.", new Object[]{context.getScenariso().name(), context.getFocusClass().name(), context.getFocusEntity().id(), changeFields.stream().map(f -> f.name()).collect(Collectors.joining(",", "[", "]"))});
            }
            int oldSize = graph.size();
            for (int i = 0; i < MAX_BUILD_INFUENCE_NUMBER; ++i) {
                for (CalculationLogic logic : logics) {
                    Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
                    logic.scope(context, graph);
                    this.processTimer(logic, sample, "oqs.calculation.logic.delay.latency", "scope", false);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The {} round affects the graph construction, resulting in \n {}.", (Object)(i + 1), (Object)graph);
                }
                if (oldSize == graph.size()) break;
                oldSize = graph.size();
            }
            InfuenceGraph infuenceGraph = graph;
            return infuenceGraph;
        }
        finally {
            this.processTimer(null, allSample, "oqs.calculation.logic.delay.latency", "scope", false);
        }
    }

    private Collection<IEntityField> parseChangeFields(CalculationContext context, boolean onlyCalculationField) {
        IEntityClass entityClass = context.getFocusClass();
        Collection fields = entityClass.fields().stream().filter(f -> {
            if (onlyCalculationField) {
                return f.calculationType().getPriority() > 0;
            }
            return f.calculationType() != CalculationType.UNKNOWN;
        }).filter(f -> {
            CalculationScenarios scenarios = context.getScenariso();
            CalculationType calculationType = f.calculationType();
            switch (scenarios) {
                case BUILD: {
                    if (!calculationType.isBuildNeedNotChange()) break;
                    return true;
                }
                case REPLACE: {
                    if (!calculationType.isReplaceNeedNotChange()) break;
                    return true;
                }
                case DELETE: {
                    if (!calculationType.isDeleteNeedNotChange()) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
            return context.getValueChange(context.getFocusEntity(), (IEntityField)f).isPresent();
        }).sorted(CalculationComparator.getInstance()).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            if (onlyCalculationField) {
                this.logger.debug("Only the fields need to be computed, and the field currently being changed is [{}].", (Object)fields.stream().map(f -> f.name()).collect(Collectors.joining(", ")));
            } else {
                this.logger.debug("All fields are required, and the field currently being changed is [{}].", (Object)fields.stream().map(f -> f.name()).collect(Collectors.joining(", ")));
            }
        }
        return fields;
    }

    private Collection<CalculationLogic> getNeedMaintainScenariosLogic(CalculationLogicFactory calculationLogicFactory, CalculationScenarios currentScenarios) {
        Collection logics = calculationLogicFactory.getCalculationLogics().stream().filter(l -> {
            for (CalculationScenarios scenarios : l.needMaintenanceScenarios()) {
                if (scenarios != currentScenarios) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The current scenario is {}, and the logic to be maintained is [{}].", (Object)currentScenarios.name(), (Object)logics.stream().map(l -> l.getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
        return logics;
    }

    private Collection<IEntity> collectingImpactInstances(Collection<Participant> participants) {
        return participants.stream().map(p -> p.getAffectedEntities()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private void processTimer(CalculationLogic logic, Timer.Sample sample, String metricName, String action, boolean ex) {
        sample.stop(Timer.builder((String)metricName).tags(new String[]{"logic", logic != null ? logic.getClass().getSimpleName() : "all", "action", action, "exception", ex ? CalculationException.class.getSimpleName() : "none"}).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[]{0.5, 0.9, 0.99}).register((MeterRegistry)Metrics.globalRegistry));
    }
}

