/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.dto.AffectedInfo;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.CalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.AvgFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.CollectFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.CountFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.MaxFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.MinFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl.SumFunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.CalculationParticipant;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraphConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationCalculationLogic
implements CalculationLogic {
    final Logger logger = LoggerFactory.getLogger(AggregationCalculationLogic.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<IValue> calculate(CalculationContext context) throws CalculationException {
        Optional<ValueChange> valueChange;
        IEntity entity = context.getFocusEntity();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("begin aggregation entity:{}, field:{}", (Object)context.getFocusClass().name(), (Object)context.getFocusField().name());
        }
        IEntityField aggregationField = context.getFocusField();
        Optional aggregationValue = entity.entityValue().getValue(aggregationField.id());
        if (!aggregationField.calculationType().equals((Object)CalculationType.AGGREGATION)) {
            return Optional.empty();
        }
        Aggregation aggregation = (Aggregation)aggregationField.config().getCalculation();
        IEntity triggerEntity = null;
        Optional<IEntity> triggerEntityOp = context.getMaintenanceTriggerEntity();
        if (!triggerEntityOp.isPresent()) {
            if (!context.getScenariso().equals((Object)CalculationScenarios.BUILD)) return aggregationValue;
            FieldType fieldType = aggregationField.type();
            switch (fieldType) {
                case LONG: {
                    return Optional.of(new LongValue(aggregationField, 0, "0|0"));
                }
                case DECIMAL: {
                    return Optional.of(new DecimalValue(aggregationField, BigDecimal.ZERO, "0|0.0"));
                }
                case STRINGS: {
                    return Optional.of(new StringsValue(aggregationField, new String[0], ""));
                }
            }
            return Optional.of(new DateTimeValue(aggregationField, DateTimeValue.MIN_DATE_TIME, "0|0"));
        }
        triggerEntity = triggerEntityOp.get();
        if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
            if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
                valueChange = Optional.of(ValueChange.build(triggerEntity.id(), (IValue)new EmptyTypedValue(aggregationField), (IValue)new LongValue(aggregationField, 1)));
            } else if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
                valueChange = Optional.of(ValueChange.build(triggerEntity.id(), (IValue)new LongValue(aggregationField, 1), (IValue)new EmptyTypedValue(aggregationField)));
            } else {
                if (!aggregation.getConditions().isPresent()) return Optional.empty();
                valueChange = Optional.empty();
            }
        } else {
            valueChange = this.findChange(context, aggregation, triggerEntity);
        }
        Optional conditionsOp = aggregation.getConditions();
        if (conditionsOp.isPresent()) {
            if (CalculationScenarios.BUILD == context.getScenariso() || CalculationScenarios.DELETE == context.getScenariso()) {
                if (!valueChange.isPresent()) return Optional.empty();
                if (!((Conditions)conditionsOp.get()).match(triggerEntity)) {
                    return Optional.empty();
                }
            } else if (CalculationScenarios.REPLACE == context.getScenariso()) {
                Conditions conditions = (Conditions)conditionsOp.get();
                IEntity oldEntity = this.buildOldEntity(context, triggerEntity);
                boolean oldEntityMatch = conditions.match(oldEntity);
                boolean newEntityMatch = conditions.match(triggerEntity);
                if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                    if (oldEntityMatch && !newEntityMatch) {
                        valueChange = Optional.of(ValueChange.build(triggerEntity.id(), (IValue)new LongValue(aggregationField, 1), (IValue)new EmptyTypedValue(aggregationField)));
                    } else {
                        if (oldEntityMatch || !newEntityMatch) return Optional.empty();
                        valueChange = Optional.of(ValueChange.build(triggerEntity.id(), (IValue)new EmptyTypedValue(aggregationField), (IValue)new LongValue(aggregationField, 1)));
                    }
                } else if (oldEntityMatch && !newEntityMatch) {
                    Optional<IValue> oldValueOp = this.findTriggerValue(valueChange, aggregation, triggerEntity, true);
                    if (!oldValueOp.isPresent()) return Optional.empty();
                    IValue oldValue = oldValueOp.get();
                    valueChange = Optional.of(ValueChange.build(triggerEntity.id(), oldValue, (IValue)new EmptyTypedValue(oldValue.getField())));
                } else if (!oldEntityMatch && newEntityMatch) {
                    Optional<IValue> newValueOp = this.findTriggerValue(valueChange, aggregation, triggerEntity, false);
                    if (!newValueOp.isPresent()) return Optional.empty();
                    IValue newValue = newValueOp.get();
                    valueChange = Optional.of(ValueChange.build(triggerEntity.id(), (IValue)new EmptyTypedValue(newValue.getField()), newValue));
                } else {
                    if (!oldEntityMatch || !newEntityMatch) return Optional.empty();
                    if (!valueChange.isPresent()) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!valueChange.isPresent()) {
            return Optional.empty();
        }
        ValueChange vc = valueChange.get();
        try {
            AggregationType aggregationType = aggregation.getAggregationType();
            switch (aggregationType) {
                case AVG: {
                    return new AvgFunctionStrategy().excute(aggregationValue, vc, context);
                }
                case MAX: {
                    return new MaxFunctionStrategy().excute(aggregationValue, vc, context);
                }
                case MIN: {
                    return new MinFunctionStrategy().excute(aggregationValue, vc, context);
                }
                case SUM: {
                    return new SumFunctionStrategy().excute(aggregationValue, vc, context);
                }
                case COUNT: {
                    return new CountFunctionStrategy().excute(aggregationValue, vc, context);
                }
                case COLLECT: {
                    return new CollectFunctionStrategy().excute(aggregationValue, vc, context);
                }
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            throw new CalculationException(String.format("Aggregation calculation exception. [focus-field :%d-%s, message :%s]", aggregationField.id(), aggregationField.name(), ex.getMessage()), ex);
        }
    }

    @Override
    public void scope(CalculationContext context, InfuenceGraph infuence) {
        infuence.scanNoSource((parentParticipants, participant, infuenceInner) -> {
            IEntityClass participantClass = participant.getEntityClass();
            IEntityField participantField = participant.getField();
            List relationships = participantClass.relationship().stream().filter(r -> r.getRelationType() == Relationship.RelationType.MANY_TO_ONE).collect(Collectors.toList());
            for (Relationship r2 : relationships) {
                IEntityClass relationshipClass = r2.getRightEntityClass(participantClass.ref().getProfile());
                List<IEntityField> fields = relationshipClass.fields().stream().filter(f -> f.calculationType() == CalculationType.AGGREGATION).filter(f -> {
                    Aggregation aggregation = (Aggregation)f.config().getCalculation();
                    if (aggregation.getFieldId() == participantField.id()) {
                        return true;
                    }
                    if (this.isNeedConditionField(context, participantField, (IEntityField)f)) {
                        return true;
                    }
                    return aggregation.getAggregationType() == AggregationType.COUNT && participantField.config().isIdentifie();
                }).collect(Collectors.toList());
                if (fields == null || fields.size() <= 0) continue;
                fields.forEach(f -> {
                    Aggregation aggregation = (Aggregation)f.config().getCalculation();
                    EntityField countId = (EntityField)participantField;
                    EntityField fieldId = (EntityField)f;
                    if (countId.name().equals(EntityField.ID_ENTITY_FIELD.name())) {
                        if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                            infuenceInner.impact(participant, CalculationParticipant.Builder.anParticipant().withEntityClass(relationshipClass).withField((IEntityField)f).build());
                        } else {
                            infuenceInner.impact(participant, CalculationParticipant.Builder.anParticipant().withEntityClass(relationshipClass).withField(EntityField.ID_ENTITY_FIELD).build());
                        }
                    } else if (!aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                        infuenceInner.impact(participant, CalculationParticipant.Builder.anParticipant().withEntityClass(relationshipClass).withField((IEntityField)f).build());
                    }
                });
            }
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
    }

    @Override
    public Collection<AffectedInfo> getMaintainTarget(CalculationContext context, Participant participant, Collection<IEntity> entities) throws CalculationException {
        IEntityField entityField = participant.getField();
        Aggregation aggregation = (Aggregation)entityField.config().getCalculation();
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AffectedInfo> affectedEntityIds = new ArrayList<AffectedInfo>(entities.size());
        for (IEntity entity : entities) {
            Optional aggEntityId = entity.entityValue().getValue(aggregation.getRelationId());
            if (!aggEntityId.isPresent()) continue;
            affectedEntityIds.add(new AffectedInfo(entity, ((IValue)aggEntityId.get()).valueToLong()));
        }
        return affectedEntityIds;
    }

    private boolean needCauseCondition(CalculationContext context, IEntityClass entityClass, IEntityField field) {
        Collection relationshipClass = entityClass.relationship().stream().filter(r -> r.getRelationType() == Relationship.RelationType.MANY_TO_ONE).map(r -> r.getRightEntityClass(entityClass.profile())).collect(Collectors.toList());
        for (IEntityClass rec : relationshipClass) {
            for (IEntityField relationField : rec.fields()) {
                if (!this.isNeedRootField(context, relationField)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CalculationType supportType() {
        return CalculationType.AGGREGATION;
    }

    @Override
    public CalculationScenarios[] needMaintenanceScenarios() {
        return new CalculationScenarios[]{CalculationScenarios.BUILD, CalculationScenarios.REPLACE, CalculationScenarios.DELETE};
    }

    private boolean isNeedConditionField(CalculationContext context, IEntityField currentField, IEntityField targetField) {
        if (targetField.calculationType() == CalculationType.AGGREGATION && Aggregation.class.isInstance(targetField.config().getCalculation()) && ((Aggregation)targetField.config().getCalculation()).getConditions().isPresent()) {
            Conditions conditions = (Conditions)((Aggregation)targetField.config().getCalculation()).getConditions().get();
            return conditions.collectField().stream().anyMatch(cf -> cf.id() == currentField.id());
        }
        return false;
    }

    private boolean isNeedRootField(CalculationContext context, IEntityField field) {
        if (field.calculationType() == CalculationType.AGGREGATION && Aggregation.class.isInstance(field.config().getCalculation()) && ((Aggregation)field.config().getCalculation()).getConditions().isPresent() && field.id() == ((Aggregation)field.config().getCalculation()).getFieldId()) {
            Conditions conditions = (Conditions)((Aggregation)field.config().getCalculation()).getConditions().get();
            Collection conditionFields = conditions.collectField();
            for (IEntityField conditionField : conditionFields) {
                if (!context.getValueChanges().stream().anyMatch(v -> v.getField().id() == conditionField.id())) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<IValue> findTriggerValue(Optional<ValueChange> valueChange, Aggregation aggregation, IEntity triggerEntity, boolean old) {
        if (old) {
            if (valueChange.isPresent()) {
                return valueChange.get().getOldValue();
            }
        } else if (valueChange.isPresent()) {
            return valueChange.get().getNewValue();
        }
        return triggerEntity.entityValue().getValue(aggregation.getFieldId());
    }

    private IEntity buildOldEntity(CalculationContext context, IEntity entity) {
        IEntity copyEntity = entity.copy();
        context.getValueChanges().stream().filter(vc -> vc.getEntityId() == copyEntity.id()).map(vc -> vc.getOldValue()).filter(od -> od.isPresent()).forEach(od -> {
            if (EmptyTypedValue.class.isInstance(od.get())) {
                copyEntity.entityValue().remove(((IValue)od.get()).getField());
            } else {
                copyEntity.entityValue().addValue((IValue)od.get());
            }
        });
        return copyEntity;
    }

    private Optional<ValueChange> findChange(CalculationContext context, Aggregation aggregation, IEntity entity) {
        Optional triggerEntityClassOp = context.getMetaManager().get().load(entity.entityClassRef());
        if (!triggerEntityClassOp.isPresent()) {
            throw new CalculationException(String.format("The expected target object meta information was not found.[%s]", entity.entityClassRef()));
        }
        IEntityClass triggerEntityClass = (IEntityClass)triggerEntityClassOp.get();
        Optional triggerFieldOp = triggerEntityClass.field(aggregation.getFieldId());
        if (!triggerFieldOp.isPresent()) {
            throw new CalculationException(String.format("The expected field (%s) does not exist.", aggregation.getFieldId()));
        }
        return context.getValueChange(entity, (IEntityField)triggerFieldOp.get());
    }
}

