/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation;

import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationInitException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInit;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitInstance;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitInstanceUnit;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory.InitIvalueFactory;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory.InitIvalueLogic;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InitCalculationParticipant;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCalculationInitImpl
implements CalculationInit {
    private final Logger logger = LoggerFactory.getLogger(DefaultCalculationInitImpl.class);
    @Resource
    private InitIvalueFactory initIvalueFactory;
    @Resource
    private MetaManager metaManager;

    @Override
    public IEntity init(InitInstance initInstance) {
        List<InitInstanceUnit> initInstanceUnits = initInstance.getInitInstanceUnits();
        for (InitInstanceUnit initInstanceUnit : initInstanceUnits) {
            this.initUnit(initInstanceUnit);
        }
        return initInstance.getEntity();
    }

    @Override
    public List<IEntity> init(List<InitInstance> initInstances) {
        return initInstances.stream().map(this::init).collect(Collectors.toList());
    }

    private IEntity initUnit(InitInstanceUnit initInstanceUnit) {
        IEntity entity = initInstanceUnit.getEntity();
        IEntityClass entityClass = initInstanceUnit.getEntityClass();
        IEntityField field = initInstanceUnit.getField();
        InitCalculationParticipant participant = this.build(entityClass, field, field.calculationType());
        InitIvalueLogic logic = this.initIvalueFactory.getLogic(field.calculationType());
        try {
            return logic.init(entity, participant);
        }
        catch (Exception e) {
            throw new CalculationInitException(e);
        }
    }

    private InitCalculationParticipant build(IEntityClass entityClass, IEntityField entityField, CalculationType calculationType) {
        InitCalculationParticipant.Builder builder = InitCalculationParticipant.Builder.anInitCalculationParticipant().withEntityClass(entityClass).withField(entityField).withNeedInit(true);
        switch (calculationType) {
            case FORMULA: {
                Formula formula = (Formula)entityField.config().getCalculation();
                if (formula.getArgs() == null || formula.getArgs().isEmpty()) {
                    return builder.build();
                }
                ArrayList<IEntityField> sourceFields = new ArrayList<IEntityField>();
                formula.getArgs().forEach(s -> {
                    if (entityClass.field(s).isPresent()) {
                        sourceFields.add((IEntityField)entityClass.field(s).get());
                    }
                });
                return builder.withSourceFields(sourceFields).withSourceEntityClass(entityClass).build();
            }
            case AGGREGATION: {
                Aggregation aggregation = (Aggregation)entityField.config().getCalculation();
                Optional entityClassOptional = this.metaManager.load(aggregation.getClassId(), null);
                if (entityClassOptional.isPresent()) {
                    if (((IEntityClass)entityClassOptional.get()).field(aggregation.getFieldId()).isPresent()) {
                        ArrayList<IEntityField> fields = new ArrayList<IEntityField>();
                        fields.add((IEntityField)((IEntityClass)entityClassOptional.get()).field(aggregation.getFieldId()).get());
                        return builder.withSourceEntityClass((IEntityClass)entityClassOptional.get()).withSourceFields(fields).build();
                    }
                    if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                        return builder.withSourceEntityClass((IEntityClass)entityClassOptional.get()).build();
                    }
                    this.logger.error(String.format("can not find entityField %s in entityClass %s", aggregation.getFieldId(), aggregation.getClassId()));
                    throw new CalculationException(String.format("init calculation error: can not find entityField %s in entityClass %s", aggregation.getFieldId(), aggregation.getClassId()));
                }
                this.logger.error(String.format("can not find entityClass %s", aggregation.getClassId()));
                throw new CalculationException(String.format("init calculation error: can not find entityClass %s", aggregation.getAggregationType()));
            }
            case AUTO_FILL: {
                AutoFill autoFill = (AutoFill)entityField.config().getCalculation();
                if (autoFill.getArgs() == null || autoFill.getArgs().isEmpty()) {
                    return builder.build();
                }
                ArrayList<IEntityField> fields = new ArrayList<IEntityField>();
                autoFill.getArgs().forEach(s -> {
                    if (entityClass.field(s).isPresent()) {
                        fields.add((IEntityField)entityClass.field(s).get());
                    }
                });
                return builder.withSourceFields(fields).withSourceEntityClass(entityClass).build();
            }
        }
        throw new CalculationException(String.format("init calculation error: not support calculationType %s , can not transfer to InitCalculationParticipant", calculationType.name()));
    }
}

