/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation;

import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInitLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInitStatus;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitCalculationInfo;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitCalculationManager;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitResultInfo;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.AbstractParticipant;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Infuence;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InitCalculationParticipant;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.common.serializable.SerializeStrategy;
import com.xforceplus.ultraman.oqsengine.lock.ResourceLocker;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Lookup;
import com.xforceplus.ultraman.oqsengine.storage.KeyValueStorage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInitCalculationManager
implements InitCalculationManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultInitCalculationManager.class);
    @Resource
    private MetaManager metaManager;
    @Resource
    private KeyValueStorage kv;
    @Resource
    private SerializeStrategy serializeStrategy;
    @Resource
    private CalculationInitLogic calculationInitLogic;
    @Resource
    private ResourceLocker locker;
    @Resource(name="taskThreadPool")
    private ExecutorService worker;
    private final List<CalculationType> participantTypes = new ArrayList<CalculationType>();
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static final String INITING = "-initing";
    private static final String INIT_FLAG = "calculationInitField-";
    private static final int AGE_LIMIT = 1000;

    public DefaultInitCalculationManager() {
        this.participantTypes.add(CalculationType.FORMULA);
        this.participantTypes.add(CalculationType.AGGREGATION);
        this.participantTypes.add(CalculationType.AUTO_FILL);
    }

    public void setWorker(ExecutorService worker) {
        this.worker = worker;
    }

    @Override
    public Collection<Participant> getParticipant(Collection<IEntityClass> entityClasses) {
        HashSet<Participant> abstractParticipants = new HashSet<Participant>();
        entityClasses.forEach(entityClass -> entityClass.fields().forEach(entityField -> {
            if (this.participantTypes.contains(entityField.calculationType())) {
                AbstractParticipant build = this.build((IEntityClass)entityClass, (IEntityField)entityField, entityField.calculationType());
                abstractParticipants.add(build);
            }
        }));
        return abstractParticipants;
    }

    @Override
    public List<Infuence> generateInfluence(Collection<Participant> abstractParticipants) {
        ArrayList<Infuence> infuences = new ArrayList<Infuence>();
        abstractParticipants.forEach(participant -> {
            if (this.isRootNode((Participant)participant)) {
                Infuence infuence = new Infuence(null, (Participant)participant, null);
                infuences.add(infuence);
            }
        });
        infuences.forEach(infuence -> infuence.scan((parentParticipant, participant, infuenceInner) -> {
            abstractParticipants.forEach(p -> {
                InitCalculationParticipant pt = (InitCalculationParticipant)p;
                if (pt.getSourceFields().contains(participant.getField()) && this.canImpact(pt, participant)) {
                    boolean needImpact = true;
                    for (Infuence in : infuences) {
                        if (!in.contains(pt) || in.getLevel(pt) - infuenceInner.getLevel(participant) > 1) continue;
                        needImpact = false;
                        if (in.getPre(pt).isPresent()) {
                            in.pruning(in.getPre(pt).get(), (Participant)pt);
                        }
                        infuenceInner.impact(participant, pt);
                        break;
                    }
                    if (needImpact) {
                        infuenceInner.impact(participant, pt);
                    }
                }
            });
            return InfuenceConsumer.Action.CONTINUE;
        }));
        return infuences;
    }

    @Override
    public Set<Participant> getNeedInitParticipant(Collection<Participant> abstractParticipants, Collection<Infuence> infuences) {
        HashSet<Participant> needs = new HashSet<Participant>();
        HashMap needsInitMap = new HashMap();
        abstractParticipants.forEach(participant -> {
            if (this.needInit(participant.getField().id())) {
                LinkedList<Participant> queue = new LinkedList<Participant>();
                queue.add((Participant)participant);
                while (!queue.isEmpty()) {
                    Participant poll = (Participant)queue.poll();
                    needs.add(poll);
                    needsInitMap.put(INIT_FLAG + poll.getField().id(), this.serializeStrategy.serialize((Serializable)((Object)CalculationInitStatus.UN_INIT)));
                    Optional<Collection<Object>> nextParticipants = Optional.empty();
                    for (Infuence infuence : infuences) {
                        if (!infuence.contains(poll)) continue;
                        nextParticipants = infuence.getNextParticipants(poll);
                        break;
                    }
                    nextParticipants.ifPresent(queue::addAll);
                }
            }
        });
        this.kv.save(needsInitMap.entrySet());
        return needs;
    }

    @Override
    public InitCalculationInfo generateAppInfo(String code) {
        ArrayList<IEntityClass> entityClasses = new ArrayList<IEntityClass>(this.metaManager.appLoad(code));
        Collection<Participant> all = this.getParticipant(entityClasses);
        List<Infuence> infuences = this.generateInfluence(all);
        Set<Participant> need = this.getNeedInitParticipant(all, infuences);
        return InitCalculationInfo.Builder.anEmptyBuilder().withCode(code).withAll(all).withCandidate(new HashMap<IEntityClass, HashSet<Participant>>()).withNeed(need).withInfuences(infuences).build();
    }

    @Override
    public boolean isComplete(InitCalculationInfo initCalculationInfo) {
        initCalculationInfo.growUp();
        if (initCalculationInfo.getAge() >= 1000) {
            throw new CalculationException(initCalculationInfo.getCode() + "init failed , cause of exceed age limit " + 1000 + initCalculationInfo);
        }
        return initCalculationInfo.getNeed().isEmpty() && initCalculationInfo.getCandidate().isEmpty() && initCalculationInfo.getRun().isEmpty();
    }

    @Override
    public Map<IEntityClass, HashSet<Participant>> voteCandidate(InitCalculationInfo initCalculationInfo) {
        Map<IEntityClass, HashSet<Participant>> candidate = initCalculationInfo.getCandidate();
        if (initCalculationInfo.isInitFlag()) {
            initCalculationInfo.getInfuences().forEach(infuence -> infuence.scan((parentParticipant, participant, infuenceInner) -> {
                if (candidate.containsKey(participant.getEntityClass())) {
                    ((HashSet)candidate.get(participant.getEntityClass())).add(participant);
                } else {
                    candidate.put(participant.getEntityClass(), (HashSet)Stream.of(participant).collect(Collectors.toSet()));
                }
                initCalculationInfo.getNeed().remove(participant);
                return InfuenceConsumer.Action.OVER;
            }));
            initCalculationInfo.setInitFlag(false);
        } else {
            if (candidate.size() > 0) {
                candidate.values().forEach(participants -> participants.forEach(participant -> ((InitCalculationParticipant)participant).growUp()));
            }
            Collection historyAbstractParticipant = candidate.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            historyAbstractParticipant.forEach(participant -> {
                for (Infuence infuence : initCalculationInfo.getInfuences()) {
                    Optional<Collection<Participant>> nextParticipants;
                    if (!infuence.contains((Participant)participant) || !(nextParticipants = infuence.getNextParticipants((Participant)participant)).isPresent()) continue;
                    nextParticipants.get().forEach(participant1 -> {
                        if (candidate.containsKey(participant1.getEntityClass())) {
                            ((HashSet)candidate.get(participant1.getEntityClass())).add(participant1);
                        } else {
                            candidate.put(participant1.getEntityClass(), (HashSet)Stream.of(participant1).collect(Collectors.toSet()));
                        }
                        initCalculationInfo.getNeed().remove(participant1);
                    });
                }
            });
            initCalculationInfo.getRun().forEach(participant -> {
                ((HashSet)candidate.get(participant.getEntityClass())).remove(participant);
                if (((HashSet)candidate.get(participant.getEntityClass())).isEmpty()) {
                    candidate.remove(participant.getEntityClass());
                }
            });
            initCalculationInfo.getRun().clear();
        }
        return candidate;
    }

    @Override
    public Collection<Participant> voteRun(InitCalculationInfo initCalculationInfo) {
        if (initCalculationInfo.getCandidate() == null || initCalculationInfo.getCandidate().isEmpty()) {
            return Collections.emptyList();
        }
        for (IEntityClass next : initCalculationInfo.getCandidate().keySet()) {
            if (!this.canVoteRun(next, initCalculationInfo)) continue;
            initCalculationInfo.getRun().addAll((Collection<Participant>)initCalculationInfo.getCandidate().get(next));
        }
        return initCalculationInfo.getRun();
    }

    @Override
    public List<Map<IEntityClass, Collection<InitCalculationParticipant>>> sortRun(Collection<Participant> abstractParticipants, InitCalculationInfo initCalculationInfo) {
        if (abstractParticipants.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<IEntityClass, Collection<InitCalculationParticipant>> map = new HashMap<IEntityClass, Collection<InitCalculationParticipant>>();
        abstractParticipants.forEach(participant -> {
            if (map.containsKey(participant.getEntityClass())) {
                ((Collection)map.get(participant.getEntityClass())).add((InitCalculationParticipant)participant);
            } else {
                TreeSet<InitCalculationParticipant> set = new TreeSet<InitCalculationParticipant>();
                set.add((InitCalculationParticipant)participant);
                map.put(participant.getEntityClass(), set);
            }
        });
        List<Set<IEntityClass>> sets = this.individualClasses(null, map, new ArrayList<Set<IEntityClass>>());
        ArrayList<Map<IEntityClass, Collection<InitCalculationParticipant>>> run = new ArrayList<Map<IEntityClass, Collection<InitCalculationParticipant>>>(sets.size());
        for (Set<IEntityClass> set : sets) {
            HashMap hashMap = new HashMap();
            set.forEach(entityClass -> {
                List collect = ((Collection)map.get(entityClass)).stream().filter(initCalculationParticipant -> !initCalculationInfo.getSkip().contains(initCalculationParticipant)).collect(Collectors.toList());
                if (collect.size() > 0) {
                    hashMap.put(entityClass, collect);
                }
            });
            if (hashMap.size() <= 0) continue;
            run.add(hashMap);
        }
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IEntityField> initAppCalculations(String appCode) {
        try {
            block6: {
                boolean b = false;
                try {
                    b = this.locker.tryLock(0x7FFFFFFFFFFFFFFEL, appCode);
                }
                catch (InterruptedException e) {
                    if (b) break block6;
                    throw new RuntimeException(String.format("try lock failed when get source %s", appCode));
                }
            }
            if (this.kv.exist(appCode + INITING)) {
                throw new RuntimeException(String.format("curent app %s is initing now, please wait", appCode));
            }
            List<IEntityField> entityFields = this.generateAppInfo(appCode).getNeed().stream().map(Participant::getField).collect(Collectors.toList());
            this.worker.submit(new Runner(appCode));
            this.kv.save(appCode + INITING, this.serializeStrategy.serialize((Serializable)Integer.valueOf(1)));
            List<IEntityField> list = entityFields;
            return list;
        }
        finally {
            this.locker.unlock(appCode);
        }
    }

    private List<Set<IEntityClass>> individualClasses(Collection<IEntityClass> up, Map<IEntityClass, Collection<InitCalculationParticipant>> map, List<Set<IEntityClass>> individuals) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        Set<IEntityClass> all = map.keySet();
        LinkedHashSet<IEntityClass> temp = new LinkedHashSet<IEntityClass>();
        if (up == null) {
            for (IEntityClass entityClass : all) {
                if (!map.get(entityClass).stream().noneMatch(initCalculationParticipant -> map.containsKey(initCalculationParticipant.getSourceEntityClass()) && !initCalculationParticipant.getSourceEntityClass().equals(entityClass))) continue;
                temp.add(entityClass);
            }
            if (temp.isEmpty()) {
                this.logger.error("sortRun error");
                return new ArrayList<Set<IEntityClass>>();
            }
            individuals.add(temp);
            up = temp;
            return this.individualClasses(up, map, individuals);
        }
        Collection<IEntityClass> finalUp = up;
        for (IEntityClass entityClass : all) {
            if (!map.get(entityClass).stream().anyMatch(initCalculationParticipant -> finalUp.contains(initCalculationParticipant.getSourceEntityClass()) && !initCalculationParticipant.getEntityClass().equals(initCalculationParticipant.getSourceEntityClass()))) continue;
            temp.add(entityClass);
        }
        if (temp.isEmpty()) {
            if (individuals.size() >= 2) {
                ArrayList<Set<IEntityClass>> clone = new ArrayList<Set<IEntityClass>>(individuals);
                for (int size = individuals.size() - 2; size > 0; --size) {
                    for (int j = individuals.size() - 1; j < size; --j) {
                        ((Set)clone.get(size)).removeAll((Collection)clone.get(j));
                    }
                }
                return clone;
            }
            return individuals;
        }
        individuals.add(temp);
        up = temp;
        return this.individualClasses(up, map, individuals);
    }

    private boolean canImpact(AbstractParticipant child, Participant father) {
        if (!child.getField().calculationType().equals((Object)CalculationType.FORMULA) && !child.getField().calculationType().equals((Object)CalculationType.AUTO_FILL)) {
            return true;
        }
        InitCalculationParticipant initCalculationParticipant = (InitCalculationParticipant)child;
        HashSet<IEntityField> fields = new HashSet<IEntityField>(initCalculationParticipant.getSourceFields());
        fields.remove(father.getField());
        if (child.getField().calculationType().equals((Object)CalculationType.FORMULA) || child.getField().calculationType().equals((Object)CalculationType.AUTO_FILL)) {
            return !this.transitiveDependency(child.getEntityClass(), fields, father.getField());
        }
        return false;
    }

    private boolean canVoteRun(IEntityClass entityClass, InitCalculationInfo initCalculationInfo) {
        Set<IEntityClass> set = this.transitiveEntityClass(entityClass, initCalculationInfo);
        for (Participant participant : initCalculationInfo.getNeed()) {
            if (!set.contains(participant.getEntityClass())) continue;
            return false;
        }
        return true;
    }

    private Set<IEntityClass> transitiveEntityClass(IEntityClass entityClass, InitCalculationInfo initCalculationInfo) {
        HashSet<IEntityClass> set = new HashSet<IEntityClass>();
        Iterator<Participant> iterator = initCalculationInfo.getCandidate().get(entityClass).iterator();
        while (iterator.hasNext()) {
            Participant participant;
            Participant pre = participant = iterator.next();
            while (pre != null) {
                set.add(pre.getEntityClass());
                for (Infuence infuence : initCalculationInfo.getInfuences()) {
                    if (!infuence.contains(pre)) continue;
                    Optional<Participant> p = infuence.getPre(pre);
                    pre = p.orElse(null);
                }
            }
        }
        return set;
    }

    private boolean transitiveDependency(IEntityClass entityClass, Collection<IEntityField> fields, IEntityField source) {
        if (fields.size() == 0) {
            return false;
        }
        ArrayList<IEntityField> resFields = new ArrayList<IEntityField>();
        for (IEntityField entityField : fields) {
            List<IEntityField> nextFields = this.nextFields(entityClass, entityField);
            if (nextFields.contains(source)) {
                return true;
            }
            resFields.addAll(nextFields);
        }
        fields = null;
        return this.transitiveDependency(entityClass, resFields, source);
    }

    private List<IEntityField> nextFields(IEntityClass entityClass, IEntityField field) {
        AutoFill calculation;
        ArrayList<IEntityField> fields = new ArrayList<IEntityField>();
        if (field.config().getCalculation().getCalculationType().equals((Object)CalculationType.AUTO_FILL) && (calculation = (AutoFill)field.config().getCalculation()).getArgs() != null) {
            for (String arg : calculation.getArgs()) {
                if (!entityClass.field(arg).isPresent()) continue;
                fields.add((IEntityField)entityClass.field(arg).get());
            }
        }
        if (field.config().getCalculation().getCalculationType().equals((Object)CalculationType.FORMULA)) {
            calculation = (Formula)field.config().getCalculation();
            for (String arg : calculation.getArgs()) {
                if (!entityClass.field(arg).isPresent()) continue;
                fields.add((IEntityField)entityClass.field(arg).get());
            }
        }
        return fields;
    }

    private boolean isRootNode(Participant abstractParticipant) {
        InitCalculationParticipant initCalculationParticipant = (InitCalculationParticipant)abstractParticipant;
        AbstractCalculation calculation = initCalculationParticipant.getField().config().getCalculation();
        if (calculation.getCalculationType().equals((Object)CalculationType.AGGREGATION)) {
            Aggregation aggregation = (Aggregation)calculation;
            if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                return true;
            }
            return this.isStaticField(aggregation.getClassId(), aggregation.getFieldId());
        }
        if (calculation.getCalculationType().equals((Object)CalculationType.FORMULA)) {
            IEntityClass entityClass = initCalculationParticipant.getEntityClass();
            Formula formula = (Formula)calculation;
            if (formula.getArgs() == null || formula.getArgs().isEmpty()) {
                return true;
            }
            return formula.getArgs().stream().noneMatch(arg -> {
                if (entityClass.field(arg).isPresent()) {
                    return !this.isStaticField(entityClass.id(), ((IEntityField)entityClass.field(arg).get()).id());
                }
                return false;
            });
        }
        if (calculation.getCalculationType().equals((Object)CalculationType.AUTO_FILL)) {
            IEntityClass entityClass = initCalculationParticipant.getEntityClass();
            AutoFill autoFill = (AutoFill)calculation;
            if (autoFill.getArgs() == null || autoFill.getArgs().isEmpty()) {
                return true;
            }
            return autoFill.getArgs().stream().noneMatch(arg -> {
                if (entityClass.field(arg).isPresent()) {
                    return !this.isStaticField(entityClass.id(), ((IEntityField)entityClass.field(arg).get()).id());
                }
                return false;
            });
        }
        if (calculation.getCalculationType().equals((Object)CalculationType.LOOKUP)) {
            Lookup lookup = (Lookup)calculation;
            return this.isStaticField(lookup.getClassId(), lookup.getFieldId());
        }
        return false;
    }

    private boolean isStaticField(long entityClassId, long entityFieldId) {
        Optional entityClassOptional = this.metaManager.load(entityClassId, null);
        if (entityClassOptional.isPresent()) {
            if (((IEntityClass)entityClassOptional.get()).field(entityFieldId).isPresent()) {
                return ((IEntityField)((IEntityClass)entityClassOptional.get()).field(entityFieldId).get()).calculationType().equals((Object)CalculationType.STATIC);
            }
            this.logger.warn(String.format("can not find field by fieldId %s in entityClass %s", entityFieldId, entityClassId));
        }
        return false;
    }

    private AbstractParticipant build(IEntityClass entityClass, IEntityField entityField, CalculationType calculationType) {
        InitCalculationParticipant.Builder builder = InitCalculationParticipant.Builder.anInitCalculationParticipant().withEntityClass(entityClass).withField(entityField);
        switch (calculationType) {
            case FORMULA: {
                Formula formula = (Formula)entityField.config().getCalculation();
                if (formula.getArgs() == null || formula.getArgs().isEmpty()) {
                    return builder.build();
                }
                ArrayList<IEntityField> sourceFields = new ArrayList<IEntityField>();
                formula.getArgs().forEach(s -> {
                    if (entityClass.field(s).isPresent()) {
                        sourceFields.add((IEntityField)entityClass.field(s).get());
                    }
                });
                return builder.withSourceFields(sourceFields).withSourceEntityClass(entityClass).build();
            }
            case AGGREGATION: {
                Aggregation aggregation = (Aggregation)entityField.config().getCalculation();
                Optional entityClassOptional = this.metaManager.load(aggregation.getClassId(), null);
                if (entityClassOptional.isPresent()) {
                    if (((IEntityClass)entityClassOptional.get()).field(aggregation.getFieldId()).isPresent()) {
                        ArrayList<IEntityField> fields = new ArrayList<IEntityField>();
                        fields.add((IEntityField)((IEntityClass)entityClassOptional.get()).field(aggregation.getFieldId()).get());
                        return builder.withSourceEntityClass((IEntityClass)entityClassOptional.get()).withSourceFields(fields).build();
                    }
                    if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                        return builder.withSourceEntityClass((IEntityClass)entityClassOptional.get()).build();
                    }
                    this.logger.error(String.format("can not find entityField %s in entityClass %s", aggregation.getFieldId(), aggregation.getClassId()));
                    throw new CalculationException(String.format("init calculation error: can not find entityField %s in entityClass %s", aggregation.getFieldId(), aggregation.getClassId()));
                }
                this.logger.error(String.format("can not find entityClass %s", aggregation.getClassId()));
                throw new CalculationException(String.format("init calculation error: can not find entityClass %s", aggregation.getAggregationType()));
            }
            case AUTO_FILL: {
                AutoFill autoFill = (AutoFill)entityField.config().getCalculation();
                if (autoFill.getArgs() == null || autoFill.getArgs().isEmpty()) {
                    return builder.build();
                }
                ArrayList<IEntityField> fields = new ArrayList<IEntityField>();
                autoFill.getArgs().forEach(s -> {
                    if (entityClass.field(s).isPresent()) {
                        fields.add((IEntityField)entityClass.field(s).get());
                    }
                });
                return builder.withSourceFields(fields).withSourceEntityClass(entityClass).build();
            }
        }
        throw new CalculationException(String.format("init calculation error: not support calculationType %s , can not transfer to InitCalculationParticipant", calculationType.name()));
    }

    private boolean needInit(long fieldID) {
        if (!this.kv.exist(INIT_FLAG + fieldID)) {
            return true;
        }
        if (this.kv.get(INIT_FLAG + fieldID).isPresent()) {
            byte[] bytes = (byte[])this.kv.get(INIT_FLAG + fieldID).get();
            return ((CalculationInitStatus)((Object)this.serializeStrategy.unserialize(bytes, CalculationInitStatus.class))).equals((Object)CalculationInitStatus.UN_INIT);
        }
        return false;
    }

    public class Runner
    implements Callable<InitResultInfo> {
        private final String appCode;

        public Runner(String appCode) {
            this.appCode = appCode;
        }

        @Override
        public InitResultInfo call() throws Exception {
            long begin = System.currentTimeMillis();
            InitResultInfo initResultInfo = new InitResultInfo();
            InitCalculationInfo initCalculationInfo = DefaultInitCalculationManager.this.generateAppInfo(this.appCode);
            try {
                while (!DefaultInitCalculationManager.this.isComplete(initCalculationInfo)) {
                    DefaultInitCalculationManager.this.voteCandidate(initCalculationInfo);
                    Collection<Participant> participants = DefaultInitCalculationManager.this.voteRun(initCalculationInfo);
                    List<Map<IEntityClass, Collection<InitCalculationParticipant>>> run = DefaultInitCalculationManager.this.sortRun(participants, initCalculationInfo);
                    if (run.isEmpty()) continue;
                    Map<String, List<InitCalculationParticipant>> accept = DefaultInitCalculationManager.this.calculationInitLogic.accept(run);
                    HashMap<String, byte[]> done = new HashMap<String, byte[]>();
                    if (accept.get(DefaultInitCalculationManager.SUCCESS) != null && !accept.get(DefaultInitCalculationManager.SUCCESS).isEmpty()) {
                        List<InitCalculationParticipant> successRes = accept.get(DefaultInitCalculationManager.SUCCESS);
                        for (InitCalculationParticipant success : successRes) {
                            if (initResultInfo.getSuccessInfo().containsKey(success.getEntityClass().id())) {
                                initResultInfo.getSuccessInfo().get(success.getEntityClass().id()).add(success.getField().id());
                            } else {
                                initResultInfo.getSuccessInfo().put(success.getEntityClass().id(), Stream.of(Long.valueOf(success.getField().id())).collect(Collectors.toList()));
                            }
                            done.put(DefaultInitCalculationManager.INIT_FLAG + success.getField().id(), DefaultInitCalculationManager.this.serializeStrategy.serialize((Serializable)((Object)CalculationInitStatus.INIT_DONE)));
                        }
                    }
                    DefaultInitCalculationManager.this.kv.save(done.entrySet());
                    if (accept.get(DefaultInitCalculationManager.FAILED) == null || accept.get(DefaultInitCalculationManager.FAILED).isEmpty()) continue;
                    List<InitCalculationParticipant> failedRes = accept.get(DefaultInitCalculationManager.FAILED);
                    for (InitCalculationParticipant failedRe : failedRes) {
                        if (initResultInfo.getFailedInfo().containsKey(failedRe.getEntityClass().id())) {
                            initResultInfo.getFailedInfo().get(failedRe.getEntityClass().id()).add(failedRe.getField().id());
                            continue;
                        }
                        initResultInfo.getFailedInfo().put(failedRe.getEntityClass().id(), Stream.of(Long.valueOf(failedRe.getField().id())).collect(Collectors.toList()));
                    }
                    throw new CalculationException("init failed when process app " + this.appCode + ": " + initResultInfo);
                }
            }
            catch (Exception e) {
                DefaultInitCalculationManager.this.logger.error(e.getMessage(), (Throwable)e);
                for (Participant participant : initCalculationInfo.getNeed()) {
                    if (initResultInfo.getFailedInfo().containsKey(participant.getEntityClass().id())) {
                        initResultInfo.getFailedInfo().get(participant.getEntityClass().id()).add(participant.getField().id());
                        continue;
                    }
                    initResultInfo.getFailedInfo().put(participant.getEntityClass().id(), Stream.of(Long.valueOf(participant.getField().id())).collect(Collectors.toList()));
                }
            }
            HashMap map = new HashMap();
            if (DefaultInitCalculationManager.this.kv.exist(this.appCode + "-initResLog")) {
                map = (HashMap)DefaultInitCalculationManager.this.serializeStrategy.unserialize((byte[])DefaultInitCalculationManager.this.kv.get(this.appCode + "-initResLog").get(), HashMap.class);
            }
            map.put(begin, initResultInfo);
            DefaultInitCalculationManager.this.kv.save(this.appCode + "-initResLog", DefaultInitCalculationManager.this.serializeStrategy.serialize((Serializable)map));
            DefaultInitCalculationManager.this.kv.delete(this.appCode + DefaultInitCalculationManager.INITING);
            return initResultInfo;
        }
    }
}

