/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.util.Objects;
import java.util.Optional;

public class ValueChange {
    private long entityId;
    private IEntityField field;
    private IValue oldValue;
    private IValue newValue;

    public static ValueChange build(long entityId, IValue old, IValue newValue) {
        return new ValueChange(entityId, old, newValue);
    }

    public ValueChange(long entityId, IValue oldValue, IValue newValue) {
        this.entityId = entityId;
        this.oldValue = oldValue;
        this.newValue = newValue;
        if (oldValue == null || newValue == null) {
            throw new NullPointerException("Invalid value object.");
        }
        if (this.oldValue.getField().id() != newValue.getField().id()) {
            throw new IllegalArgumentException(String.format("Different fields cannot be changed.[%s => %s]", this.oldValue.getField().name(), this.newValue.getField().name()));
        }
        this.field = oldValue.getField();
    }

    public IEntityField getField() {
        return this.field;
    }

    public Optional<IValue> getOldValue() {
        return Optional.ofNullable(this.oldValue);
    }

    public Optional<IValue> getNewValue() {
        return Optional.ofNullable(this.newValue);
    }

    public long getEntityId() {
        return this.entityId;
    }

    public ValueChange copyFromNewValue(IValue newValue) {
        return ValueChange.build(this.entityId, this.oldValue, newValue);
    }

    public ValueChange copyFormOldValue(IValue oldValue) {
        return ValueChange.build(this.entityId, oldValue, this.newValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oldValue.getField().name()).append(" { ");
        sb.append(this.oldValue != null ? this.oldValue.valueToString() : "NULL").append(" => ").append(this.newValue != null ? this.newValue.valueToString() : "NULL");
        sb.append(" }");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueChange that = (ValueChange)o;
        return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.field, that.field) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.field, this.oldValue, this.newValue);
    }
}

