/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils.infuence;

import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraphConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class InfuenceGraph {
    private Map<Participant, Node> quickLink;
    private Node root;

    public InfuenceGraph(Participant participant) {
        this.root = new Node(participant);
        if (!participant.isSource()) {
            participant.source();
        }
        this.addQuickLink(participant, this.root);
    }

    public int size() {
        return this.quickLink.size();
    }

    public int level() {
        return this.quickLink.values().stream().mapToInt(n -> n.getLevel()).max().getAsInt() + 1;
    }

    public boolean empty() {
        return this.size() == 1;
    }

    public boolean impact(Participant targetParticipant) {
        return this.impact(this.root.getParticipant(), targetParticipant);
    }

    public boolean impact(Participant prentParticipant, Participant targetParticipant) {
        if (prentParticipant.equals(targetParticipant)) {
            return false;
        }
        Optional<Node> optional = this.findQuickLink(prentParticipant);
        if (optional.isPresent()) {
            Node newNode;
            Node parentNode = optional.get();
            optional = this.findQuickLink(targetParticipant);
            AtomicBoolean skip = new AtomicBoolean(false);
            if (optional.isPresent()) {
                newNode = optional.get();
                InfuenceGraph.iterator(parentNode, true, false, n -> {
                    if (n == newNode) {
                        skip.set(true);
                        return InfuenceGraphConsumer.Action.OVER;
                    }
                    return InfuenceGraphConsumer.Action.CONTINUE;
                });
            } else {
                newNode = new Node(targetParticipant);
                this.addQuickLink(targetParticipant, newNode);
            }
            if (skip.get()) {
                return false;
            }
            newNode.addParent(parentNode);
            parentNode.addChild(newNode);
            return true;
        }
        return false;
    }

    public void scanNoSource(InfuenceGraphConsumer consumer) {
        this.scan((parent, participant, inner) -> {
            if (participant.isSource()) {
                return InfuenceGraphConsumer.Action.CONTINUE;
            }
            return consumer.accept(parent, participant, inner);
        });
    }

    public void scan(InfuenceGraphConsumer consumer) {
        this.scan(this.root.getParticipant(), consumer);
    }

    public void scan(Participant startParticipant, InfuenceGraphConsumer consumer) {
        Optional<Node> pointOp = this.findQuickLink(startParticipant);
        if (!pointOp.isPresent()) {
            return;
        }
        Node startNode = pointOp.get();
        InfuenceGraph.iterator(startNode, false, true, currentNode -> {
            Participant participant = currentNode.getParticipant();
            List<Participant> parentParticipants = currentNode.getParents().stream().map(n -> n.getParticipant()).collect(Collectors.toList());
            return consumer.accept(parentParticipants, participant, this);
        });
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        InfuenceGraph.iterator(this.root, false, false, n -> {
            if (this.root != n) {
                buffer.append('\n');
            }
            for (int i = 0; i < n.getLevel(); ++i) {
                buffer.append("   ");
            }
            if (this.root != n) {
                buffer.append('L');
            }
            if (n.getLevel() > 0) {
                buffer.append("---");
            }
            buffer.append(n);
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfuenceGraph)) {
            return false;
        }
        if (this.size() != ((InfuenceGraph)o).size()) {
            return false;
        }
        int level = this.level();
        if (level != ((InfuenceGraph)o).level()) {
            return false;
        }
        ArrayList thisLevelNodes = new ArrayList(level);
        LinkedList currentNodes = new LinkedList();
        AtomicInteger currentLevel = new AtomicInteger(0);
        InfuenceGraph.iterator(this.root, false, true, node -> {
            if (node.getLevel() != currentLevel.get()) {
                thisLevelNodes.add(new ArrayList(currentNodes));
                currentNodes.clear();
                currentLevel.set(node.getLevel());
            }
            currentNodes.add(node);
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
        if (!currentNodes.isEmpty()) {
            thisLevelNodes.add(new ArrayList(currentNodes));
        }
        InfuenceGraph other = (InfuenceGraph)o;
        ArrayList otherLevelNodes = new ArrayList(level);
        currentLevel.set(0);
        currentNodes.clear();
        InfuenceGraph.iterator(other.root, false, true, node -> {
            if (node.getLevel() != currentLevel.get()) {
                otherLevelNodes.add(new ArrayList(currentNodes));
                currentNodes.clear();
                currentLevel.set(node.getLevel());
            }
            currentNodes.add(node);
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
        if (!currentNodes.isEmpty()) {
            otherLevelNodes.add(new ArrayList(currentNodes));
        }
        for (int i = 0; i < thisLevelNodes.size(); ++i) {
            List otherNodes;
            List thisNodes = (List)thisLevelNodes.get(i);
            if (this.equalsNodes(thisNodes, otherNodes = (List)otherLevelNodes.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void iterator(Node startNode, boolean inversion, boolean breadthFirst, NodeConsumer consumer) {
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.add(startNode);
        HashMap duplicateTable = null;
        if (breadthFirst) {
            duplicateTable = new HashMap();
        }
        block5: while (!stack.isEmpty()) {
            Node point = (Node)stack.poll();
            InfuenceGraphConsumer.Action action = consumer.consume(point);
            switch (action) {
                case CONTINUE: {
                    Collection<Node> nextNodes = inversion ? point.getParents() : point.getChildren();
                    if (breadthFirst) {
                        int currentLevel = point.getLevel();
                        boolean differenceOneLevel = true;
                        HashMap finalDuplicateTable = duplicateTable;
                        nextNodes.stream().filter(n -> n.getLevel() - currentLevel == 1).filter(n -> !finalDuplicateTable.containsKey(n)).forEach(n -> {
                            stack.offer((Node)n);
                            finalDuplicateTable.put(n, "");
                        });
                        continue block5;
                    }
                    nextNodes.forEach(n -> stack.push((Node)n));
                    continue block5;
                }
                case OVER: {
                    return;
                }
                case OVER_SELF: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Error action.");
        }
    }

    private void addQuickLink(Participant participant, Node node) {
        if (this.quickLink == null) {
            this.quickLink = new HashMap<Participant, Node>();
        }
        this.quickLink.put(participant, node);
    }

    private Optional<Node> findQuickLink(Participant participant) {
        if (this.quickLink == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.quickLink.get(participant));
    }

    private boolean equalsNodes(List<Node> thisNodes, List<Node> otherNodes) {
        if (thisNodes.size() != otherNodes.size()) {
            return false;
        }
        Collections.sort(thisNodes, Comparator.comparing(n -> n.getParticipant().getId()));
        Collections.sort(otherNodes, Comparator.comparing(n -> n.getParticipant().getId()));
        return thisNodes.equals(otherNodes);
    }

    private static class Node {
        private Collection<Node> parents;
        private Collection<Node> children;
        private Participant participant;
        private int level = 0;

        public Node(Participant participant) {
            this.participant = participant;
        }

        public void addParent(Node parent) {
            if (this.parents == null) {
                this.parents = new LinkedList<Node>();
            }
            if (!this.parents.contains(parent)) {
                this.parents.add(parent);
                if (parent.getLevel() >= this.level) {
                    this.level = parent.getLevel() + 1;
                    this.updateChildLevel();
                }
            }
        }

        public void addChild(Node child) {
            if (this.children == null) {
                this.children = new LinkedList<Node>();
            }
            if (!this.children.contains(child)) {
                this.children.add(child);
            }
        }

        public int getLevel() {
            return this.level;
        }

        public Collection<Node> getParents() {
            if (this.parents == null) {
                return Collections.emptyList();
            }
            return this.parents;
        }

        public Collection<Node> getChildren() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return this.children;
        }

        public Participant getParticipant() {
            return this.participant;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node otherNode = (Node)o;
            return Objects.equals(this.getLevel(), otherNode.getLevel()) && Objects.equals(this.getParticipant(), otherNode.getParticipant());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Participant participant = this.getParticipant();
            sb.append("(").append(participant.getEntityClass().code()).append(",").append(participant.getField().name()).append(",").append(this.level).append(")");
            return sb.toString();
        }

        private void updateChildLevel() {
            InfuenceGraph.iterator(this, false, false, node -> {
                if (node == this) {
                    return InfuenceGraphConsumer.Action.CONTINUE;
                }
                int parentMaxLevel = node.getParents().stream().max(Node::compareLevel).get().getLevel();
                if (node.getLevel() <= parentMaxLevel) {
                    node.level = parentMaxLevel + 1;
                    return InfuenceGraphConsumer.Action.CONTINUE;
                }
                return InfuenceGraphConsumer.Action.OVER_SELF;
            });
        }

        public static int compareLevel(Node n0, Node n1) {
            if (n0.getLevel() < n1.getLevel()) {
                return -1;
            }
            if (n0.getLevel() > n1.getLevel()) {
                return 1;
            }
            return 0;
        }
    }

    @FunctionalInterface
    private static interface NodeConsumer {
        public InfuenceGraphConsumer.Action consume(Node var1);
    }
}

