/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.context;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.factory.CalculationLogicFactory;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.event.EventBus;
import com.xforceplus.ultraman.oqsengine.idgenerator.client.BizIDGenerator;
import com.xforceplus.ultraman.oqsengine.lock.ResourceLocker;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.Hint;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.storage.ConditionsSelectStorage;
import com.xforceplus.ultraman.oqsengine.storage.KeyValueStorage;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.transaction.Transaction;
import com.xforceplus.ultraman.oqsengine.task.TaskCoordinator;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface CalculationContext {
    public IEntity getSourceEntity();

    public IEntity getFocusEntity();

    public IEntityClass getFocusClass();

    public IEntityField getFocusField();

    public InfuenceGraph getInfuenceGraph();

    public boolean isMaintenance();

    public void startMaintenance(IEntity var1);

    public void stopMaintenance();

    public void clearScope();

    public Optional<IEntity> getMaintenanceTriggerEntity();

    public void focusSourceEntity(IEntity var1);

    public void focusEntity(IEntity var1, IEntityClass var2);

    public void focusField(IEntityField var1);

    public void focusTx(Transaction var1);

    public void addInfuenceGraph(InfuenceGraph var1);

    public void addValueChange(ValueChange var1);

    public Optional<ValueChange> getValueChange(IEntity var1, IEntityField var2);

    public Collection<ValueChange> getValueChanges();

    public void removeValueChange(IEntity var1, IEntityField var2);

    public void putEntityToCache(IEntity var1);

    public Optional<IEntity> getEntityToCache(long var1);

    public void removeEntityFromCache(long var1);

    public Collection<IEntity> getEntitiesFormCache();

    public CalculationScenarios getScenariso();

    public Optional<Transaction> getCurrentTransaction();

    public Optional<MasterStorage> getMasterStorage();

    public Optional<MetaManager> getMetaManager();

    public Optional<KeyValueStorage> getKvStorage();

    public Optional<EventBus> getEvnetBus();

    public Optional<TaskCoordinator> getTaskCoordinator();

    public Optional<CalculationLogicFactory> getCalculationLogicFactory();

    public Optional<ConditionsSelectStorage> getConditionsSelectStorage();

    public Optional<BizIDGenerator> getBizIDGenerator();

    public Optional<ExecutorService> getTaskExecutorService();

    public Optional<ResourceLocker> getResourceLocker();

    public CalculationContext copy();

    default public <T> T getResourceWithEx(Supplier<Optional<T>> supplier) throws CalculationException {
        Optional<T> op = supplier.get();
        if (!op.isPresent()) {
            throw new CalculationException("Unable to get the specified resource.");
        }
        return op.get();
    }

    public void hint(IEntityField var1, String var2);

    public void hint(Hint var1);

    public Collection<Hint> getHints();

    default public boolean hasHint() {
        return !this.getHints().isEmpty();
    }

    public boolean persist();

    public boolean tryLocksEntity(long ... var1);

    public long getLockTimeoutMs();

    public void destroy();
}

