/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.context;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.factory.CalculationLogicFactory;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.event.EventBus;
import com.xforceplus.ultraman.oqsengine.idgenerator.client.BizIDGenerator;
import com.xforceplus.ultraman.oqsengine.lock.ResourceLocker;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.Hint;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntitys;
import com.xforceplus.ultraman.oqsengine.storage.ConditionsSelectStorage;
import com.xforceplus.ultraman.oqsengine.storage.KeyValueStorage;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.EntityPackage;
import com.xforceplus.ultraman.oqsengine.storage.transaction.Transaction;
import com.xforceplus.ultraman.oqsengine.task.TaskCoordinator;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class DefaultCalculationContext
implements CalculationContext {
    private IEntity sourceEntity;
    private IEntity focusEntity;
    private IEntity maintenanceEntity;
    private IEntityClass focusEntityClass;
    private IEntityField focusField;
    private CalculationScenarios scenarios;
    private Transaction transaction;
    private MetaManager metaManager;
    private MasterStorage masterStorage;
    private EventBus eventBus;
    private BizIDGenerator bizIDGenerator;
    private KeyValueStorage keyValueStorage;
    private TaskCoordinator taskCoordinator;
    private ExecutorService taskExecutorService;
    private Collection<Hint> hints;
    private ResourceLocker resourceLocker;
    private CalculationLogicFactory calculationLogicFactory;
    private ConditionsSelectStorage conditionsSelectStorage;
    private Map<Long, IEntity> entityCache;
    private Map<String, ValueChange> valueChanges;
    private InfuenceGraph infuenceGraph;
    private Set<Long> lockedEnittyIds;
    private boolean maintenance;
    private long lockTimeoutMs;

    @Override
    public CalculationScenarios getScenariso() {
        return this.scenarios;
    }

    @Override
    public Optional<Transaction> getCurrentTransaction() {
        return Optional.ofNullable(this.transaction);
    }

    @Override
    public Optional<MasterStorage> getMasterStorage() {
        return Optional.ofNullable(this.masterStorage);
    }

    @Override
    public Optional<MetaManager> getMetaManager() {
        return Optional.ofNullable(this.metaManager);
    }

    @Override
    public Optional<KeyValueStorage> getKvStorage() {
        return Optional.ofNullable(this.keyValueStorage);
    }

    @Override
    public Optional<EventBus> getEvnetBus() {
        return Optional.ofNullable(this.eventBus);
    }

    @Override
    public Optional<TaskCoordinator> getTaskCoordinator() {
        return Optional.ofNullable(this.taskCoordinator);
    }

    @Override
    public IEntity getSourceEntity() {
        return this.sourceEntity;
    }

    @Override
    public IEntity getFocusEntity() {
        return this.focusEntity;
    }

    @Override
    public IEntityClass getFocusClass() {
        return this.focusEntityClass;
    }

    @Override
    public IEntityField getFocusField() {
        return this.focusField;
    }

    @Override
    public InfuenceGraph getInfuenceGraph() {
        return this.infuenceGraph;
    }

    @Override
    public void addInfuenceGraph(InfuenceGraph infuenceGraph) {
        this.infuenceGraph = infuenceGraph;
    }

    @Override
    public boolean isMaintenance() {
        return this.maintenance;
    }

    @Override
    public void startMaintenance(IEntity triggerEntity) {
        this.maintenance = true;
        this.maintenanceEntity = triggerEntity;
    }

    @Override
    public void stopMaintenance() {
        this.maintenance = false;
        this.maintenanceEntity = null;
    }

    @Override
    public void clearScope() {
        HashSet<String> strings = new HashSet<String>(this.valueChanges.keySet());
        for (String key : strings) {
            if (!key.contains(CalculationType.FORMULA.name())) continue;
            this.valueChanges.remove(key);
        }
    }

    @Override
    public Optional<IEntity> getMaintenanceTriggerEntity() {
        return Optional.ofNullable(this.maintenanceEntity);
    }

    @Override
    public void focusSourceEntity(IEntity entity) {
        this.sourceEntity = entity;
    }

    @Override
    public void focusEntity(IEntity entity, IEntityClass entityClass) {
        this.focusEntity = entity;
        this.focusEntityClass = entityClass;
        this.putEntityToCache(entity);
    }

    @Override
    public void focusField(IEntityField field) {
        this.focusField = field;
    }

    @Override
    public void focusTx(Transaction tx) {
        this.transaction = tx;
    }

    @Override
    public void addValueChange(ValueChange valueChange) {
        String key;
        ValueChange oldVc;
        if (this.valueChanges == null) {
            this.valueChanges = new HashMap<String, ValueChange>();
        }
        if ((oldVc = this.valueChanges.get(key = this.buildValueChangeKey(valueChange.getField().calculationType().name(), valueChange.getEntityId(), valueChange.getField().id()))) == null) {
            this.valueChanges.put(key, valueChange);
        } else if (valueChange.getField().calculationType().equals((Object)CalculationType.FORMULA)) {
            ValueChange newVc = oldVc.copyFromNewValue(valueChange.getNewValue().get());
            this.valueChanges.put(key, newVc);
        } else {
            this.valueChanges.put(key, valueChange);
        }
    }

    @Override
    public Optional<ValueChange> getValueChange(IEntity entity, IEntityField field) {
        if (this.valueChanges == null) {
            return Optional.empty();
        }
        String key = this.buildValueChangeKey(field.calculationType().name(), entity.id(), field.id());
        return Optional.ofNullable(this.valueChanges.get(key));
    }

    @Override
    public Collection<ValueChange> getValueChanges() {
        if (this.valueChanges == null) {
            return Collections.emptyList();
        }
        return this.valueChanges.values();
    }

    @Override
    public void removeValueChange(IEntity entity, IEntityField field) {
        if (this.valueChanges != null) {
            String key = this.buildValueChangeKey(field.calculationType().name(), entity.id(), field.id());
            this.valueChanges.remove(key);
        }
    }

    @Override
    public void putEntityToCache(IEntity entity) {
        if (this.entityCache == null) {
            this.entityCache = new HashMap<Long, IEntity>();
        }
        this.entityCache.put(entity.id(), entity);
    }

    @Override
    public Optional<IEntity> getEntityToCache(long entityId) {
        if (this.entityCache == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.entityCache.get(entityId));
    }

    @Override
    public void removeEntityFromCache(long entityId) {
        if (this.entityCache != null) {
            this.entityCache.remove(entityId);
        }
    }

    @Override
    public Collection<IEntity> getEntitiesFormCache() {
        if (this.entityCache == null) {
            return Collections.emptyList();
        }
        return this.entityCache.values();
    }

    @Override
    public Optional<CalculationLogicFactory> getCalculationLogicFactory() {
        return Optional.ofNullable(this.calculationLogicFactory);
    }

    @Override
    public Optional<ConditionsSelectStorage> getConditionsSelectStorage() {
        return Optional.ofNullable(this.conditionsSelectStorage);
    }

    @Override
    public Optional<BizIDGenerator> getBizIDGenerator() {
        return Optional.ofNullable(this.bizIDGenerator);
    }

    @Override
    public Optional<ExecutorService> getTaskExecutorService() {
        return Optional.ofNullable(this.taskExecutorService);
    }

    @Override
    public Optional<ResourceLocker> getResourceLocker() {
        return Optional.ofNullable(this.resourceLocker);
    }

    @Override
    public void hint(IEntityField field, String hint) {
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        this.hints.add(new Hint((Object)field, hint));
    }

    @Override
    public void hint(Hint hint) {
        if (this.hints == null) {
            this.hints = new LinkedList<Hint>();
        }
        this.hints.add(hint);
    }

    @Override
    public Collection<Hint> getHints() {
        if (this.hints == null) {
            return Collections.emptyList();
        }
        return this.hints;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean persist() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean tryLocksEntity(long ... entityIds) {
        String[] keys;
        if (this.lockedEnittyIds == null) {
            this.lockedEnittyIds = new HashSet<Long>();
        }
        if ((keys = (String[])Arrays.stream(entityIds).filter(id -> !this.lockedEnittyIds.contains(id)).mapToObj(id -> IEntitys.resource((long)id)).toArray(String[]::new)).length > 0) {
            boolean result = false;
            try {
                result = this.resourceLocker.tryLocks(this.lockTimeoutMs, keys);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (result) {
                for (long id2 : entityIds) {
                    this.lockedEnittyIds.add(id2);
                }
            }
            return result;
        }
        return true;
    }

    @Override
    public long getLockTimeoutMs() {
        return this.lockTimeoutMs;
    }

    public Set<Long> getLockedEnittyIds() {
        return new HashSet<Long>(this.lockedEnittyIds);
    }

    @Override
    public void destroy() {
        if (this.lockedEnittyIds != null && !this.lockedEnittyIds.isEmpty()) {
            String[] keys = (String[])this.lockedEnittyIds.stream().map(id -> IEntitys.resource((long)id)).toArray(String[]::new);
            this.resourceLocker.unlocks(keys);
        }
    }

    private IEntity[] doPersist(EntityPackage entityPackage) throws SQLException {
        MasterStorage masterStorage = (MasterStorage)this.getResourceWithEx(() -> this.getMasterStorage());
        masterStorage.replace(entityPackage);
        return (IEntity[])entityPackage.stream().filter(e -> ((IEntity)e.getKey()).isDirty()).map(e -> (IEntity)e.getKey()).toArray(IEntity[]::new);
    }

    @Override
    public CalculationContext copy() {
        DefaultCalculationContext newContext = new DefaultCalculationContext();
        if (this.valueChanges != null) {
            newContext.valueChanges = new HashMap<String, ValueChange>(this.valueChanges);
        }
        if (this.entityCache != null) {
            newContext.entityCache = new HashMap<Long, IEntity>(this.entityCache);
        }
        newContext.maintenance = this.maintenance;
        newContext.sourceEntity = this.sourceEntity;
        newContext.focusEntity = this.focusEntity;
        newContext.focusField = this.focusField;
        newContext.focusEntityClass = this.focusEntityClass;
        newContext.eventBus = this.eventBus;
        newContext.transaction = this.transaction;
        newContext.scenarios = this.scenarios;
        newContext.metaManager = this.metaManager;
        newContext.masterStorage = this.masterStorage;
        newContext.bizIDGenerator = this.bizIDGenerator;
        newContext.keyValueStorage = this.keyValueStorage;
        newContext.taskCoordinator = this.taskCoordinator;
        newContext.taskExecutorService = this.taskExecutorService;
        newContext.resourceLocker = this.resourceLocker;
        newContext.conditionsSelectStorage = this.conditionsSelectStorage;
        return newContext;
    }

    private String buildValueChangeKey(String calculationType, long entityId, long fieldId) {
        return String.join((CharSequence)"-", calculationType, Long.toString(entityId), Long.toString(fieldId));
    }

    private /* synthetic */ Optional lambda$persist$1() {
        return this.getMetaManager();
    }

    private static /* synthetic */ boolean lambda$persist$0(IEntity e) {
        return e.isDirty();
    }

    public static final class Builder {
        private long lockTimeoutMs = 30000L;
        private EventBus eventBus;
        private Transaction transaction;
        private CalculationScenarios scenarios;
        private MetaManager metaManager;
        private MasterStorage masterStorage;
        private BizIDGenerator bizIDGenerator;
        private KeyValueStorage keyValueStorage;
        private TaskCoordinator taskCoordinator;
        private ExecutorService taskExecutorService;
        private ResourceLocker resourceLocker;
        private ConditionsSelectStorage conditionsSelectStorage;
        private CalculationLogicFactory calculationLogicFactory;

        private Builder() {
        }

        public static Builder anCalculationContext() {
            return new Builder();
        }

        public Builder withScenarios(CalculationScenarios scenarios) {
            this.scenarios = scenarios;
            return this;
        }

        public Builder withMetaManager(MetaManager metaManager) {
            this.metaManager = metaManager;
            return this;
        }

        public Builder withMasterStorage(MasterStorage masterStorage) {
            this.masterStorage = masterStorage;
            return this;
        }

        public Builder withKeyValueStorage(KeyValueStorage keyValueStorage) {
            this.keyValueStorage = keyValueStorage;
            return this;
        }

        public Builder withTaskCoordinator(TaskCoordinator taskCoordinator) {
            this.taskCoordinator = taskCoordinator;
            return this;
        }

        public Builder withBizIDGenerator(BizIDGenerator bizIDGenerator) {
            this.bizIDGenerator = bizIDGenerator;
            return this;
        }

        public Builder withTransaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public Builder withConditionsSelectStorage(ConditionsSelectStorage conditionsSelectStorage) {
            this.conditionsSelectStorage = conditionsSelectStorage;
            return this;
        }

        public Builder withCalculationLogicFactory(CalculationLogicFactory calculationLogicFactory) {
            this.calculationLogicFactory = calculationLogicFactory;
            return this;
        }

        public Builder withEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder withTaskExecutorService(ExecutorService taskExecutorService) {
            this.taskExecutorService = taskExecutorService;
            return this;
        }

        public Builder withResourceLocker(ResourceLocker resourceLocker) {
            this.resourceLocker = resourceLocker;
            return this;
        }

        public Builder withLockTimeroutMs(long lockTimeoutMs) {
            this.lockTimeoutMs = lockTimeoutMs;
            return this;
        }

        public DefaultCalculationContext build() {
            DefaultCalculationContext defaultCalculationContext = new DefaultCalculationContext();
            defaultCalculationContext.eventBus = this.eventBus;
            defaultCalculationContext.taskCoordinator = this.taskCoordinator;
            defaultCalculationContext.taskExecutorService = this.taskExecutorService;
            defaultCalculationContext.masterStorage = this.masterStorage;
            defaultCalculationContext.metaManager = this.metaManager;
            defaultCalculationContext.keyValueStorage = this.keyValueStorage;
            defaultCalculationContext.scenarios = this.scenarios;
            defaultCalculationContext.bizIDGenerator = this.bizIDGenerator;
            defaultCalculationContext.transaction = this.transaction;
            defaultCalculationContext.conditionsSelectStorage = this.conditionsSelectStorage;
            defaultCalculationContext.resourceLocker = this.resourceLocker;
            defaultCalculationContext.calculationLogicFactory = this.calculationLogicFactory;
            defaultCalculationContext.lockTimeoutMs = this.lockTimeoutMs;
            return defaultCalculationContext;
        }
    }
}

