/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.dto;

import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;

public class ExpressionWrapper {
    private String code;
    private String expression;
    private boolean cached = true;

    private ExpressionWrapper() {
    }

    public String getCode() {
        return this.code;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isCached() {
        return this.cached;
    }

    public static final class Builder {
        private String expression;
        private Boolean cached;

        private Builder() {
        }

        public static Builder anExpression() {
            return new Builder();
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder withCached(Boolean cached) {
            this.cached = cached;
            return this;
        }

        public ExpressionWrapper build() throws CalculationException {
            if (null == this.expression || this.expression.isEmpty()) {
                throw new CalculationException("expression can't be null in build function.");
            }
            ExpressionWrapper expressionWrapper = new ExpressionWrapper();
            expressionWrapper.expression = this.expression;
            expressionWrapper.cached = null == this.cached || this.cached != false;
            expressionWrapper.code = this.expression;
            return expressionWrapper;
        }
    }
}

