/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.event;

import com.xforceplus.ultraman.oqsengine.calculation.dto.CalculationEvent;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.CalculationEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.factory.CachedEntityClass;
import com.xforceplus.ultraman.oqsengine.calculation.factory.CalculationEventFactory;
import com.xforceplus.ultraman.oqsengine.event.ActualEvent;
import com.xforceplus.ultraman.oqsengine.event.EventBus;
import com.xforceplus.ultraman.oqsengine.event.EventType;
import com.xforceplus.ultraman.oqsengine.event.payload.meta.MetaChangePayLoad;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateEventDispatcher {
    private Logger log = LoggerFactory.getLogger(CalculateEventDispatcher.class);
    @Resource
    private EventBus eventBus;
    @Resource
    private CalculationEventFactory factory;

    @PostConstruct
    public void init() {
        this.eventBus.watch(EventType.META_DATA_CHANGE, event -> this.dispatcher((ActualEvent<MetaChangePayLoad>)((ActualEvent)event)));
        this.log.info("init calculateEventDispatcher success.");
    }

    private void dispatcher(ActualEvent<MetaChangePayLoad> event) throws CalculationException {
        Optional op = event.payload();
        CachedEntityClass cachedEntityClass = new CachedEntityClass();
        if (op.isPresent()) {
            this.log.debug("dispatcher metaChangePayLoad event, appId : {}, version : {}.", (Object)((MetaChangePayLoad)op.get()).getAppId(), (Object)((MetaChangePayLoad)op.get()).getVersion());
            try {
                this.fieldEventDispatcher((MetaChangePayLoad)op.get(), cachedEntityClass);
                this.relationEventDispatcher((MetaChangePayLoad)op.get(), cachedEntityClass);
            }
            catch (Exception e) {
                throw new CalculationException(e.getMessage());
            }
        } else {
            this.log.warn("dispatcher metaChangePayLoad ignored because metaChangePayLoad is not exists.");
        }
    }

    private void relationEventDispatcher(MetaChangePayLoad appMetaChangePayLoad, CachedEntityClass cachedEntityClass) {
    }

    private void fieldEventDispatcher(MetaChangePayLoad metaChangePayLoad, CachedEntityClass cachedEntityClass) throws SQLException {
        HashMap events = new HashMap();
        HashMap<Long, List<Long>> deletes = new HashMap<Long, List<Long>>();
        metaChangePayLoad.getEntityChanges().forEach(entityChange -> entityChange.getFieldChanges().forEach(fieldChange -> {
            switch (fieldChange.getOp()) {
                case CREATE: 
                case UPDATE: {
                    IEntityClass entityClass = cachedEntityClass.findEntityClassWithCache(this.factory.resource().getMetaManager(), entityChange.getEntityClassId(), fieldChange.getProfile(), metaChangePayLoad.getVersion());
                    if (null == entityClass) break;
                    entityClass.field(fieldChange.getFieldId().longValue()).ifPresent(entityField -> this.addCalculationField(events, metaChangePayLoad, (MetaChangePayLoad.EntityChange)entityChange, (MetaChangePayLoad.FieldChange)fieldChange, (IEntityField)entityField));
                    break;
                }
                case DELETE: {
                    deletes.computeIfAbsent(entityChange.getEntityClassId(), k -> new ArrayList()).add(fieldChange.getFieldId());
                    break;
                }
            }
        }));
        for (Map.Entry entry : events.entrySet()) {
            CalculationEventExecutor executor = this.factory.executor((CalculationType)entry.getKey());
            if (null != executor) {
                executor.execute((CalculationEvent)entry.getValue(), cachedEntityClass, this.factory.resource());
                continue;
            }
            this.log.warn("un-support calculate type {}, appId {}", entry.getKey(), (Object)metaChangePayLoad.getAppId());
        }
        if (!deletes.isEmpty()) {
            this.factory.executor(CalculationType.STATIC).deleteTypeExecute(deletes, this.factory.resource());
        }
    }

    private void addCalculationField(Map<CalculationType, CalculationEvent> events, MetaChangePayLoad metaChangePayLoad, MetaChangePayLoad.EntityChange entityChange, MetaChangePayLoad.FieldChange fieldChange, IEntityField entityField) {
        events.computeIfAbsent(entityField.calculationType(), k -> new CalculationEvent(metaChangePayLoad.getAppId(), metaChangePayLoad.getVersion())).getCalculationFields().computeIfAbsent(entityChange.getEntityClassId(), f -> new ArrayList()).add(new CalculationEvent.CalculationField(fieldChange.getOp(), fieldChange.getProfile(), entityField));
    }
}

