/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.factory;

import com.xforceplus.ultraman.oqsengine.calculation.event.executor.AggregationEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.AutoFillEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.CalculationEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.DoNothingEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.FormulaEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.LookupEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.executor.StaticEventExecutor;
import com.xforceplus.ultraman.oqsengine.calculation.event.helper.CalculationEventResource;
import com.xforceplus.ultraman.oqsengine.common.serializable.SerializeStrategy;
import com.xforceplus.ultraman.oqsengine.idgenerator.storage.SegmentStorage;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.storage.KeyValueStorage;
import java.util.HashMap;
import java.util.Map;

public class CalculationEventFactory {
    private Map<CalculationType, CalculationEventExecutor> executors;
    private CalculationEventResource resource;

    public CalculationEventFactory(SegmentStorage storage, MetaManager metaManager, KeyValueStorage keyValueStorage, SerializeStrategy serializeStrategy) {
        this.resource = CalculationEventResource.Builder.anCalculationEventContext().withMeta(metaManager).withSegmentStorage(storage).withKeyValueStorage(keyValueStorage).withSerializeStrategy(serializeStrategy).build();
        this.executors = new HashMap<CalculationType, CalculationEventExecutor>();
        this.executors.put(CalculationType.AUTO_FILL, new AutoFillEventExecutor());
        this.executors.put(CalculationType.UNKNOWN, new DoNothingEventExecutor());
        this.executors.put(CalculationType.FORMULA, new FormulaEventExecutor());
        this.executors.put(CalculationType.LOOKUP, new LookupEventExecutor());
        this.executors.put(CalculationType.STATIC, new StaticEventExecutor());
        this.executors.put(CalculationType.AGGREGATION, new AggregationEventExecutor());
    }

    public CalculationEventExecutor executor(CalculationType calculationType) {
        CalculationEventExecutor executor = this.executors.get(calculationType);
        return null != executor ? executor : this.executors.get(CalculationType.UNKNOWN);
    }

    public CalculationEventResource resource() {
        return this.resource;
    }
}

