/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.factory;

import com.xforceplus.ultraman.oqsengine.calculation.logic.CalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.UnknownCalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.AggregationCalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.autofill.AutoFillCalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.formula.FormulaCalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.LookupCalculationLogic;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CalculationLogicFactory {
    private Map<CalculationType, CalculationLogic> calculationLogics = new HashMap<CalculationType, CalculationLogic>();

    public static CalculationLogicFactory getInstance() {
        return CalculationLogicFactoryHolder.CALCULATION_LOGIC_FACTORY;
    }

    public CalculationLogicFactory() {
        CalculationLogic logic = new LookupCalculationLogic();
        this.calculationLogics.put(logic.supportType(), logic);
        logic = new FormulaCalculationLogic();
        this.calculationLogics.put(logic.supportType(), logic);
        logic = new AutoFillCalculationLogic();
        this.calculationLogics.put(logic.supportType(), logic);
        logic = new AggregationCalculationLogic();
        this.calculationLogics.put(logic.supportType(), logic);
    }

    public CalculationLogic getCalculationLogic(CalculationType type) {
        CalculationLogic calculationLogic = this.calculationLogics.get(type);
        if (calculationLogic == null) {
            return UnknownCalculationLogic.getInstance();
        }
        return calculationLogic;
    }

    public Collection<CalculationLogic> getCalculationLogics() {
        return this.calculationLogics.values();
    }

    public void register(CalculationLogic logic) {
        this.calculationLogics.put(logic.supportType(), logic);
    }

    private static final class CalculationLogicFactoryHolder {
        static final CalculationLogicFactory CALCULATION_LOGIC_FACTORY = new CalculationLogicFactory();

        private CalculationLogicFactoryHolder() {
        }
    }
}

