/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.function;

import com.alibaba.google.common.base.Preconditions;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.xforceplus.ultraman.oqsengine.calculation.function.constant.TimeUnit;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOffsetFunction
extends AbstractFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeOffsetFunction.class);

    public String getName() {
        return "timeOffset";
    }

    public AviatorObject call(Map<String, Object> env, AviatorObject date, AviatorObject no, AviatorObject amount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("INPUT DATA is {}", (Object)date.getValue(env).toString());
        }
        Preconditions.checkNotNull(env);
        Preconditions.checkNotNull((Object)amount);
        Preconditions.checkArgument((boolean)(date.getValue(env) instanceof LocalDateTime), (Object)"must be LocalDateTime instance!");
        LocalDateTime dateTime = (LocalDateTime)date.getValue(env);
        int offset = Integer.valueOf(String.valueOf(amount.getValue(env)));
        int unit = Integer.valueOf(String.valueOf(no.getValue(env)));
        LocalDateTime result = null;
        switch (TimeUnit.from(unit)) {
            case YEAR: {
                result = dateTime.plus(offset, ChronoUnit.YEARS);
                break;
            }
            case QUARTER: {
                result = dateTime.plus(offset * 3, ChronoUnit.MONTHS);
                break;
            }
            case MONTH: {
                result = dateTime.plus(offset, ChronoUnit.MONTHS);
                break;
            }
            case DAY: {
                result = dateTime.plus(offset, ChronoUnit.DAYS);
                break;
            }
            case HOUR: {
                result = dateTime.plus(offset, ChronoUnit.HOURS);
                break;
            }
            case MINUTE: {
                result = dateTime.plus(offset, ChronoUnit.MINUTES);
                break;
            }
            case SECOND: {
                result = dateTime.plus(offset, ChronoUnit.SECONDS);
                break;
            }
            case MILLI: {
                result = dateTime.plus(offset, ChronoUnit.MILLIS);
                break;
            }
            case WEEK: {
                result = dateTime.plus(offset, ChronoUnit.WEEKS);
                break;
            }
            default: {
                result = dateTime;
            }
        }
        ZoneId zoneId = ZoneId.systemDefault();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ZoneID is {}", (Object)zoneId);
        }
        Date newDate = Date.from(result.atZone(zoneId).toInstant());
        return FunctionUtils.wrapReturn((Object)newDate);
    }
}

