/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.impl;

import com.xforceplus.ultraman.oqsengine.calculation.dto.agg.CollectAttachment;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper.AggregationAttachmentHelper;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.util.List;
import java.util.Optional;

public class CollectFunction
implements AggregationFunction {
    private static int MAX_CAPACITY = 2000;

    @Override
    public Optional<IValue> excute(Optional<IValue> agg, ValueChange valueChange) {
        if (!agg.isPresent() || !agg.get().getField().type().equals((Object)FieldType.STRINGS)) {
            return Optional.empty();
        }
        Optional<IValue> o = valueChange.getOldValue();
        Optional<IValue> n = valueChange.getNewValue();
        IValue aggCopy = agg.get().copy();
        if (!o.isPresent() || !n.isPresent() || o.get() instanceof EmptyTypedValue && n.get() instanceof EmptyTypedValue) {
            return Optional.of(aggCopy);
        }
        if (o.get().valueToString().equals(n.get().valueToString())) {
            return Optional.of(aggCopy);
        }
        Optional<CollectAttachment> collectAttachmentOp = AggregationAttachmentHelper.buildCollectAttachment((String[])aggCopy.getValue(), aggCopy.getAttachment().orElse(""));
        if (!collectAttachmentOp.isPresent()) {
            return Optional.empty();
        }
        CollectAttachment collectAttachment = collectAttachmentOp.get();
        if (o.get() instanceof EmptyTypedValue) {
            collectAttachment.compareAndOperation(n.get().valueToString(), true, MAX_CAPACITY);
        } else if (n.get() instanceof EmptyTypedValue) {
            collectAttachment.compareAndOperation(o.get().valueToString(), false, MAX_CAPACITY);
        } else {
            collectAttachment.compareAndOperation(o.get().valueToString(), false, MAX_CAPACITY);
            collectAttachment.compareAndOperation(n.get().valueToString(), true, MAX_CAPACITY);
        }
        return Optional.ofNullable(collectAttachment.toIValue(aggCopy.getField()));
    }

    @Override
    public Optional<IValue> init(Optional<IValue> agg, List<Optional<IValue>> values) {
        if (!agg.isPresent() || !agg.get().getField().type().equals((Object)FieldType.STRINGS)) {
            return Optional.empty();
        }
        StringsValue aggValue = new StringsValue(agg.get().copy().getField(), new String[0], "");
        Optional<CollectAttachment> collectAttachmentOp = AggregationAttachmentHelper.buildCollectAttachment((String[])aggValue.getValue(), aggValue.getAttachment().orElse(""));
        CollectAttachment collectAttachment = collectAttachmentOp.get();
        values.forEach(op -> op.ifPresent(value -> collectAttachment.compareAndOperation(value.valueToString(), true, MAX_CAPACITY)));
        return this.initAttachment(Optional.ofNullable(collectAttachment.toIValue(aggValue.getField())));
    }

    private Optional<IValue> initAttachment(Optional<IValue> aggValue) {
        if (aggValue.isPresent()) {
            FieldType fieldType = aggValue.get().getField().type();
            switch (fieldType) {
                case LONG: {
                    return Optional.of(aggValue.get().copy("0|0"));
                }
                case DECIMAL: {
                    return Optional.of(aggValue.get().copy("0|0.0"));
                }
                case STRINGS: {
                    return Optional.of(aggValue.get().copy(""));
                }
            }
            return Optional.of(aggValue.get().copy("0|0"));
        }
        return Optional.empty();
    }
}

