/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.impl;

import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper.AggregationAttachmentHelper;
import com.xforceplus.ultraman.oqsengine.calculation.utils.BigDecimalSummaryStatistics;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.stream.Collectors;

public class MaxFunction
implements AggregationFunction {
    @Override
    public Optional<IValue> excute(Optional<IValue> agg, ValueChange valueChange) {
        IValue newValue;
        int result;
        Optional<IValue> o = valueChange.getOldValue();
        Optional<IValue> n = valueChange.getNewValue();
        if (!(agg.isPresent() & o.isPresent()) || !n.isPresent()) {
            return Optional.empty();
        }
        IValue aggCopyValue = agg.get().copy();
        if (!n.isPresent() || n.get() instanceof EmptyTypedValue) {
            return Optional.of(aggCopyValue);
        }
        boolean zeroCount = false;
        boolean invalid = !agg.isPresent() ? true : agg.isPresent() && AggregationAttachmentHelper.count(agg.get()) <= 0L;
        if (invalid) {
            aggCopyValue = IValueUtils.min((IEntityField)aggCopyValue.getField()).copy((String)aggCopyValue.getAttachment().orElse(null));
        }
        if ((result = (newValue = n.get()).compareTo(aggCopyValue)) > 0) {
            aggCopyValue = agg.get().copy(newValue.getValue());
        }
        return Optional.of(aggCopyValue);
    }

    @Override
    public Optional<IValue> init(Optional<IValue> agg, List<Optional<IValue>> values) {
        Optional<IValue> aggValue = Optional.of(agg.get().copy());
        if (agg.get() instanceof DecimalValue) {
            BigDecimalSummaryStatistics temp = values.stream().map(v -> (BigDecimal)((DecimalValue)v.get()).getValue()).collect(BigDecimalSummaryStatistics.statistics());
            aggValue.get().setStringValue(temp.getMax().toString());
        } else if (agg.get() instanceof LongValue) {
            LongSummaryStatistics temp = values.stream().map(o -> (IValue)o.get()).collect(Collectors.summarizingLong(IValue::valueToLong));
            aggValue.get().setStringValue(String.valueOf(temp.getMax()));
        } else if (agg.get() instanceof DateTimeValue) {
            LongSummaryStatistics temp = values.stream().map(v -> ((IValue)v.get()).valueToLong()).collect(Collectors.summarizingLong(Long::longValue));
            aggValue.get().setStringValue(String.valueOf(temp.getMax()));
        }
        return this.initAttachment(aggValue, values.size());
    }

    private Optional<IValue> initAttachment(Optional<IValue> aggValue, int count) {
        if (aggValue.isPresent()) {
            IValue value = aggValue.get();
            StringBuilder attachmentBuff = new StringBuilder();
            attachmentBuff.append(count).append('|').append(value.valueToString());
            return Optional.of(value.copy(attachmentBuff.toString()));
        }
        return Optional.empty();
    }
}

