/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunctionFactoryImpl;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper.AggregationAttachmentHelper;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.FunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.EntityRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.sort.Sort;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import com.xforceplus.ultraman.oqsengine.storage.ConditionsSelectStorage;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.select.SelectConfig;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinFunctionStrategy
implements FunctionStrategy {
    final Logger logger = LoggerFactory.getLogger(MinFunctionStrategy.class);

    @Override
    public Optional<IValue> excute(Optional<IValue> currentValue, ValueChange valueChange, CalculationContext context) {
        IValue oldValue = valueChange.getOldValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        IValue newValue = valueChange.getNewValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        if (oldValue instanceof EmptyTypedValue) {
            oldValue = IValueUtils.zero((IEntityField)oldValue.getField());
        }
        if (newValue instanceof EmptyTypedValue) {
            newValue = IValueUtils.zero((IEntityField)newValue.getField());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("begin excuteMin current:{}, o-value:{}, n-value:{}", new Object[]{currentValue.get().valueToString(), oldValue.valueToString(), newValue.valueToString()});
        }
        Optional<IValue> aggValue = Optional.of(currentValue.get().copy());
        Aggregation aggregation = (Aggregation)context.getFocusField().config().getCalculation();
        AggregationFunction function = AggregationFunctionFactoryImpl.getAggregationFunction(aggregation.getAggregationType());
        if (aggValue.get().valueToLong() == 0L || aggValue.get().valueToString().equals("0.0") || aggValue.get().getValue().equals(DateTimeValue.MIN_DATE_TIME)) {
            long count = AggregationAttachmentHelper.count(aggValue.get(), 0L);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("minExcute Count:{}, agg-value:{}, n-value:{}", new Object[]{count, aggValue.get().valueToString(), newValue.valueToString()});
            }
            if (context.getScenariso().equals((Object)CalculationScenarios.BUILD) && count == 0L) {
                aggValue.get().setStringValue(newValue.valueToString());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("first - return agg-value:{}, n-value:{}", (Object)aggValue.get().valueToString(), (Object)newValue.valueToString());
                }
                Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
                return attAggValue;
            }
        }
        if (aggValue.get().valueToString().equals(oldValue.valueToString())) {
            if (aggregation.getClassId() == context.getSourceEntity().entityClassRef().getId()) {
                if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u540e\u7eed\u6570\u636e\u8ba1\u7b97\uff0c\u805a\u5408\u548c\u8001\u6570\u636e\u76f8\u540c - return agg-value:{}, n-value:{}, o-value:{}", new Object[]{aggValue.get().valueToString(), newValue.valueToString(), oldValue.valueToString()});
                    }
                    Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
                    return function.excute(attAggValue, valueChange);
                }
                if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
                    Optional<IValue> minValue = null;
                    try {
                        minValue = this.minAggregationEntity(aggregation, context, CalculationScenarios.DELETE);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    if (minValue.isPresent()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("\u627e\u5230\u6700\u5c0f\u6570\u636e - minValue:{}", (Object)minValue.get().valueToString());
                        }
                        aggValue.get().setStringValue(minValue.get().valueToString());
                        Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
                        return attAggValue;
                    }
                    aggValue.get().setStringValue("0");
                    Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
                    return attAggValue;
                }
                if (this.checkMaxValue(oldValue, newValue)) {
                    aggValue.get().setStringValue(newValue.valueToString());
                    return aggValue;
                }
                Optional<IValue> minValue = null;
                try {
                    minValue = this.minAggregationEntity(aggregation, context, CalculationScenarios.REPLACE);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (minValue.isPresent()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u627e\u5230\u6700\u5c0f\u6570\u636e - minValue:{}", (Object)minValue.get().valueToString());
                    }
                    if (this.checkMaxValue(minValue.get(), newValue)) {
                        aggValue.get().setStringValue(newValue.valueToString());
                        return aggValue;
                    }
                    aggValue.get().setStringValue(minValue.get().valueToString());
                    return aggValue;
                }
                aggValue.get().setStringValue(newValue.valueToString());
                return aggValue;
            }
            if (this.checkMaxValue(oldValue, newValue)) {
                aggValue.get().setStringValue(newValue.valueToString());
                return aggValue;
            }
            Optional<IValue> minValue = null;
            try {
                minValue = this.minAggregationEntity(aggregation, context, CalculationScenarios.REPLACE);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (minValue.isPresent()) {
                if (this.checkMaxValue(minValue.get(), newValue)) {
                    aggValue.get().setStringValue(newValue.valueToString());
                    return aggValue;
                }
                aggValue.get().setStringValue(minValue.get().valueToString());
                return aggValue;
            }
            aggValue.get().setStringValue(newValue.valueToString());
            return aggValue;
        }
        if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
            Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
            return attAggValue;
        }
        if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
            Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
            return function.excute(attAggValue, valueChange);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u65e0\u7279\u6b8a\u60c5\u51b5\u6570\u636e\u8ba1\u7b97 - return agg-value:{}, n-value:{}, o-value:{}", new Object[]{aggValue.get().valueToString(), newValue.valueToString(), oldValue.valueToString()});
        }
        return function.excute(aggValue, valueChange);
    }

    private IValue attachmentReplace(IValue value, String count, String sum) {
        Optional attachmentOp = value.getAttachment();
        if (attachmentOp.isPresent()) {
            String attachment = (String)attachmentOp.get();
            String[] att = StringUtils.split((String)attachment, (String)"|");
            boolean minAttchemntSize = true;
            if (att.length > 1) {
                StringBuilder attachmentBuff = new StringBuilder();
                if (value instanceof DecimalValue) {
                    attachmentBuff.append(Long.parseLong(att[0]) + Long.parseLong(count)).append('|').append(new BigDecimal(att[1]).add(new BigDecimal(sum)));
                    return value.copy(attachmentBuff.toString());
                }
                if (value instanceof LongValue) {
                    attachmentBuff.append(Long.parseLong(att[0]) + Long.parseLong(count)).append('|').append(Long.parseLong(att[1]) + Long.parseLong(sum));
                    return value.copy(attachmentBuff.toString());
                }
                if (value instanceof DateTimeValue) {
                    attachmentBuff.append(Long.valueOf(att[0]) + Long.valueOf(count)).append('|').append(att[1]);
                    return value.copy(attachmentBuff.toString());
                }
            }
        }
        return value;
    }

    private Optional<IValue> minAggregationEntity(Aggregation aggregation, CalculationContext context, CalculationScenarios calculationScenarios) throws SQLException {
        MasterStorage masterStorage = (MasterStorage)context.getResourceWithEx(() -> context.getMasterStorage());
        Optional targetEntityClass = context.getMetaManager().get().load(aggregation.getClassId(), context.getFocusEntity().entityClassRef().getProfile());
        if (targetEntityClass.isPresent()) {
            IEntityClass entityClass = (IEntityClass)targetEntityClass.get();
            Conditions conditions = Conditions.buildEmtpyConditions();
            Optional entityField = ((IEntityClass)targetEntityClass.get()).field(aggregation.getRelationId());
            if (entityField.isPresent()) {
                conditions.addAnd(new Condition((IEntityField)entityField.get(), ConditionOperator.EQUALS, new IValue[]{new LongValue((IEntityField)entityField.get(), context.getFocusEntity().id())}));
            }
            ConditionsSelectStorage selectStorage = (ConditionsSelectStorage)context.getResourceWithEx(() -> context.getConditionsSelectStorage());
            Page emptyPage = Page.newSinglePage((long)2L);
            List entityRefs = (List)selectStorage.select(conditions, (IEntityClass)targetEntityClass.get(), SelectConfig.Builder.anSelectConfig().withPage(emptyPage).withSort(Sort.buildAscSort((IEntityField)((IEntityField)((IEntityClass)targetEntityClass.get()).field(aggregation.getFieldId()).get()))).build());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("minAggregationEntity:entityRefs:{}", (Object)entityRefs.size());
            }
            if (!entityRefs.isEmpty()) {
                Optional entity;
                if (entityRefs.size() < 2) {
                    if (entityRefs.size() == 1) {
                        if (calculationScenarios.equals((Object)CalculationScenarios.REPLACE)) {
                            return Optional.empty();
                        }
                        Optional entity2 = masterStorage.selectOne(((EntityRef)entityRefs.get(0)).getId(), entityClass);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("minAggregationEntity:entityRefs:{}", ((IEntity)entity2.get()).entityValue().values().stream().toArray());
                        }
                        if (entity2.isPresent()) {
                            return ((IEntity)entity2.get()).entityValue().getValue(aggregation.getFieldId());
                        }
                    }
                    return Optional.empty();
                }
                if (calculationScenarios.equals((Object)CalculationScenarios.DELETE) && (entity = masterStorage.selectOne(((EntityRef)entityRefs.get(0)).getId(), entityClass)).isPresent()) {
                    return ((IEntity)entity.get()).entityValue().getValue(aggregation.getFieldId());
                }
                entity = masterStorage.selectOne(((EntityRef)entityRefs.get(1)).getId(), entityClass);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("minAggregationEntity:entityRefs:{}", ((IEntity)entity.get()).entityValue().values().stream().toArray());
                }
                if (entity.isPresent()) {
                    return ((IEntity)entity.get()).entityValue().getValue(aggregation.getFieldId());
                }
            }
        }
        return Optional.empty();
    }

    private boolean checkMaxValue(IValue o, IValue n) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("checkMaxValue - o-value:{}, n-value:{}", (Object)o.valueToString(), (Object)n.valueToString());
        }
        if (o instanceof EmptyTypedValue) {
            return false;
        }
        if (n instanceof EmptyTypedValue) {
            return true;
        }
        if (o instanceof DecimalValue) {
            double temp = Math.max(((BigDecimal)((DecimalValue)o).getValue()).doubleValue(), ((BigDecimal)((DecimalValue)n).getValue()).doubleValue());
            return Double.compare(temp, ((BigDecimal)((DecimalValue)o).getValue()).doubleValue()) == 0;
        }
        if (o instanceof LongValue) {
            long temp = Math.max(o.valueToLong(), n.valueToLong());
            return temp == o.valueToLong();
        }
        if (o instanceof DateTimeValue) {
            long temp = Math.max(o.valueToLong(), n.valueToLong());
            return temp == o.valueToLong();
        }
        return false;
    }
}

