/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.formula.helper;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.dto.ExecutionWrapper;
import com.xforceplus.ultraman.oqsengine.calculation.dto.ExpressionWrapper;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.utils.aviator.AviatorHelper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaHelper.class);
    public static final String FORMULA_CTX_PARAM = "FORMULA_CTX_PARAM";
    public static final String FORMULA_THIS_VALUE = "this_value";

    private static ExecutionWrapper<?> toExecutionWrapper(String expression, List<String> args, IEntityField focusField, IEntity entity, IEntityClass entityClass) throws CalculationException {
        ExpressionWrapper expressionWrapper = ExpressionWrapper.Builder.anExpression().withExpression(expression).withCached(true).build();
        Map<String, Object> runtimeParams = FormulaHelper.toRuntimeParams(args, focusField, entity, entityClass);
        return new ExecutionWrapper(expressionWrapper, runtimeParams);
    }

    private static Map<String, Object> toRuntimeParams(List<String> args, IEntityField focusField, IEntity entity, IEntityClass entityClass) throws CalculationException {
        Optional thisValueOp;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("runtimeArgs is {}", args);
        }
        if (null != args) {
            for (String arg : args) {
                IEntityField entityField;
                if (arg.equals(FORMULA_THIS_VALUE)) continue;
                Optional valueOp = entity.entityValue().getValue(arg);
                if (valueOp.isPresent()) {
                    map.put(arg, ((IValue)valueOp.get()).getValue());
                    continue;
                }
                Optional entityFieldOptional = entityClass.field(arg);
                Object defaultValue = null;
                if (entityFieldOptional.isPresent() && (entityField = (IEntityField)entityFieldOptional.get()).calculationType() == CalculationType.FORMULA) {
                    defaultValue = ((Formula)entityField.config().getCalculation()).getFailedDefaultValue();
                }
                map.put(arg, defaultValue);
            }
        }
        if ((thisValueOp = entity.entityValue().getValue(focusField.id())).isPresent()) {
            map.put(FORMULA_THIS_VALUE, ((IValue)thisValueOp.get()).getValue());
        }
        return map;
    }

    public static Object calculate(String expression, List<String> args, CalculationContext context) throws CalculationException {
        ExecutionWrapper<?> executionWrapper = FormulaHelper.toExecutionWrapper(expression, args, context.getFocusField(), context.getFocusEntity(), context.getFocusClass());
        executionWrapper.getParams().put(FORMULA_CTX_PARAM, context.getFocusField());
        return AviatorHelper.execute(executionWrapper);
    }
}

