/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation;

import com.xforceplus.ultraman.oqsengine.calculation.dto.ErrorCalculateInstance;
import com.xforceplus.ultraman.oqsengine.calculation.dto.ErrorFieldUnit;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationInitException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInit;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInitInstance;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitInstance;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.InitInstanceUnit;
import com.xforceplus.ultraman.oqsengine.calculation.utils.CalculationComparator;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public class DefaultCalculationInitInstanceImpl
implements CalculationInitInstance {
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private MetaManager metaManager;
    @Resource
    private CalculationInit calculationInit;

    @Override
    public Optional<IEntity> initInstance(Long id, IEntityClass entityClass, boolean force) {
        return this.initField(id, entityClass, this.calculateFields(entityClass), force);
    }

    @Override
    public List<IEntity> initInstances(List<Long> ids, IEntityClass entityClass, boolean force, Long limit) {
        return this.initFields(ids, entityClass, this.calculateFields(entityClass), force, limit);
    }

    @Override
    public List<IEntity> initFields(List<Long> ids, IEntityClass entityClass, List<IEntityField> fields, boolean force, Long limit) {
        try {
            if (fields.size() <= 0) {
                throw new CalculationInitException("reCalculate fields must exist");
            }
            if ((long)ids.size() > limit) {
                throw new CalculationInitException(String.format("reCalculate entities size can not over %d", limit));
            }
            Collection entities = this.masterStorage.selectMultiple(ids.stream().mapToLong(t -> t).toArray(), entityClass);
            if (entities.isEmpty()) {
                throw new CalculationInitException(String.format("instance not found by ids: %s", Arrays.toString(ids.stream().mapToLong(t -> t).toArray())));
            }
            List<InitInstance> initInstances = this.buildMultiInstance((List)entities, entityClass, fields);
            return this.calculationInit.init(initInstances);
        }
        catch (Exception e) {
            throw new CalculationInitException(e);
        }
    }

    @Override
    public Optional<IEntity> initField(Long id, IEntityClass entityClass, List<IEntityField> fields, boolean force) {
        if (fields.size() <= 0) {
            throw new CalculationInitException("reCalculate fields must exist");
        }
        try {
            Optional entity = this.masterStorage.selectOne(id.longValue(), entityClass);
            if (!entity.isPresent()) {
                throw new CalculationInitException(String.format("instance not found by id: %d", id));
            }
            Optional<InitInstance> initInstance = this.buildInstance((IEntity)entity.get(), entityClass, fields);
            return initInstance.map(instance -> this.calculationInit.init((InitInstance)instance));
        }
        catch (Exception e) {
            throw new CalculationInitException(e);
        }
    }

    @Override
    public List<ErrorCalculateInstance> initCheckFields(List<Long> ids, IEntityClass entityClass, List<IEntityField> fields, Long limit) {
        try {
            if (fields.size() <= 0) {
                throw new CalculationInitException("reCalculate fields must exist");
            }
            if ((long)ids.size() > limit) {
                throw new CalculationInitException(String.format("dryRun entities size can not over %d", limit));
            }
            Collection entities = this.masterStorage.selectMultiple(ids.stream().mapToLong(t -> t).toArray(), entityClass);
            ArrayList<ErrorCalculateInstance> errorCalculateInstances = new ArrayList<ErrorCalculateInstance>();
            for (IEntity entity : entities) {
                Optional<ErrorCalculateInstance> errorCalculateInstance = this.doCheckField(entity, entityClass, fields);
                errorCalculateInstance.ifPresent(errorCalculateInstances::add);
            }
            return errorCalculateInstances;
        }
        catch (Exception e) {
            throw new CalculationInitException(e);
        }
    }

    @Override
    public Optional<ErrorCalculateInstance> initCheckField(Long id, IEntityClass entityClass, List<IEntityField> fields) {
        if (fields.size() <= 0) {
            throw new CalculationInitException("reCalculate fields must exist");
        }
        try {
            Optional entity = this.masterStorage.selectOne(id.longValue(), entityClass);
            if (!entity.isPresent()) {
                throw new CalculationInitException(String.format("instance not found by id: %d", id));
            }
            return this.doCheckField((IEntity)entity.get(), entityClass, fields);
        }
        catch (Exception e) {
            throw new CalculationInitException(e);
        }
    }

    private Optional<ErrorCalculateInstance> doCheckField(IEntity entity, IEntityClass entityClass, List<IEntityField> fields) {
        Optional<InitInstance> initInstance = this.buildInstance(entity.copy(), entityClass, fields);
        if (!initInstance.isPresent()) {
            return Optional.empty();
        }
        IEntity checked = this.calculationInit.init(initInstance.get());
        IEntityValue expect = checked.entityValue();
        IEntityValue now = entity.entityValue();
        ArrayList<ErrorFieldUnit> errorFieldUnits = new ArrayList<ErrorFieldUnit>();
        for (IEntityField field : initInstance.get().getInitInstanceUnits().stream().map(InitInstanceUnit::getField).collect(Collectors.toList())) {
            Optional expectValue = expect.getValue(field.id());
            Optional nowValue = now.getValue(field.id());
            if (!nowValue.isPresent()) {
                expectValue.ifPresent(value -> errorFieldUnits.add(new ErrorFieldUnit(field, null, (IValue)value)));
                continue;
            }
            if (!expectValue.isPresent()) {
                errorFieldUnits.add(new ErrorFieldUnit(field, (IValue)nowValue.get(), null));
                continue;
            }
            if (((IValue)nowValue.get()).include((IValue)expectValue.get())) continue;
            errorFieldUnits.add(new ErrorFieldUnit(field, (IValue)nowValue.get(), (IValue)expectValue.get()));
        }
        return errorFieldUnits.isEmpty() ? Optional.empty() : Optional.of(new ErrorCalculateInstance(entity.id(), errorFieldUnits));
    }

    @Override
    public Optional<ErrorCalculateInstance> initCheckInstance(Long id, IEntityClass entityClass) {
        return this.initCheckField(id, entityClass, this.calculateFields(entityClass));
    }

    @Override
    public List<ErrorCalculateInstance> initCheckInstances(List<Long> ids, IEntityClass entityClass, Long limit) {
        return this.initCheckFields(ids, entityClass, this.calculateFields(entityClass), limit);
    }

    private Optional<InitInstance> buildInstance(IEntity entity, IEntityClass entityClass, List<IEntityField> fields) {
        List sortedFields = fields.stream().filter(field -> field.calculationType().equals((Object)CalculationType.FORMULA) || field.calculationType().equals((Object)CalculationType.AGGREGATION)).sorted(CalculationComparator.getInstance()).collect(Collectors.toList());
        List<InitInstanceUnit> initInstanceUnits = sortedFields.stream().map(field -> new InitInstanceUnit(entity, entityClass, (IEntityField)field)).collect(Collectors.toList());
        return initInstanceUnits.isEmpty() ? Optional.empty() : Optional.of(new InitInstance(entity, entityClass, initInstanceUnits));
    }

    private List<InitInstance> buildMultiInstance(List<IEntity> entities, IEntityClass entityClass, List<IEntityField> fields) {
        List sortedFields = fields.stream().filter(field -> field.calculationType().equals((Object)CalculationType.FORMULA) || field.calculationType().equals((Object)CalculationType.AGGREGATION)).sorted(CalculationComparator.getInstance()).collect(Collectors.toList());
        ArrayList<InitInstance> initInstances = new ArrayList<InitInstance>();
        for (IEntity entity : entities) {
            if (sortedFields.isEmpty()) continue;
            List<InitInstanceUnit> initInstanceUnits = sortedFields.stream().map(field -> new InitInstanceUnit(entity, entityClass, (IEntityField)field)).collect(Collectors.toList());
            InitInstance initInstance = new InitInstance(entity, entityClass, initInstanceUnits);
            initInstances.add(initInstance);
        }
        return initInstances;
    }

    private List<IEntityField> calculateFields(IEntityClass entityClass) {
        return entityClass.fields().stream().filter(field -> field.calculationType().equals((Object)CalculationType.FORMULA) || field.calculationType().equals((Object)CalculationType.AGGREGATION)).collect(Collectors.toList());
    }
}

