/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation;

import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.CalculationInitLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory.InitIvalueFactory;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory.InitIvalueLogic;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InitCalculationParticipant;
import com.xforceplus.ultraman.oqsengine.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.EntityPackage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.OqsEngineEntity;
import io.vavr.Tuple2;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCalculationInitLogic
implements CalculationInitLogic {
    private final Logger logger = LoggerFactory.getLogger(DefaultCalculationInitLogic.class);
    @Resource(name="taskThreadPool")
    private ExecutorService worker;
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private InitIvalueFactory initIvalueFactory;
    private ConcurrentMap<IEntityClass, List<IEntity>> batchEntity;
    private static final int BATCH_LIMIT = 1000;
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static final long CHECK_DONE = 100L;

    @PostConstruct
    public void init() {
        if (this.worker == null) {
            throw new IllegalArgumentException("No execution thread pool is set.");
        }
        this.batchEntity = new ConcurrentHashMap<IEntityClass, List<IEntity>>();
    }

    @PreDestroy
    public void destroy() {
        this.batchEntity.clear();
    }

    public ExecutorService getWorker() {
        return this.worker;
    }

    public void setWorker(ExecutorService worker) {
        this.worker = worker;
    }

    @Override
    public Map<String, List<InitCalculationParticipant>> accept(List<Map<IEntityClass, Collection<InitCalculationParticipant>>> run) throws InterruptedException {
        HashMap<String, List<InitCalculationParticipant>> res = new HashMap<String, List<InitCalculationParticipant>>();
        ArrayList<Future<Tuple2<Boolean, List<InitCalculationParticipant>>>> futures = new ArrayList<Future<Tuple2<Boolean, List<InitCalculationParticipant>>>>();
        for (Map<IEntityClass, Collection<InitCalculationParticipant>> classCollectionMap : run) {
            for (IEntityClass entityClass : classCollectionMap.keySet()) {
                futures.add(this.worker.submit(new Runner(entityClass, classCollectionMap.get(entityClass))));
            }
            do {
                try {
                    TimeUnit.MICROSECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!futures.stream().allMatch(Future::isDone));
            futures.forEach(future -> {
                try {
                    Tuple2 tuple2 = (Tuple2)future.get();
                    if (((Boolean)tuple2._1()).booleanValue()) {
                        if (res.get(SUCCESS) == null || ((List)res.get(SUCCESS)).isEmpty()) {
                            res.put(SUCCESS, (List)tuple2._2());
                        } else {
                            ((List)res.get(SUCCESS)).addAll((Collection)tuple2._2());
                        }
                    } else if (res.get(FAILED) == null || ((List)res.get(FAILED)).isEmpty()) {
                        res.put(FAILED, (List)tuple2._2());
                    } else {
                        ((List)res.get(FAILED)).addAll((Collection)tuple2._2());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            });
            futures.clear();
        }
        return res;
    }

    @Override
    public Tuple2<Boolean, List<InitCalculationParticipant>> initLogic(IEntityClass entityClass, Collection<InitCalculationParticipant> participants) {
        try {
            DataIterator iterator = this.masterStorage.iterator(entityClass, 0L, Long.MAX_VALUE, 0L, 1, false);
            ArrayList failedList = new ArrayList();
            while (iterator.hasNext() || !failedList.isEmpty()) {
                OqsEngineEntity oqsEngineEntity;
                Optional entity;
                if (!failedList.isEmpty()) {
                    long[] ids = new long[failedList.size()];
                    for (int i = 0; i < failedList.size(); ++i) {
                        ids[i] = ((IEntity)failedList.get(i)).id();
                    }
                    Collection entities = this.masterStorage.selectMultiple(ids, entityClass);
                    for (IEntity entity2 : entities) {
                        this.initEntity(entity2, participants);
                    }
                    failedList.clear();
                }
                if (iterator.hasNext() && (entity = this.masterStorage.selectOne((oqsEngineEntity = (OqsEngineEntity)iterator.next()).getId(), entityClass)).isPresent()) {
                    this.initEntity((IEntity)entity.get(), participants);
                }
                if (!this.batchEntity.containsKey(entityClass) || ((List)this.batchEntity.get(entityClass)).size() < 1000 && iterator.hasNext()) continue;
                Collection entities = (Collection)this.batchEntity.get(entityClass);
                if (entities.size() > 0) {
                    EntityPackage entityPackage = new EntityPackage();
                    entities.forEach(e -> entityPackage.put(e, entityClass, false));
                    this.masterStorage.replace(entityPackage);
                    entities.forEach(e -> {
                        if (e.isDirty()) {
                            failedList.add(e);
                        }
                    });
                }
                ((List)this.batchEntity.get(entityClass)).clear();
            }
            this.batchEntity.remove(entityClass);
        }
        catch (Exception e2) {
            this.logger.error(e2.getMessage(), (Throwable)e2);
            return new Tuple2((Object)false, (Object)((List)participants));
        }
        return new Tuple2((Object)true, (Object)((List)participants));
    }

    private IEntity initEntity(IEntity entity, Collection<InitCalculationParticipant> participants) throws SQLException {
        for (InitCalculationParticipant participant : participants) {
            this.initIValue(entity, participant);
        }
        return entity;
    }

    private IEntity initIValue(IEntity entity, InitCalculationParticipant participant) throws SQLException {
        InitIvalueLogic logic = this.initIvalueFactory.getLogic(participant.getField().calculationType());
        logic.init(entity, participant);
        if (participant.isChange(entity)) {
            if (this.batchEntity.get(participant.getEntityClass()) == null) {
                this.batchEntity.put(participant.getEntityClass(), Stream.of(entity).collect(Collectors.toList()));
            } else if (!((List)this.batchEntity.get(participant.getEntityClass())).contains(entity)) {
                ((List)this.batchEntity.get(participant.getEntityClass())).add(entity);
            }
        }
        return entity;
    }

    class Runner
    implements Callable<Tuple2<Boolean, List<InitCalculationParticipant>>> {
        private final IEntityClass entityClass;
        private final Collection<InitCalculationParticipant> participants;

        public Runner(IEntityClass entityClass, Collection<InitCalculationParticipant> participants) {
            this.entityClass = entityClass;
            this.participants = participants;
        }

        @Override
        public Tuple2<Boolean, List<InitCalculationParticipant>> call() throws Exception {
            return DefaultCalculationInitLogic.this.initLogic(this.entityClass, this.participants);
        }
    }
}

