/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.lookup;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.dto.AffectedInfo;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.CalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.infuence.LookupInfuenceConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.task.LookupMaintainingTask;
import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.utils.LookupEntityRefIterator;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.EntityRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Lookup;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LookupValue;
import com.xforceplus.ultraman.oqsengine.storage.ConditionsSelectStorage;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.transaction.Transaction;
import com.xforceplus.ultraman.oqsengine.task.Task;
import com.xforceplus.ultraman.oqsengine.task.TaskCoordinator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupCalculationLogic
implements CalculationLogic {
    final Logger logger = LoggerFactory.getLogger(LookupCalculationLogic.class);
    private static final int TRANSACTION_LIMIT_NUMBER = 1000;
    private static final int TASK_LIMIT_NUMBER = 10000;
    private LookupInfuenceConsumer infuenceConsumer = new LookupInfuenceConsumer();

    @Override
    public Optional<IValue> calculate(CalculationContext context) throws CalculationException {
        IEntityField focusField = context.getFocusField();
        IEntity focusEntity = context.getFocusEntity();
        long targetEntityClassId = ((Lookup)focusField.config().getCalculation()).getClassId();
        MetaManager metaManager = (MetaManager)context.getResourceWithEx(() -> context.getMetaManager());
        Optional targetEntityClassOp = metaManager.load(targetEntityClassId, "");
        if (!targetEntityClassOp.isPresent()) {
            throw new CalculationException(String.format("The expected target object meta information was not found.[%s]", targetEntityClassId));
        }
        IEntityClass targetEntityClass = (IEntityClass)targetEntityClassOp.get();
        if (!context.isMaintenance()) {
            Optional lookupValueOp = focusEntity.entityValue().getValue(focusField.id());
            if (!lookupValueOp.isPresent()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unable to instantiate the field that launched the lookup.[entityClass={}, field={}]", (Object)focusEntity.entityClassRef(), (Object)focusField.fieldName());
                }
                return Optional.empty();
            }
            IValue lookupValue = (IValue)lookupValueOp.get();
            if (!LookupValue.class.isInstance(lookupValue)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The current state is not maintenance, so the field ({}) remains unchanged.", (Object)focusField.fieldName());
                }
                return Optional.ofNullable(lookupValue);
            }
            return this.doLookup(context, (LookupValue)lookupValue, targetEntityClass);
        }
        IEntity sourceEntity = context.getSourceEntity();
        Optional nowLookupValueOp = focusEntity.entityValue().getValue(focusField.id());
        long lookUpFieldId = ((Lookup)focusField.config().getCalculation()).getFieldId();
        Optional nowTargetValueOp = sourceEntity.entityValue().getValue(lookUpFieldId);
        if (!nowLookupValueOp.isPresent() && !nowTargetValueOp.isPresent()) {
            return nowLookupValueOp;
        }
        if (nowTargetValueOp.isPresent() && !nowLookupValueOp.isPresent()) {
            LookupValue lookupValue = new LookupValue(focusField, sourceEntity.id());
            return this.doLookup(context, lookupValue, targetEntityClass);
        }
        if (!nowTargetValueOp.isPresent() && nowLookupValueOp.isPresent()) {
            LookupValue lookupValue = new LookupValue(focusField, sourceEntity.id());
            return this.doLookup(context, lookupValue, targetEntityClass);
        }
        IValue nowLookupValue = (IValue)nowLookupValueOp.get();
        IValue nowTargetValue = (IValue)nowTargetValueOp.get();
        if (nowTargetValue.equals(nowLookupValue)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Recalculation is not required because the values of the current instance ({}) field ({}) and the target instance ({}) field are the same.", new Object[]{focusEntity.id(), focusField.fieldName(), nowTargetValue.getField().fieldName()});
            }
            return Optional.ofNullable(nowLookupValue);
        }
        LookupValue lookupValue = new LookupValue(focusField, sourceEntity.id());
        return this.doLookup(context, lookupValue, targetEntityClass);
    }

    @Override
    public void scope(CalculationContext context, InfuenceGraph infuence) {
        infuence.scanNoSource(this.infuenceConsumer);
    }

    @Override
    public Collection<AffectedInfo> getMaintainTarget(CalculationContext context, Participant participant, Collection<IEntity> triggerEntities) throws CalculationException {
        if (participant.getField().calculationType() != CalculationType.LOOKUP) {
            throw new CalculationException("Wrong field type, only computed fields of the type of the Lookup can be handled.");
        }
        Optional<Object> attachmentOp = participant.getAttachment();
        if (!attachmentOp.isPresent()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[lookup]The current participant [{},{}] has no attachments, so the impact instance cannot be calculated.", (Object)participant.getEntityClass().code(), (Object)participant.getField().fieldName());
            }
            return Collections.emptyList();
        }
        boolean strong = (Boolean)attachmentOp.get();
        if (!strong) {
            LookupMaintainingTask lookupMaintainingTask = LookupMaintainingTask.Builder.anLookupMaintainingTask().withTargetClassRef(context.getFocusEntity().entityClassRef()).withTargetFieldId(((Lookup)participant.getField().config().getCalculation()).getFieldId()).withLookupClassRef(participant.getEntityClass().ref()).withLookupFieldId(participant.getField().id()).withLastStartLookupEntityId(0L).withMaxSize(10000).withTargetEntityId(context.getSourceEntity().id()).build();
            this.addAfterCommitTask(context, lookupMaintainingTask);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[lookup] Because the relationship is weak, the current influence node is returned empty.[{},{}]", (Object)participant.getEntityClass().code(), (Object)participant.getField().fieldName());
            }
            return Collections.emptyList();
        }
        LookupEntityRefIterator refIter = new LookupEntityRefIterator(1000, 1000L);
        refIter.setCombinedSelectStorage((ConditionsSelectStorage)context.getResourceWithEx(() -> context.getConditionsSelectStorage()));
        refIter.setEntityClass(participant.getEntityClass());
        refIter.setField(participant.getField());
        refIter.setTargetEntityId(context.getSourceEntity().id());
        refIter.setStartId(0L);
        ArrayList<EntityRef> refs = new ArrayList<EntityRef>();
        while (refIter.hasNext()) {
            refs.add((EntityRef)refIter.next());
        }
        List<AffectedInfo> affectedInfos = refs.stream().map(r -> new AffectedInfo(context.getFocusEntity(), r.getId())).collect(Collectors.toList());
        if (refIter.more()) {
            LookupMaintainingTask lookupMaintainingTask = LookupMaintainingTask.Builder.anLookupMaintainingTask().withTargetEntityId(context.getFocusEntity().id()).withTargetClassRef(context.getFocusEntity().entityClassRef()).withTargetFieldId(((Lookup)participant.getField().config().getCalculation()).getFieldId()).withLookupClassRef(participant.getEntityClass().ref()).withLookupFieldId(participant.getField().id()).withLastStartLookupEntityId(affectedInfos.get(affectedInfos.size() - 1).getAffectedEntityId()).withMaxSize(10000).build();
            this.addAfterCommitTask(context, lookupMaintainingTask);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The number of instances affected by the participant ({},{}) is {}.", new Object[]{participant.getEntityClass().code(), participant.getField().fieldName(), affectedInfos.size()});
        }
        return affectedInfos;
    }

    @Override
    public CalculationType supportType() {
        return CalculationType.LOOKUP;
    }

    @Override
    public CalculationScenarios[] needMaintenanceScenarios() {
        return new CalculationScenarios[]{CalculationScenarios.REPLACE};
    }

    private void addAfterCommitTask(CalculationContext context, LookupMaintainingTask lookupMaintainingTask) {
        TaskCoordinator coordinator = (TaskCoordinator)context.getResourceWithEx(() -> context.getTaskCoordinator());
        ExecutorService taskExecutor = (ExecutorService)context.getResourceWithEx(() -> context.getTaskExecutorService());
        ((Transaction)context.getResourceWithEx(() -> context.getCurrentTransaction())).registerCommitHook(t -> taskExecutor.submit(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Added a Lookup maintenance asynchronous task.{}", (Object)lookupMaintainingTask);
            }
            coordinator.addTask((Task)lookupMaintainingTask);
        }));
    }

    private Optional<IValue> doLookup(CalculationContext context, LookupValue lookupValue, IEntityClass targetEntityClass) {
        Optional<IEntity> targetEntityOp = this.findTargetEntity(context, lookupValue.valueToLong(), targetEntityClass);
        if (!targetEntityOp.isPresent()) {
            this.logger.warn("Unable to find the target of the lookup ({}).", (Object)lookupValue.valueToLong());
            return Optional.of(new EmptyTypedValue(context.getFocusField()));
        }
        IEntity targetEntity = targetEntityOp.get();
        Optional<IValue> targetValueOp = this.findTargetValue(context, targetEntity);
        if (!targetValueOp.isPresent()) {
            IEntityField focusField = context.getFocusField();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The target ({}) field ({}) value of the lookup could not be found.", (Object)lookupValue.valueToLong(), (Object)((Lookup)focusField.config().getCalculation()).getFieldId());
            }
            return Optional.of(new EmptyTypedValue(context.getFocusField(), Long.toString(targetEntity.id())));
        }
        IValue targetValue = targetValueOp.get();
        targetValue = targetValue.copy(context.getFocusField(), Long.toString(targetEntity.id()));
        return Optional.of(targetValue);
    }

    private Optional<IEntity> findTargetEntity(CalculationContext context, long targetEntityId, IEntityClass targetEntityClass) {
        Optional targetEntityOp = context.getEntityToCache(targetEntityId);
        if (!targetEntityOp.isPresent()) {
            MasterStorage masterStorage = (MasterStorage)context.getResourceWithEx(() -> context.getMasterStorage());
            try {
                targetEntityOp = masterStorage.selectOne(targetEntityId, targetEntityClass);
            }
            catch (SQLException ex) {
                throw new CalculationException(ex.getMessage(), ex);
            }
        }
        return targetEntityOp;
    }

    private Optional<IValue> findTargetValue(CalculationContext context, IEntity targetEntity) {
        long targetFieldId = ((Lookup)context.getFocusField().config().getCalculation()).getFieldId();
        return targetEntity.entityValue().getValue(targetFieldId);
    }
}

