/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.dto.agg;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectAttachment {
    private Map<String, Integer> collectElements;
    private int used;

    public CollectAttachment(Map<String, Integer> collectElements) {
        this.collectElements = collectElements;
        this.used = collectElements.size();
    }

    public void compareAndOperation(String element, boolean isAdd, int capacity) {
        this.collectElements.compute(element, (k, v) -> {
            if (v == null) {
                if (isAdd) {
                    if (this.used >= capacity) {
                        return null;
                    }
                    ++this.used;
                }
                v = 0;
            }
            v = isAdd ? v + 1 : v - 1;
            if (!isAdd && v == 0) {
                --this.used;
                return null;
            }
            return v;
        });
    }

    public IValue toIValue(IEntityField entityField) {
        if (this.collectElements.isEmpty()) {
            return new StringsValue(entityField, new String[0], "");
        }
        ArrayList attachments = new ArrayList();
        ArrayList collect = new ArrayList();
        this.collectElements.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).forEach(e -> {
            collect.add((String)e.getKey());
            attachments.add((Integer)e.getValue());
        });
        String attachmentStr = attachments.stream().map(String::valueOf).collect(Collectors.joining(","));
        return new StringsValue(entityField, collect.toArray(new String[0]), attachmentStr);
    }
}

