/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.impl;

import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.utils.BigDecimalSummaryStatistics;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.able.CalculationsAble;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.stream.Collectors;

public class SumFunction
implements AggregationFunction {
    @Override
    public Optional<IValue> excute(Optional<IValue> agg, ValueChange valueChange) {
        Optional<IValue> o = valueChange.getOldValue();
        Optional<IValue> n = valueChange.getNewValue();
        if (!(agg.isPresent() & o.isPresent()) || !n.isPresent()) {
            return Optional.empty();
        }
        IValue aggCopyValue = agg.get().copy();
        IValue oldValue = o.get() instanceof EmptyTypedValue ? IValueUtils.zero((IEntityField)o.get().getField()) : o.get();
        IValue newValue = n.get() instanceof EmptyTypedValue ? IValueUtils.zero((IEntityField)n.get().getField()) : n.get();
        CalculationsAble ca = (CalculationsAble)aggCopyValue;
        return Optional.of((IValue)ca.plus(newValue).subtract(oldValue));
    }

    @Override
    public Optional<IValue> init(Optional<IValue> agg, List<Optional<IValue>> values) {
        Optional<IValue> aggValue = Optional.of(agg.get().copy());
        if (agg.get() instanceof DecimalValue) {
            BigDecimalSummaryStatistics temp = values.stream().map(v -> (BigDecimal)((DecimalValue)v.get()).getValue()).collect(BigDecimalSummaryStatistics.statistics());
            aggValue.get().setStringValue(temp.getSum().toString());
        } else if (agg.get() instanceof LongValue) {
            LongSummaryStatistics temp = values.stream().map(o -> (IValue)o.get()).collect(Collectors.summarizingLong(IValue::valueToLong));
            aggValue.get().setStringValue(String.valueOf(temp.getSum()));
        }
        return Optional.of(aggValue.get());
    }
}

