/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper;

import com.xforceplus.ultraman.oqsengine.calculation.dto.agg.CollectAttachment;
import com.xforceplus.ultraman.oqsengine.common.NumberUtils;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.util.LinkedHashMap;
import java.util.Optional;

public class AggregationAttachmentHelper {
    public static final String COLLECT_ATTACHMENT_DIVIDE = ",";
    private static final char DIVIDER = '|';
    private static final int COUNT_INDEX = 0;
    private static final int SUM_INDEX = 1;
    private static final int NO = -1;

    public static long count(IValue value) {
        return AggregationAttachmentHelper.readLong(value, 0);
    }

    public static long count(IValue value, long defaultValue) {
        long count = AggregationAttachmentHelper.count(value);
        return count == -1L ? defaultValue : count;
    }

    public static long sum(IValue value) {
        return AggregationAttachmentHelper.readLong(value, 1);
    }

    public static long sum(IValue value, long defaultValue) {
        long sum = AggregationAttachmentHelper.sum(value);
        return sum == -1L ? defaultValue : sum;
    }

    public static String buildAttachment(long count, long sum) {
        StringBuilder buff = new StringBuilder();
        buff.append(count).append('|').append(sum);
        return buff.toString();
    }

    public static Optional<CollectAttachment> buildCollectAttachment(String[] fieldValues, String attachment) {
        LinkedHashMap<String, Integer> collectElements = new LinkedHashMap<String, Integer>();
        if (fieldValues.length > 0) {
            String[] attachments = attachment.split(COLLECT_ATTACHMENT_DIVIDE);
            if (fieldValues.length != attachments.length) {
                return Optional.empty();
            }
            for (int i = 0; i < fieldValues.length; ++i) {
                collectElements.put(fieldValues[i], Integer.parseInt(attachments[i]));
            }
        }
        return Optional.of(new CollectAttachment(collectElements));
    }

    private static long readLong(IValue value, int index) {
        if (value.getField().calculationType() != CalculationType.AGGREGATION) {
            return -1L;
        }
        Optional attachment = value.getAttachment();
        String str = attachment.map(v -> AggregationAttachmentHelper.read(v, index)).orElse(Optional.of("")).get();
        if (NumberUtils.isIntegerString((String)str)) {
            return Long.parseLong(str);
        }
        return -1L;
    }

    private static Optional<String> read(String value, int index) {
        StringBuilder buff = new StringBuilder();
        int point = 0;
        for (char c : value.toCharArray()) {
            if ('|' == c) {
                if (point == index) {
                    return Optional.ofNullable(buff.toString());
                }
                ++point;
                continue;
            }
            buff.append(c);
        }
        return Optional.empty();
    }
}

