/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper.AggregationAttachmentHelper;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.FunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvgFunctionStrategy
implements FunctionStrategy {
    final Logger logger = LoggerFactory.getLogger(AvgFunctionStrategy.class);

    @Override
    public Optional<IValue> excute(Optional<IValue> currentValue, ValueChange valueChange, CalculationContext context) {
        IValue oldValue = valueChange.getOldValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        IValue newValue = valueChange.getNewValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("begin excuteAvg agg:{}, o-value:{}, n-value:{}", new Object[]{currentValue.get().valueToString(), oldValue.valueToString(), newValue.valueToString()});
        }
        Aggregation aggregation = (Aggregation)context.getFocusField().config().getCalculation();
        Optional<IValue> aggValue = Optional.of(currentValue.get().copy());
        long count = AggregationAttachmentHelper.count(aggValue.get(), 0L);
        if (count == 0L) {
            if (!context.getFocusField().type().equals((Object)FieldType.DATETIME)) {
                Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), oldValue, newValue, CalculationScenarios.BUILD));
                return attAggValue;
            }
            return aggValue;
        }
        if (aggregation.getClassId() == context.getSourceEntity().entityClassRef().getId()) {
            if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
                Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), oldValue, newValue, CalculationScenarios.BUILD));
                return attAggValue;
            }
            if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
                Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), oldValue, newValue, CalculationScenarios.DELETE));
                return attAggValue;
            }
            Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), oldValue, newValue, CalculationScenarios.REPLACE));
            return attAggValue;
        }
        Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), oldValue, newValue, CalculationScenarios.REPLACE));
        return attAggValue;
    }

    private IValue attachmentReplace(IValue value, IValue o, IValue n, CalculationScenarios calculationScenarios) {
        String attachment;
        String[] att;
        Optional attachmentOp = value.getAttachment();
        if (attachmentOp.isPresent() && (att = StringUtils.split((String)(attachment = (String)attachmentOp.get()), (String)"|")).length > 1) {
            if (value instanceof DecimalValue) {
                long count;
                BigDecimal sum;
                if (o instanceof EmptyTypedValue) {
                    o = new DecimalValue(o.getField(), BigDecimal.ZERO);
                }
                if (n instanceof EmptyTypedValue) {
                    n = new DecimalValue(n.getField(), BigDecimal.ZERO);
                }
                if (calculationScenarios.equals((Object)CalculationScenarios.BUILD)) {
                    sum = new BigDecimal(att[1]).add(new BigDecimal(n.valueToString()));
                    count = Long.parseLong(att[0]) + 1L;
                } else if (calculationScenarios.equals((Object)CalculationScenarios.DELETE)) {
                    sum = new BigDecimal(att[1]).subtract(new BigDecimal(o.valueToString()));
                    count = Long.parseLong(att[0]) - 1L;
                } else {
                    count = Long.parseLong(att[0]);
                    sum = new BigDecimal(att[1]).add(new BigDecimal(n.valueToString())).subtract(new BigDecimal(o.valueToString()));
                }
                BigDecimal temp = count != 0L ? sum.divide(new BigDecimal(count), MathContext.DECIMAL64) : BigDecimal.ZERO;
                value.setStringValue(temp.toString());
                return value.copy(count + "|" + sum);
            }
            if (value instanceof LongValue) {
                long count;
                long sum;
                if (o instanceof EmptyTypedValue) {
                    o = new LongValue(o.getField(), 0L);
                }
                if (n instanceof EmptyTypedValue) {
                    n = new LongValue(n.getField(), 0L);
                }
                if (calculationScenarios.equals((Object)CalculationScenarios.BUILD)) {
                    sum = Long.parseLong(att[1]) + Long.parseLong(n.valueToString());
                    count = Long.parseLong(att[0]) + 1L;
                } else if (calculationScenarios.equals((Object)CalculationScenarios.DELETE)) {
                    sum = Long.parseLong(att[1]) - Long.parseLong(o.valueToString());
                    count = Long.parseLong(att[0]) - 1L;
                } else {
                    sum = Long.parseLong(att[1]) + Long.parseLong(n.valueToString()) - Long.parseLong(o.valueToString());
                    count = Long.parseLong(att[0]);
                }
                Long temp = count != 0L ? Long.valueOf(sum / count) : Long.valueOf(0L);
                value.setStringValue(temp.toString());
                return value.copy(count + "|" + sum);
            }
        }
        return value;
    }
}

