/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.impl;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunctionFactoryImpl;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.helper.AggregationAttachmentHelper;
import com.xforceplus.ultraman.oqsengine.calculation.logic.aggregation.strategy.FunctionStrategy;
import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.pojo.dto.EntityRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.sort.Sort;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.select.SelectConfig;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxFunctionStrategy
implements FunctionStrategy {
    final Logger logger = LoggerFactory.getLogger(MaxFunctionStrategy.class);

    @Override
    public Optional<IValue> excute(Optional<IValue> currentValue, ValueChange valueChange, CalculationContext context) {
        IValue oldValue = valueChange.getOldValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        IValue newValue = valueChange.getNewValue().orElse((IValue)new EmptyTypedValue(valueChange.getField()));
        if (oldValue instanceof EmptyTypedValue) {
            oldValue = IValueUtils.zero((IEntityField)oldValue.getField());
        }
        if (newValue instanceof EmptyTypedValue) {
            newValue = IValueUtils.zero((IEntityField)newValue.getField());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("begin excuteMax agg:{}, o-value:{}, n-value:{}", new Object[]{currentValue.get().valueToString(), oldValue.valueToString(), newValue.valueToString()});
        }
        Optional<IValue> aggValue = Optional.of(currentValue.get().copy());
        Aggregation aggregation = (Aggregation)context.getFocusField().config().getCalculation();
        AggregationFunction function = AggregationFunctionFactoryImpl.getAggregationFunction(aggregation.getAggregationType());
        if (aggValue.get().valueToLong() == 0L || aggValue.get().valueToString().equals("0.0") || aggValue.get().getValue().equals(DateTimeValue.MIN_DATE_TIME)) {
            long count = AggregationAttachmentHelper.count(aggValue.get(), 0L);
            if (context.getScenariso().equals((Object)CalculationScenarios.BUILD) && count == 0L) {
                aggValue.get().setStringValue(newValue.valueToString());
                Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
                return attAggValue;
            }
        }
        if (aggValue.get().valueToString().equals(oldValue.valueToString())) {
            if (aggregation.getClassId() == context.getSourceEntity().entityClassRef().getId()) {
                if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
                    Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
                    return function.excute(attAggValue, valueChange);
                }
                if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
                    Optional<IValue> maxValue = null;
                    try {
                        maxValue = this.maxAggregationEntity(aggregation, context, CalculationScenarios.DELETE);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    if (maxValue.isPresent()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Found max value {}", (Object)maxValue.get().valueToString());
                        }
                        aggValue.get().setStringValue(maxValue.get().valueToString());
                        Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
                        return attAggValue;
                    }
                    aggValue.get().setStringValue("0");
                    Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
                    return attAggValue;
                }
                if (this.checkMaxValue(oldValue, newValue)) {
                    Optional<IValue> maxValue = null;
                    try {
                        maxValue = this.maxAggregationEntity(aggregation, context, CalculationScenarios.REPLACE);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (maxValue.isPresent()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.info("Found max value {}", (Object)maxValue.get().valueToString());
                        }
                        if (this.checkMaxValue(maxValue.get(), newValue)) {
                            aggValue.get().setStringValue(maxValue.get().valueToString());
                            return aggValue;
                        }
                        aggValue.get().setStringValue(newValue.valueToString());
                        return aggValue;
                    }
                    aggValue.get().setStringValue(newValue.valueToString());
                    return aggValue;
                }
                aggValue.get().setStringValue(newValue.valueToString());
                return aggValue;
            }
            if (this.checkMaxValue(oldValue, newValue)) {
                Optional<IValue> maxValue = null;
                try {
                    maxValue = this.maxAggregationEntity(aggregation, context, CalculationScenarios.REPLACE);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (maxValue.isPresent()) {
                    if (this.checkMaxValue(maxValue.get(), newValue)) {
                        aggValue.get().setStringValue(maxValue.get().valueToString());
                        return aggValue;
                    }
                    aggValue.get().setStringValue(newValue.valueToString());
                    return aggValue;
                }
                aggValue.get().setStringValue(newValue.valueToString());
                return aggValue;
            }
            aggValue.get().setStringValue(newValue.valueToString());
            return aggValue;
        }
        if (context.getScenariso().equals((Object)CalculationScenarios.DELETE)) {
            Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "-1", "0"));
            return attAggValue;
        }
        if (context.getScenariso().equals((Object)CalculationScenarios.BUILD)) {
            Optional<IValue> attAggValue = Optional.of(this.attachmentReplace(aggValue.get(), "1", "0"));
            return function.excute(attAggValue, valueChange);
        }
        return function.excute(aggValue, valueChange);
    }

    private IValue attachmentReplace(IValue value, String count, String sum) {
        String attachment;
        String[] att;
        Optional attachmentOp = value.getAttachment();
        if (attachmentOp.isPresent() && (att = StringUtils.split((String)(attachment = (String)attachmentOp.get()), (String)"|")).length > 1) {
            if (value instanceof DecimalValue) {
                return value.copy(Long.parseLong(att[0]) + Long.parseLong(count) + "|" + new BigDecimal(att[1]).add(new BigDecimal(sum)));
            }
            if (value instanceof LongValue) {
                return value.copy(Long.parseLong(att[0]) + Long.parseLong(count) + "|" + (Long.parseLong(att[1]) + Long.parseLong(sum)));
            }
            if (value instanceof DateTimeValue) {
                return value.copy(Long.valueOf(att[0]) + Long.valueOf(count) + "|" + att[1]);
            }
        }
        return value;
    }

    private Optional<IValue> maxAggregationEntity(Aggregation aggregation, CalculationContext context, CalculationScenarios calculationScenarios) throws SQLException {
        Optional aggEntityClass = context.getMetaManager().get().load(aggregation.getClassId(), context.getFocusEntity().entityClassRef().getProfile());
        if (aggEntityClass.isPresent()) {
            IEntityClass entityClass = (IEntityClass)aggEntityClass.get();
            Conditions conditions = Conditions.buildEmtpyConditions();
            Optional entityField = entityClass.field(aggregation.getRelationId());
            if (entityField.isPresent()) {
                conditions.addAnd(new Condition((IEntityField)entityField.get(), ConditionOperator.EQUALS, new IValue[]{new LongValue((IEntityField)entityField.get(), context.getFocusEntity().id())}));
            }
            Page emptyPage = Page.newSinglePage((long)2L);
            ArrayList entityRefs = new ArrayList(context.getConditionsSelectStorage().get().select(conditions, (IEntityClass)aggEntityClass.get(), SelectConfig.Builder.anSelectConfig().withPage(emptyPage).withSort(Sort.buildDescSort((IEntityField)((IEntityField)((IEntityClass)aggEntityClass.get()).field(aggregation.getFieldId()).get()))).build()));
            MasterStorage masterStorage = (MasterStorage)context.getResourceWithEx(() -> context.getMasterStorage());
            if (!entityRefs.isEmpty()) {
                Optional entity;
                if (entityRefs.size() < 2) {
                    if (entityRefs.size() == 1) {
                        if (calculationScenarios.equals((Object)CalculationScenarios.REPLACE)) {
                            return Optional.empty();
                        }
                        Optional entity2 = masterStorage.selectOne(((EntityRef)entityRefs.get(0)).getId(), entityClass);
                        if (entity2.isPresent()) {
                            return ((IEntity)entity2.get()).entityValue().getValue(aggregation.getFieldId());
                        }
                    }
                    return Optional.empty();
                }
                if (calculationScenarios.equals((Object)CalculationScenarios.DELETE) && (entity = masterStorage.selectOne(((EntityRef)entityRefs.get(0)).getId(), entityClass)).isPresent()) {
                    return ((IEntity)entity.get()).entityValue().getValue(aggregation.getFieldId());
                }
                entity = masterStorage.selectOne(((EntityRef)entityRefs.get(1)).getId(), entityClass);
                if (entity.isPresent()) {
                    return ((IEntity)entity.get()).entityValue().getValue(aggregation.getFieldId());
                }
            }
        }
        return Optional.empty();
    }

    private boolean checkMaxValue(IValue o, IValue n) {
        if (o instanceof EmptyTypedValue) {
            return false;
        }
        if (n instanceof EmptyTypedValue) {
            return true;
        }
        if (o instanceof DecimalValue) {
            double temp = Math.max(((BigDecimal)((DecimalValue)o).getValue()).doubleValue(), ((BigDecimal)((DecimalValue)n).getValue()).doubleValue());
            return Double.compare(temp, ((BigDecimal)((DecimalValue)o).getValue()).doubleValue()) == 0;
        }
        if (o instanceof LongValue) {
            long temp = Math.max(o.valueToLong(), n.valueToLong());
            return temp == o.valueToLong();
        }
        if (o instanceof DateTimeValue) {
            long temp = Math.max(o.valueToLong(), n.valueToLong());
            return temp == o.valueToLong();
        }
        return false;
    }
}

