/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.formula;

import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationContext;
import com.xforceplus.ultraman.oqsengine.calculation.context.CalculationScenarios;
import com.xforceplus.ultraman.oqsengine.calculation.dto.AffectedInfo;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.logic.CalculationLogic;
import com.xforceplus.ultraman.oqsengine.calculation.logic.formula.helper.FormulaHelper;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.CalculationParticipant;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraph;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceGraphConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaCalculationLogic
implements CalculationLogic {
    final Logger logger = LoggerFactory.getLogger(FormulaCalculationLogic.class);
    private static final int MAX_ERROR_MESSAGE_LENGTH = 256;

    @Override
    public Optional<IValue> calculate(CalculationContext context) throws CalculationException {
        Formula formula = (Formula)context.getFocusField().config().getCalculation();
        try {
            return Optional.of(IValueUtils.toIValue((IEntityField)context.getFocusField(), (Object)FormulaHelper.calculate(formula.getExpression(), formula.getArgs(), context)));
        }
        catch (Exception e) {
            if (formula.getFailedPolicy().equals((Object)Formula.FailedPolicy.USE_FAILED_DEFAULT_VALUE)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("formula [entityFieldId-{}] has executed failed, will use failed default value to instead, [reason-{}]", (Object)context.getFocusField().id(), (Object)e.getMessage());
                }
                context.hint(context.getFocusField(), e.getMessage().substring(0, Math.min(e.getMessage().length(), 256)));
                return Optional.of(IValueUtils.toIValue((IEntityField)context.getFocusField(), (Object)formula.getFailedDefaultValue()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("formula [entityFieldId-{}] has executed failed, execution will broken, [reason-{}]", (Object)context.getFocusField().id(), (Object)e.getMessage());
            }
            throw new CalculationException(e.getMessage(), e);
        }
    }

    @Override
    public void scope(CalculationContext context, InfuenceGraph infuence) {
        infuence.scanNoSource((parentParticipant, participant, infuenceInner) -> {
            IEntityClass participantClass = participant.getEntityClass();
            IEntityField participantField = participant.getField();
            List<IEntityField> fields = participantClass.fields().stream().filter(f -> f.calculationType() == CalculationType.FORMULA).collect(Collectors.toList());
            if (fields != null && fields.size() > 0) {
                fields.forEach(f -> {
                    Formula formula = (Formula)f.config().getCalculation();
                    List args = formula.getArgs();
                    if (args.size() > 0 && args.contains(participantField.name())) {
                        CalculationParticipant p = CalculationParticipant.Builder.anParticipant().withEntityClass(participantClass).withField((IEntityField)f).build();
                        infuenceInner.impact(participant, p);
                    }
                });
            }
            return InfuenceGraphConsumer.Action.CONTINUE;
        });
    }

    @Override
    public Collection<AffectedInfo> getMaintainTarget(CalculationContext context, Participant participant, Collection<IEntity> entities) throws CalculationException {
        return entities.stream().filter(e -> e.id() > 0L).map(e -> new AffectedInfo((IEntity)e, e.id())).collect(Collectors.toList());
    }

    @Override
    public CalculationType supportType() {
        return CalculationType.FORMULA;
    }

    @Override
    public CalculationScenarios[] needMaintenanceScenarios() {
        return new CalculationScenarios[]{CalculationScenarios.BUILD, CalculationScenarios.REPLACE, CalculationScenarios.DELETE};
    }
}

