/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory;

import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunction;
import com.xforceplus.ultraman.oqsengine.calculation.function.aggregation.AggregationFunctionFactoryImpl;
import com.xforceplus.ultraman.oqsengine.calculation.logic.initcalculation.initivaluefactory.InitIvalueLogic;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InitCalculationParticipant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.EntityRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.sort.Sort;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import com.xforceplus.ultraman.oqsengine.storage.index.IndexStorage;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.select.SelectConfig;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationInitLogic
implements InitIvalueLogic {
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private CommitIdStatusService commitIdStatusService;
    @Resource
    private IndexStorage indexStorage;
    final Logger logger = LoggerFactory.getLogger(AggregationInitLogic.class);

    @Override
    public CalculationType getCalculationType() {
        return CalculationType.AGGREGATION;
    }

    @Override
    public IEntity init(IEntity entity, InitCalculationParticipant participant) throws RuntimeException, SQLException {
        Optional value = entity.entityValue().getValue(participant.getField().id());
        if (!value.isPresent() || ((IValue)value.get()).getValue() instanceof EmptyTypedValue) {
            participant.setProcess(entity);
            Aggregation aggregation = (Aggregation)participant.getField().config().getCalculation();
            Conditions conditions = aggregation.getConditions().orElse(Conditions.buildEmtpyConditions());
            List relationships = participant.getEntityClass().relationship().stream().filter(relationship -> relationship.getId() == aggregation.getRelationId()).collect(Collectors.toList());
            if (relationships.isEmpty()) {
                throw new CalculationException(String.format("not found relationShip in aggregation, field id is %s, entityClass id is %s", participant.getField().id(), participant.getEntityClass().id()));
            }
            Relationship relation = (Relationship)relationships.get(0);
            conditions.addAnd(new Condition(relation.getEntityField(), ConditionOperator.EQUALS, new IValue[]{new LongValue(relation.getEntityField(), entity.id())}));
            long minUnSyncCommitId = this.getMinCommitId();
            IEntityClass sourceEntityClass = participant.getSourceEntityClass();
            Collection entityRefs = this.masterStorage.select(conditions, sourceEntityClass, SelectConfig.Builder.anSelectConfig().withSort(Sort.buildAscSort((IEntityField)EntityField.ID_ENTITY_FIELD)).withCommitId(minUnSyncCommitId).build());
            Set ids = entityRefs.stream().map(EntityRef::getId).collect(Collectors.toSet());
            if (this.logger.isInfoEnabled()) {
                this.logger.debug(String.format("masterStorage select by conditions , entityClassId is %s, mainEntityId is %s, result id list is %s ", participant.getEntityClass().id(), entity.id(), ids));
            }
            entityRefs = null;
            long defaultPageSize = 1000L;
            Page page = new Page(1L, defaultPageSize);
            Collection indexEntityRefs = this.indexStorage.select(conditions, sourceEntityClass, SelectConfig.Builder.anSelectConfig().withSort(Sort.buildAscSort((IEntityField)EntityField.ID_ENTITY_FIELD)).withPage(page).withCommitId(minUnSyncCommitId).withExcludedIds(ids).build());
            Set indexIds = indexEntityRefs.stream().map(EntityRef::getId).collect(Collectors.toSet());
            indexIds.addAll(ids);
            long[] combinedIds = indexIds.stream().mapToLong(Long::longValue).toArray();
            Collection entities = this.masterStorage.selectMultiple(combinedIds, sourceEntityClass);
            EntityField sourceField = participant.getSourceFields().size() > 0 ? (IEntityField)((ArrayList)participant.getSourceFields()).get(0) : EntityField.Builder.anEntityField().build();
            List<Optional<IValue>> ivalues = entities.stream().map(arg_0 -> AggregationInitLogic.lambda$init$1((IEntityField)sourceField, arg_0)).collect(Collectors.toList());
            int count = combinedIds.length;
            if (page.getTotalCount() > defaultPageSize) {
                while (page.hasNextPage()) {
                    page.getNextPage();
                    Collection refCollection = this.indexStorage.select(conditions, sourceEntityClass, SelectConfig.Builder.anSelectConfig().withSort(Sort.buildAscSort((IEntityField)EntityField.ID_ENTITY_FIELD)).withPage(page).withCommitId(minUnSyncCommitId).withExcludedIds(ids).build());
                    entities = this.masterStorage.selectMultiple(refCollection.stream().map(EntityRef::getId).collect(Collectors.toSet()).stream().mapToLong(Long::longValue).toArray(), sourceEntityClass);
                    count += entities.size();
                    ivalues.addAll(entities.stream().map(arg_0 -> AggregationInitLogic.lambda$init$2((IEntityField)sourceField, arg_0)).collect(Collectors.toList()));
                }
            }
            entities = null;
            if (ivalues.size() <= 0) {
                if (participant.getField().type().equals((Object)FieldType.DECIMAL)) {
                    entity.entityValue().addValue(IValueUtils.toIValue((IEntityField)participant.getField(), (Object)new BigDecimal("0.0")));
                } else {
                    entity.entityValue().addValue(IValueUtils.toIValue((IEntityField)participant.getField(), (Object)0));
                }
                return entity;
            }
            if (aggregation.getAggregationType().equals((Object)AggregationType.COUNT)) {
                entity.entityValue().addValue(IValueUtils.toIValue((IEntityField)participant.getField(), (Object)count));
                return entity;
            }
            Optional<IValue> aggMainIValue = this.doAgg(ivalues, aggregation.getAggregationType(), participant.getField());
            aggMainIValue.ifPresent(ivalue -> entity.entityValue().addValue(ivalue));
        }
        return entity;
    }

    private long getMinCommitId() {
        long minUnSyncCommitId;
        Optional minUnSyncCommitIdOp = this.commitIdStatusService.getMin();
        if (minUnSyncCommitIdOp.isPresent()) {
            minUnSyncCommitId = (Long)minUnSyncCommitIdOp.get();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The minimum commit number {} that is currently uncommitted was successfully obtained.", (Object)minUnSyncCommitId);
            }
        } else {
            minUnSyncCommitId = 0L;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to fetch the commit number, use the default commit number 0.");
            }
        }
        return minUnSyncCommitId;
    }

    private Optional<IValue> doAgg(List<Optional<IValue>> ivalues, AggregationType aggregationType, IEntityField entityField) {
        AggregationFunction function = AggregationFunctionFactoryImpl.getAggregationFunction(aggregationType);
        if (entityField.type().equals((Object)FieldType.DATETIME)) {
            return function.init(Optional.of(IValueUtils.toIValue((IEntityField)entityField, (Object)LocalDateTime.now())), ivalues);
        }
        if (entityField.type().equals((Object)FieldType.DECIMAL)) {
            return function.init(Optional.of(IValueUtils.toIValue((IEntityField)entityField, (Object)new BigDecimal("0.0"))), ivalues);
        }
        return function.init(Optional.of(IValueUtils.toIValue((IEntityField)entityField, (Object)0)), ivalues);
    }

    private static /* synthetic */ Optional lambda$init$2(IEntityField sourceField, IEntity i) {
        return i.entityValue().getValue(sourceField.id());
    }

    private static /* synthetic */ Optional lambda$init$1(IEntityField sourceField, IEntity i) {
        return i.entityValue().getValue(sourceField.id());
    }
}

