/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.task;

import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.task.LookupMaintainingTaskRunner;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassRef;
import com.xforceplus.ultraman.oqsengine.task.AbstractTask;

public class LookupMaintainingTask
extends AbstractTask {
    private static final int DEFAULT_SIZE = 10000;
    private EntityClassRef targetClassRef;
    private EntityClassRef lookupClassRef;
    private long lookupFieldId;
    private long targetEntityId;
    private long targetFieldId;
    private long lastStartLookupEntityId;
    private int maxSize;

    public long getTargetEntityId() {
        return this.targetEntityId;
    }

    public long getTargetFieldId() {
        return this.targetFieldId;
    }

    public long getLookupFieldId() {
        return this.lookupFieldId;
    }

    public EntityClassRef getTargetClassRef() {
        return this.targetClassRef;
    }

    public EntityClassRef getLookupClassRef() {
        return this.lookupClassRef;
    }

    public long getLastStartLookupEntityId() {
        return this.lastStartLookupEntityId;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LookupMaintainingTask{");
        sb.append("targetClassRef=").append(this.targetClassRef);
        sb.append(", lookupClassRef=").append(this.lookupClassRef);
        sb.append(", lookupFieldId=").append(this.lookupFieldId);
        sb.append(", targetEntityId=").append(this.targetEntityId);
        sb.append(", targetFieldId=").append(this.targetFieldId);
        sb.append(", lastStartLookupEntityId=").append(this.lastStartLookupEntityId);
        sb.append(", maxSize=").append(this.maxSize);
        sb.append('}');
        return sb.toString();
    }

    public Class runnerType() {
        return LookupMaintainingTaskRunner.class;
    }

    public static final class Builder {
        private EntityClassRef targetClassRef;
        private EntityClassRef lookupClassRef;
        private long lookupFieldId;
        private long targetEntityId;
        private long targetFieldId;
        private long lastStartLookupEntityId;
        private int maxSize = 10000;

        private Builder() {
        }

        public static Builder anLookupMaintainingTask() {
            return new Builder();
        }

        public Builder withTargetClassRef(EntityClassRef targetClassRef) {
            this.targetClassRef = targetClassRef;
            return this;
        }

        public Builder withLookupClassRef(EntityClassRef lookupClassRef) {
            this.lookupClassRef = lookupClassRef;
            return this;
        }

        public Builder withLookupFieldId(long lookupFieldId) {
            this.lookupFieldId = lookupFieldId;
            return this;
        }

        public Builder withTargetEntityId(long targetEntityId) {
            this.targetEntityId = targetEntityId;
            return this;
        }

        public Builder withTargetFieldId(long targetFieldId) {
            this.targetFieldId = targetFieldId;
            return this;
        }

        public Builder withMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder withLastStartLookupEntityId(long lastStartLookupEntityId) {
            this.lastStartLookupEntityId = lastStartLookupEntityId;
            return this;
        }

        public LookupMaintainingTask build() {
            LookupMaintainingTask lookupMaintainingTask = new LookupMaintainingTask();
            lookupMaintainingTask.maxSize = this.maxSize;
            lookupMaintainingTask.targetClassRef = this.targetClassRef;
            lookupMaintainingTask.lookupClassRef = this.lookupClassRef;
            lookupMaintainingTask.targetEntityId = this.targetEntityId;
            lookupMaintainingTask.lookupFieldId = this.lookupFieldId;
            lookupMaintainingTask.targetFieldId = this.targetFieldId;
            lookupMaintainingTask.lastStartLookupEntityId = this.lastStartLookupEntityId;
            return lookupMaintainingTask;
        }
    }
}

