/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.task;

import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.task.LookupMaintainingTask;
import com.xforceplus.ultraman.oqsengine.calculation.logic.lookup.utils.LookupEntityIterator;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.storage.ConditionsSelectStorage;
import com.xforceplus.ultraman.oqsengine.storage.executor.TransactionExecutor;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import com.xforceplus.ultraman.oqsengine.storage.pojo.EntityPackage;
import com.xforceplus.ultraman.oqsengine.storage.transaction.Transaction;
import com.xforceplus.ultraman.oqsengine.task.Task;
import com.xforceplus.ultraman.oqsengine.task.TaskCoordinator;
import com.xforceplus.ultraman.oqsengine.task.TaskRunner;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupMaintainingTaskRunner
implements TaskRunner {
    final Logger logger = LoggerFactory.getLogger(LookupMaintainingTaskRunner.class);
    final int entityIterBuffer = 1000;
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private MetaManager metaManager;
    @Resource(name="combinedSelectStorage")
    private ConditionsSelectStorage conditionsSelectStorage;
    @Resource(name="serviceTransactionExecutor")
    private TransactionExecutor transactionExecutor;
    private boolean withTx;

    public LookupMaintainingTaskRunner() {
        this(true);
    }

    public LookupMaintainingTaskRunner(boolean withTx) {
        this.withTx = withTx;
    }

    public void run(TaskCoordinator coordinator, Task task) {
        LookupMaintainingTask lookupMaintainingTask = (LookupMaintainingTask)task;
        Optional lookupEntityClassOp = this.metaManager.load(lookupMaintainingTask.getLookupClassRef());
        if (!lookupEntityClassOp.isPresent()) {
            this.logger.warn("The type {} that initiated the Lookup could not be found.", (Object)lookupMaintainingTask.getLookupClassRef());
            return;
        }
        IEntityClass lookupEntityClass = (IEntityClass)lookupEntityClassOp.get();
        Optional lookupFieldOp = lookupEntityClass.field(lookupMaintainingTask.getLookupFieldId());
        if (!lookupFieldOp.isPresent()) {
            this.logger.warn("The field ({}) that initiated the lookup could not be found in the meta-information ({}-{}).", new Object[]{lookupMaintainingTask.getLookupFieldId(), lookupEntityClass.id(), lookupEntityClass.code()});
            return;
        }
        IEntityField lookupField = (IEntityField)lookupFieldOp.get();
        LookupEntityIterator lookupEntityIterator = new LookupEntityIterator(1000, lookupMaintainingTask.getMaxSize());
        lookupEntityIterator.setCombinedSelectStorage(this.conditionsSelectStorage);
        lookupEntityIterator.setMasterStorage(this.masterStorage);
        lookupEntityIterator.setEntityClass(lookupEntityClass);
        lookupEntityIterator.setField(lookupField);
        lookupEntityIterator.setTargetEntityId(lookupMaintainingTask.getTargetEntityId());
        lookupEntityIterator.setStartId(lookupMaintainingTask.getLastStartLookupEntityId());
        Optional<IValue> targetValueOp = this.findTargetValue(lookupMaintainingTask);
        int bufferSize = 1000;
        ArrayList<IEntity> lookupEntities = new ArrayList<IEntity>(1000);
        for (int i = 0; i < lookupMaintainingTask.getMaxSize() && lookupEntityIterator.hasNext(); ++i) {
            lookupEntities.add((IEntity)lookupEntityIterator.next());
        }
        try {
            if (this.withTx) {
                this.transactionExecutor.execute((transaction, resource) -> {
                    this.adjustLookupEntities(transaction, lookupMaintainingTask, lookupEntities, lookupEntityClass, lookupField, targetValueOp, lookupMaintainingTask.getTargetEntityId());
                    return null;
                });
            } else {
                this.adjustLookupEntities(null, lookupMaintainingTask, lookupEntities, lookupEntityClass, lookupField, targetValueOp, lookupMaintainingTask.getTargetEntityId());
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            coordinator.addTask(task);
            return;
        }
        if (lookupEntityIterator.more()) {
            coordinator.addTask((Task)LookupMaintainingTask.Builder.anLookupMaintainingTask().withTargetEntityId(lookupMaintainingTask.getTargetEntityId()).withTargetClassRef(lookupMaintainingTask.getTargetClassRef()).withTargetFieldId(lookupMaintainingTask.getTargetFieldId()).withLookupClassRef(lookupMaintainingTask.getLookupClassRef()).withLookupFieldId(lookupMaintainingTask.getLookupFieldId()).withMaxSize(lookupMaintainingTask.getMaxSize()).withLastStartLookupEntityId(lookupEntityIterator.getStartId()).build());
        }
    }

    private void adjustLookupEntities(Transaction transaction, LookupMaintainingTask task, List<IEntity> lookupEntities, IEntityClass lookupEntityClass, IEntityField lookupField, Optional<IValue> targetValueOp, long targetEntityId) {
        List<IEntity> useLookupEntities = this.updateLookupEntityesValue(lookupEntities, lookupField, targetValueOp, targetEntityId);
        this.persist(useLookupEntities, lookupEntityClass);
        long[] notSuccessIds = lookupEntities.stream().filter(e -> e.isDirty()).mapToLong(e -> e.id()).toArray();
        List<IEntity> needReplayEntities = null;
        while (notSuccessIds.length > 0) {
            this.logger.warn("Lookup update failed. Wait 3 seconds and try again.[entityClass = {}]", (Object)lookupEntityClass.code());
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(3000L));
            Optional<IValue> replayTargetValueOp = this.findTargetValue(task);
            try {
                needReplayEntities = this.masterStorage.selectMultiple(notSuccessIds, lookupEntityClass).stream().collect(Collectors.toList());
            }
            catch (SQLException e2) {
                this.logger.error(e2.getMessage(), (Throwable)e2);
                continue;
            }
            if (needReplayEntities.isEmpty()) continue;
            this.updateLookupEntityesValue(needReplayEntities, lookupField, replayTargetValueOp, targetEntityId);
            this.persist(needReplayEntities, lookupEntityClass);
            notSuccessIds = needReplayEntities.stream().filter(e -> e.isDirty()).mapToLong(e -> e.id()).toArray();
        }
        if (transaction != null) {
            for (IEntity entity : useLookupEntities) {
                transaction.getAccumulator().accumulateReplace(entity);
            }
        }
    }

    private Optional<IValue> findTargetValue(LookupMaintainingTask lookupMaintainingTask) {
        Optional entityOp;
        Optional entityClassOp = this.metaManager.load(lookupMaintainingTask.getTargetClassRef());
        if (!entityClassOp.isPresent()) {
            return Optional.empty();
        }
        IEntityClass entityClass = (IEntityClass)entityClassOp.get();
        try {
            entityOp = this.masterStorage.selectOne(lookupMaintainingTask.getTargetEntityId(), entityClass);
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        if (!entityOp.isPresent()) {
            return Optional.empty();
        }
        IEntity entity = (IEntity)entityOp.get();
        return entity.entityValue().getValue(lookupMaintainingTask.getTargetFieldId());
    }

    private void persist(List<IEntity> lookupEntities, IEntityClass lookupEntityClass) {
        if (lookupEntities.isEmpty()) {
            return;
        }
        EntityPackage entityPackage = new EntityPackage();
        for (IEntity lookupEntity : lookupEntities) {
            entityPackage.put(lookupEntity, lookupEntityClass, false);
        }
        try {
            this.masterStorage.replace(entityPackage);
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<IEntity> updateLookupEntityesValue(List<IEntity> lookupEntities, IEntityField lookupField, Optional<IValue> targetValueOp, long targetEntityId) {
        int len = lookupEntities.size();
        if (!targetValueOp.isPresent()) {
            for (int i = 0; i < len; ++i) {
                lookupEntities.get(i).entityValue().remove(lookupField);
            }
        } else {
            IValue targetValue = targetValueOp.get();
            IValue newLookupValue = targetValue.copy(lookupField, Long.toString(targetEntityId));
            for (int i = 0; i < len; ++i) {
                lookupEntities.get(i).entityValue().addValue(newLookupValue);
            }
        }
        return lookupEntities.stream().filter(e -> e.isDirty()).collect(Collectors.toList());
    }
}

