/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class BigDecimalSummaryStatistics
implements Consumer<BigDecimal> {
    private BigDecimal sum = BigDecimal.ZERO;
    private BigDecimal min = BigDecimal.ZERO;
    private BigDecimal max = BigDecimal.ZERO;
    private long count;

    public static Collector<BigDecimal, ?, BigDecimalSummaryStatistics> statistics() {
        return Collector.of(BigDecimalSummaryStatistics::new, BigDecimalSummaryStatistics::accept, BigDecimalSummaryStatistics::merge, new Collector.Characteristics[0]);
    }

    @Override
    public void accept(BigDecimal t) {
        if (this.count == 0L) {
            Objects.requireNonNull(t);
            this.count = 1L;
            this.sum = t;
            this.min = t;
            this.max = t;
        } else {
            this.sum = this.sum.add(t);
            if (this.min.compareTo(t) > 0) {
                this.min = t;
            }
            if (this.max.compareTo(t) < 0) {
                this.max = t;
            }
            ++this.count;
        }
    }

    public BigDecimalSummaryStatistics merge(BigDecimalSummaryStatistics s) {
        if (s.count > 0L) {
            if (this.count == 0L) {
                this.count = s.count;
                this.sum = s.sum;
                this.min = s.min;
                this.max = s.max;
            } else {
                this.sum = this.sum.add(s.sum);
                if (this.min.compareTo(s.min) > 0) {
                    this.min = s.min;
                }
                if (this.max.compareTo(s.max) < 0) {
                    this.max = s.max;
                }
                this.count += s.count;
            }
        }
        return this;
    }

    public long getCount() {
        return this.count;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public BigDecimal getAverage(MathContext mc) {
        return this.count < 2L ? this.sum : this.sum.divide(BigDecimal.valueOf(this.count), mc);
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public String toString() {
        return this.count == 0L ? "empty" : this.count + " elements between " + this.min + " and " + this.max + ", sum=" + this.sum;
    }
}

