/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils.aviator;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.xforceplus.ultraman.oqsengine.calculation.dto.ExecutionWrapper;
import com.xforceplus.ultraman.oqsengine.calculation.dto.ExpressionWrapper;
import com.xforceplus.ultraman.oqsengine.calculation.exception.CalculationException;
import com.xforceplus.ultraman.oqsengine.calculation.function.GetIDFunction;
import com.xforceplus.ultraman.oqsengine.calculation.function.TimeOffsetFunction;
import java.math.MathContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviatorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AviatorHelper.class);
    private static final String REGEX_META = "(#\\{[^#${}]*\\})";
    private static final String REGEX_ENUM = "(\\$\\{[^#${}]*\\})";
    private static final int CAPACITY = 10240;
    private static final int MAX_LOOP_COUNT = 8;
    private static final AviatorEvaluatorInstance INSTANCE = AviatorEvaluator.getInstance().useLRUExpressionCache(10240);

    private static void functionAdd() {
        INSTANCE.addFunction((AviatorFunction)new TimeOffsetFunction());
        INSTANCE.addFunction((AviatorFunction)new GetIDFunction());
    }

    public static Expression compile(ExpressionWrapper expressionWrapper) {
        String functionBody = AviatorHelper.parseRule(expressionWrapper.getExpression());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Function body : {}", (Object)functionBody);
        }
        return INSTANCE.compile(expressionWrapper.getCode(), functionBody, expressionWrapper.isCached());
    }

    public static Object execute(ExecutionWrapper executionWrapper) throws CalculationException {
        Expression expression = AviatorHelper.compile(executionWrapper.getExpressionWrapper());
        if (null == expression) {
            throw new CalculationException(String.format("compile [expression-%s] failed .", executionWrapper.getExpressionWrapper().getExpression()));
        }
        return expression.execute(executionWrapper.getParams());
    }

    public static void addFunction(AviatorFunction function) {
        INSTANCE.addFunction(function);
    }

    public static String parseRule(String ruleContent) {
        Pattern pattern = Pattern.compile(REGEX_META);
        Pattern enumPatten = Pattern.compile(REGEX_ENUM);
        return AviatorHelper.parse(AviatorHelper.parse(ruleContent, pattern), enumPatten);
    }

    private static String parse(String ruleContent, Pattern pattern) {
        Matcher matcher = pattern.matcher(ruleContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String matchStr = matcher.group();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matchStr.substring(2, matchStr.length() - 1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        INSTANCE.setOption(Options.ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL, (Object)true);
        INSTANCE.setOption(Options.MATH_CONTEXT, (Object)MathContext.DECIMAL128);
        INSTANCE.setOption(Options.MAX_LOOP_COUNT, (Object)8);
        AviatorHelper.functionAdd();
    }
}

