/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils.infuence;

import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractParticipant
implements Participant {
    private IEntityClass entityClass;
    private IEntityField field;
    private Collection<IEntity> affectedEntities;
    private Object attachment;
    private boolean source;

    @Override
    public String getId() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.source);
        buff.append(this.getEntityClass() == null ? 0L : this.getEntityClass().id()).append(".").append(this.getField() == null ? 0L : this.getField().id());
        return buff.toString();
    }

    protected void setEntityClass(IEntityClass entityClass) {
        this.entityClass = entityClass;
    }

    protected void setField(IEntityField field) {
        this.field = field;
    }

    protected void setAffectedEntities(Collection<IEntity> affectedEntities) {
        if (affectedEntities != null) {
            this.affectedEntities = new LinkedList<IEntity>(affectedEntities);
        }
    }

    @Override
    public void source() {
        this.source = true;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public IEntityClass getEntityClass() {
        return this.entityClass;
    }

    @Override
    public IEntityField getField() {
        return this.field;
    }

    @Override
    public Collection<IEntity> getAffectedEntities() {
        if (this.affectedEntities == null) {
            return Collections.emptyList();
        }
        return this.affectedEntities;
    }

    @Override
    public void addAffectedEntity(IEntity entity) {
        if (this.affectedEntities == null) {
            this.affectedEntities = new LinkedList<IEntity>();
        }
        this.affectedEntities.add(entity);
    }

    @Override
    public Optional<IEntity> removeAffectedEntities(long id) {
        if (this.affectedEntities == null) {
            return Optional.empty();
        }
        AtomicReference targetEntity = new AtomicReference();
        this.affectedEntities.removeIf(e -> {
            if (e.id() == id) {
                targetEntity.set(e);
                return true;
            }
            return false;
        });
        return Optional.ofNullable((IEntity)targetEntity.get());
    }

    @Override
    public Optional<Object> getAttachment() {
        return Optional.ofNullable(this.attachment);
    }

    @Override
    public boolean isSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractParticipant)) {
            return false;
        }
        AbstractParticipant that = (AbstractParticipant)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" (").append(this.getEntityClass().code()).append(",").append(this.getField().name()).append(")");
        return sb.toString();
    }
}

