/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils.infuence;

import com.xforceplus.ultraman.oqsengine.calculation.utils.ValueChange;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.InfuenceConsumer;
import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.Participant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Infuence {
    private boolean allowDuplicates;
    private int size;
    private RootNode rootNode;
    private Map<Participant, List<Node>> participantNodeSearchHelper;

    public Infuence(IEntity entity, Participant participant, ValueChange change) {
        this(entity, participant, change, false);
    }

    public Infuence(IEntity entity, Participant participant, ValueChange change, boolean allowDuplicates) {
        this.rootNode = new RootNode(entity, participant, change);
        this.participantNodeSearchHelper = new HashMap<Participant, List<Node>>();
        this.addQuickLink(participant, this.rootNode);
        ++this.size;
        this.allowDuplicates = allowDuplicates;
    }

    public IEntity getSourceEntity() {
        return this.rootNode.getEntity();
    }

    public ValueChange getValueChange() {
        return this.rootNode.getChange();
    }

    public boolean impact(Participant participant) {
        return this.impact(this.rootNode.getParticipant(), participant);
    }

    public boolean impact(Participant parentParticipant, Participant newParticipant) {
        if (!this.allowDuplicates && parentParticipant.equals(newParticipant)) {
            return false;
        }
        if (this.rootNode.getParticipant().equals(parentParticipant)) {
            this.insert(this.rootNode, newParticipant);
            return true;
        }
        Optional<Node> childOp = this.searchChild(parentParticipant);
        if (childOp.isPresent()) {
            ChildNode childNode = (ChildNode)childOp.get();
            if (!this.allowDuplicates) {
                Optional<Node> point = childNode.getParent();
                while (point.isPresent()) {
                    if (point.get().getParticipant().equals(newParticipant)) {
                        return false;
                    }
                    point = point.get().getParent();
                }
            }
            this.insert(childNode, newParticipant);
            return true;
        }
        return false;
    }

    public boolean move(Participant targetParticipant, Participant newParentParticipant) {
        if (this.rootNode.getParticipant().equals(targetParticipant)) {
            return false;
        }
        if (targetParticipant.equals(newParentParticipant)) {
            return false;
        }
        Optional<Node> nodeOp = this.searchChild(targetParticipant);
        if (!nodeOp.isPresent()) {
            return false;
        }
        Optional<Node> firstParentNodeOp = this.searchChild(newParentParticipant);
        if (!firstParentNodeOp.isPresent()) {
            return false;
        }
        Node targetNode = nodeOp.get();
        Node parentNode = firstParentNodeOp.get();
        targetNode.getParent().get().removeChild(targetNode);
        parentNode.addChild(targetNode);
        this.updateLevel(targetNode, parentNode.getLevel() + 1);
        return true;
    }

    private void updateLevel(Node node, int level) {
        if (node != null) {
            node.setLevel(level);
            for (Node child : node.getChildren()) {
                this.updateLevel(child, level + 1);
            }
        }
    }

    public Optional<Participant> getPre(Participant participant) {
        Optional<Node> node = this.searchChild(participant);
        if (node.isPresent() && node.get().getParent().isPresent()) {
            return Optional.of(node.get().getParent().get().getParticipant());
        }
        return Optional.empty();
    }

    public Optional<Collection<Participant>> getNextParticipants(Participant participant) {
        List<Node> children;
        Optional<Node> node = this.searchChild(participant);
        if (node.isPresent() && !(children = node.get().getChildren()).isEmpty()) {
            List participants = children.stream().map(Node::getParticipant).collect(Collectors.toList());
            return Optional.of(participants);
        }
        return Optional.empty();
    }

    public int getLevel(Participant participant) {
        Optional<Node> node = this.searchChild(participant);
        return node.map(Node::getLevel).orElse(-1);
    }

    public boolean pruning(Participant parent, Participant participant) {
        if (parent.equals(this.rootNode.getParticipant())) {
            this.pruning(this.rootNode, participant);
            return true;
        }
        Optional<Node> childOp = this.searchChild(parent);
        if (childOp.isPresent()) {
            Node childNode = childOp.get();
            this.pruning(childNode, participant);
            return true;
        }
        return false;
    }

    private void pruning(Node point, Participant participant) {
        for (Node n : point.getChildren()) {
            ChildNode c = (ChildNode)n;
            if (!c.getParticipant().equals(participant)) continue;
            point.getChildren().remove(c);
            --this.size;
            return;
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean empty() {
        if (this.rootNode == null) {
            return true;
        }
        boolean onlyRoot = true;
        return this.getSize() == 1;
    }

    public void scan(InfuenceConsumer consumer) {
        if (this.rootNode == null) {
            return;
        }
        this.scan(consumer, this.rootNode.getParticipant());
    }

    public void scan(InfuenceConsumer consumer, Participant participant) {
        Optional<Node> startNodeOp = this.searchChild(participant);
        if (!startNodeOp.isPresent()) {
            return;
        }
        this.bfsIter((node, level) -> {
            if (RootNode.class.isInstance(node)) {
                RootNode rootNode = (RootNode)node;
                return consumer.accept(Optional.empty(), rootNode.getParticipant(), this);
            }
            ChildNode childNode = (ChildNode)node;
            Optional<Node> parentNode = childNode.getParent();
            return consumer.accept(parentNode.isPresent() ? Optional.of(parentNode.get().getParticipant()) : Optional.empty(), childNode.getParticipant(), this);
        }, startNodeOp.get());
    }

    public String toString() {
        if (this.rootNode == null) {
            return "";
        }
        if (this.empty()) {
            return this.rootNode.toString();
        }
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.push(this.rootNode);
        StringBuffer buffer = new StringBuffer();
        while (!stack.isEmpty()) {
            Node point = (Node)stack.pop();
            if (this.rootNode != point) {
                buffer.append('\n');
            }
            for (int i = 0; i < point.getLevel(); ++i) {
                buffer.append("   ");
            }
            if (this.rootNode != point) {
                buffer.append('L');
            }
            if (point.getLevel() > 0) {
                buffer.append("---");
            }
            buffer.append(point);
            for (Node child : point.getChildren()) {
                stack.push(child);
            }
        }
        return buffer.toString();
    }

    private void insert(Node point, Participant newParticipant) {
        for (Node n : point.getChildren()) {
            ChildNode c = (ChildNode)n;
            if (!c.getParticipant().equals(newParticipant)) continue;
            return;
        }
        ChildNode newChildNode = new ChildNode(newParticipant);
        point.addChild(newChildNode);
        newChildNode.setLevel(point.getLevel() + 1);
        this.addQuickLink(newParticipant, newChildNode);
        ++this.size;
    }

    public boolean contains(Participant participant) {
        return this.searchChild(participant).isPresent() || this.rootNode.getParticipant().equals(participant);
    }

    private Optional<Node> searchChild(Participant participant) {
        List<Node> nodes = this.participantNodeSearchHelper.get(participant);
        if (nodes != null && !nodes.isEmpty()) {
            return Optional.ofNullable(nodes.get(0));
        }
        return Optional.empty();
    }

    private void bfsIter(BfsIterNodeConsumer consumer) {
        this.bfsIter(consumer, this.rootNode);
    }

    private void bfsIter(BfsIterNodeConsumer bfsIterNodeConsumer, Node startNode) {
        LinkedList<Node> stack = new LinkedList<Node>();
        int level = startNode.getLevel();
        stack.add(startNode);
        stack.add(LevelNode.getInstance());
        block6: while (!stack.isEmpty()) {
            Node node = (Node)stack.poll();
            if (node == LevelNode.getInstance()) {
                ++level;
                if (stack.isEmpty()) continue;
                stack.add(LevelNode.getInstance());
                continue;
            }
            InfuenceConsumer.Action action = bfsIterNodeConsumer.consumer(node, level);
            switch (action) {
                case CONTINUE: {
                    node.getChildren().forEach(n -> stack.add((Node)n));
                    continue block6;
                }
                case OVER: {
                    return;
                }
                case OVER_SELF: {
                    continue block6;
                }
                case OVER_REMOVE_SELF: {
                    Optional<Node> parentNode = node.getParent();
                    if (parentNode.isPresent()) {
                        Node parent = parentNode.get();
                        parent.removeChild(node);
                        this.bfsIter((n, l) -> {
                            Participant p = n.getParticipant();
                            List<Node> nodes = this.participantNodeSearchHelper.get(p);
                            if (nodes != null) {
                                nodes.remove(n);
                                --this.size;
                                if (nodes.isEmpty()) {
                                    this.participantNodeSearchHelper.remove(p);
                                }
                            }
                            return InfuenceConsumer.Action.CONTINUE;
                        }, node);
                        continue block6;
                    }
                    this.rootNode = null;
                    this.size = 0;
                    this.participantNodeSearchHelper.clear();
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Error action.");
        }
    }

    private void addQuickLink(Participant participant, Node node) {
        List<Node> nodes = this.participantNodeSearchHelper.get(participant);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.participantNodeSearchHelper.put(participant, nodes);
        }
        nodes.add(node);
    }

    private static class RootNode
    extends Node {
        private IEntity entity;
        private ValueChange change;

        public RootNode(IEntity entity, Participant participant, ValueChange change) {
            super(participant);
            this.entity = entity;
            this.change = change;
        }

        public IEntity getEntity() {
            return this.entity;
        }

        public ValueChange getChange() {
            return this.change;
        }

        public Optional<Node> getChild(IEntityClass entityClass) {
            return this.getChildren().stream().filter(node -> ((ChildNode)node).getParticipant().getEntityClass().id() == entityClass.id()).findFirst();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootNode otherRootNode = (RootNode)o;
            return otherRootNode.getEntity().id() == otherRootNode.getEntity().id();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Participant participant = this.getParticipant();
            sb.append("(").append(participant.getEntityClass().code()).append(",").append(this.getChange().getField().name()).append(")");
            return sb.toString();
        }
    }

    private static class Node {
        private Participant participant;
        private Node parent;
        private List<Node> children;
        private int level;

        public Node(Participant participant) {
            this.participant = participant;
        }

        public Optional<Node> getParent() {
            return Optional.ofNullable(this.parent);
        }

        public Participant getParticipant() {
            return this.participant;
        }

        public List<Node> getChildren() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return this.children;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public void addChild(Node child) {
            if (this.children == null) {
                this.children = new LinkedList<Node>();
            }
            child.setParent(this);
            this.children.add(child);
        }

        public void removeChild(Node child) {
            if (this.children != null) {
                this.children.remove(child);
            }
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }

    private static class ChildNode
    extends Node
    implements Comparable<ChildNode> {
        public ChildNode(Participant participant) {
            super(participant);
        }

        @Override
        public int compareTo(ChildNode o) {
            long otherId;
            long ownId = this.getParticipant().getEntityClass().id();
            if (ownId < (otherId = o.getParticipant().getEntityClass().id())) {
                return -1;
            }
            if (ownId > otherId) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.getParticipant().getEntityClass().code()).append(",").append(this.getParticipant().getField().name()).append(")");
            return sb.toString();
        }
    }

    @FunctionalInterface
    private static interface BfsIterNodeConsumer {
        public InfuenceConsumer.Action consumer(Node var1, int var2);
    }

    private static class LevelNode
    extends Node {
        public static Node INSTANCE = new LevelNode();

        public static Node getInstance() {
            return INSTANCE;
        }

        public LevelNode() {
            super(null);
        }
    }
}

