/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.calculation.utils.infuence;

import com.xforceplus.ultraman.oqsengine.calculation.utils.infuence.AbstractParticipant;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.util.Collection;
import java.util.Collections;

public class InitCalculationParticipant
extends AbstractParticipant
implements Comparable<InitCalculationParticipant> {
    private IEntityClass sourceEntityClass;
    private Collection<IEntityField> sourceFields;
    private int age;
    private IEntity process;

    public IEntityClass getSourceEntityClass() {
        return this.sourceEntityClass;
    }

    public Collection<IEntityField> getSourceFields() {
        return this.sourceFields == null ? Collections.emptyList() : this.sourceFields;
    }

    public int growUp() {
        return ++this.age;
    }

    public int getAge() {
        return this.age;
    }

    public IEntity getProcess() {
        return this.process;
    }

    public void setProcess(IEntity process) {
        this.process = process;
    }

    public boolean isChange(IEntity entity) {
        if (this.process == null) {
            return false;
        }
        return this.process.equals(entity);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InitCalculationParticipant{");
        sb.append("sourceEntityClass=").append(this.sourceEntityClass);
        sb.append(", sourceField=").append(this.sourceFields);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(InitCalculationParticipant participant) {
        if (this.age - participant.age == 0) {
            return this.getField().compareTo(participant.getField());
        }
        return participant.age - this.age;
    }

    public static final class Builder {
        private IEntityClass entityClass;
        private IEntityField field;
        private Collection<IEntity> affectedEntities;
        private Object attachment;
        private IEntityClass sourceEntityClass;
        private Collection<IEntityField> sourceFields;
        private int age;
        private IEntity process;

        private Builder() {
        }

        public static Builder anInitCalculationParticipant() {
            return new Builder();
        }

        public Builder withEntityClass(IEntityClass entityClass) {
            this.entityClass = entityClass;
            return this;
        }

        public Builder withField(IEntityField field) {
            this.field = field;
            return this;
        }

        public Builder withAffectedEntities(Collection<IEntity> affectedEntities) {
            this.affectedEntities = affectedEntities;
            return this;
        }

        public Builder withAttachment(Object attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder withSourceEntityClass(IEntityClass sourceEntityClass) {
            this.sourceEntityClass = sourceEntityClass;
            return this;
        }

        public Builder withSourceFields(Collection<IEntityField> sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public Builder withAge(int age) {
            this.age = age;
            return this;
        }

        public Builder withProcess(IEntity process) {
            this.process = process;
            return this;
        }

        public InitCalculationParticipant build() {
            InitCalculationParticipant initCalculationParticipant = new InitCalculationParticipant();
            initCalculationParticipant.setEntityClass(this.entityClass);
            initCalculationParticipant.setField(this.field);
            initCalculationParticipant.setAffectedEntities(this.affectedEntities);
            initCalculationParticipant.setAttachment(this.attachment);
            initCalculationParticipant.setProcess(this.process);
            initCalculationParticipant.sourceEntityClass = this.sourceEntityClass;
            initCalculationParticipant.age = this.age;
            initCalculationParticipant.sourceFields = this.sourceFields;
            return initCalculationParticipant;
        }
    }
}

