/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc;

import com.xforceplus.ultraman.oqsengine.cdc.connect.CDCConnector;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.ConsumerRunner;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.ConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.metrics.CDCMetricsService;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCDaemonService {
    final Logger logger = LoggerFactory.getLogger(CDCDaemonService.class);
    @Resource(name="nodeIdGenerator")
    private NodeIdGenerator nodeIdGenerator;
    @Resource
    private ConsumerService consumerService;
    @Resource
    private CDCMetricsService cdcMetricsService;
    @Resource
    private CDCConnector cdcConnector;
    private ConsumerRunner consumerRunner;
    private static boolean isStart = false;

    public void stopDaemon() {
        if (isStart) {
            this.logger.info("[cdc-daemon] try close CDC daemon process thread...");
            this.consumerRunner.shutdown();
            isStart = false;
            this.logger.info("[cdc-daemon] try close CDC daemon process thread success...");
        }
    }

    @PostConstruct
    public void startDaemon() {
        Integer nodeId = (Integer)this.nodeIdGenerator.next();
        this.logger.info("[cdc-daemon] current node = {}", (Object)nodeId);
        if (nodeId == 0 && !isStart) {
            this.logger.info("[cdc-daemon] node-{} start CDC daemon process thread...", (Object)nodeId);
            this.consumerRunner = new ConsumerRunner(this.consumerService, this.cdcMetricsService, this.cdcConnector);
            this.consumerRunner.start();
            isStart = true;
            this.logger.info("[cdc-daemon] node-{} start CDC daemon process thread success...", (Object)nodeId);
        }
    }
}

