/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.connect;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.protocol.Message;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CDCConnector {
    final Logger logger = LoggerFactory.getLogger(CDCConnector.class);
    private String subscribeFilter = ".*\\.oqsbigentity.*";
    private int batchSize = 2048;
    protected CanalConnector canalConnector;
    private boolean isClosed = true;

    public void shutdown() {
        try {
            if (this.canalConnector.checkValid()) {
                this.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[cdc-connector] shutdown error, message : {}", (Object)e.getMessage());
        }
    }

    public void open() {
        if (null != this.canalConnector) {
            this.canalConnector.connect();
            this.canalConnector.subscribe(this.subscribeFilter);
            this.logger.info("[cdc-connector] connect to canal server...");
            this.isClosed = false;
        }
    }

    public void close() {
        if (null != this.canalConnector && !this.isClosed) {
            try {
                this.logger.error("[cdc-connector] close canal connector...");
                this.canalConnector.disconnect();
            }
            catch (Exception e) {
                this.logger.error("[cdc-connector] close error, ex : {}", (Object)e.getMessage());
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public void rollback() {
        if (null != this.canalConnector) {
            this.canalConnector.rollback();
        }
    }

    public void ack(long batchId) throws SQLException {
        if (null == this.canalConnector) {
            this.notInitException();
        }
        this.canalConnector.ack(batchId);
    }

    public Message getMessageWithoutAck() throws SQLException {
        if (null == this.canalConnector) {
            this.notInitException();
        }
        return this.canalConnector.getWithoutAck(this.batchSize);
    }

    private void notInitException() throws SQLException {
        throw new SQLException("[cdc-connector] canal connector not init.");
    }

    public void setSubscribeFilter(String subscribeFilter) {
        this.subscribeFilter = subscribeFilter;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

