/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc;

import com.xforceplus.ultraman.oqsengine.cdc.connect.AbstractCDCConnector;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.ConsumerRunner;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.ConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.metrics.CDCMetricsService;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCDaemonService
implements Lifecycle {
    final Logger logger = LoggerFactory.getLogger(CDCDaemonService.class);
    @Resource(name="nodeIdGenerator")
    private NodeIdGenerator nodeIdGenerator;
    @Resource
    private ConsumerService consumerService;
    @Resource
    private CDCMetricsService cdcMetricsService;
    @Resource
    private AbstractCDCConnector abstractCdcConnector;
    private ConsumerRunner consumerRunner;
    private static boolean isStart = false;

    @PostConstruct
    public void init() throws Exception {
        Integer nodeId = (Integer)this.nodeIdGenerator.next();
        this.logger.info("[cdc-daemon] current node = {}", (Object)nodeId);
        if (nodeId == 0 && !isStart) {
            this.logger.info("[cdc-daemon] node-{} start CDC daemon process thread...", (Object)nodeId);
            this.consumerRunner = new ConsumerRunner(this.consumerService, this.cdcMetricsService, this.abstractCdcConnector);
            this.consumerRunner.start();
            isStart = true;
            this.logger.info("[cdc-daemon] node-{} start CDC daemon process thread success...", (Object)nodeId);
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (isStart) {
            this.logger.info("[cdc-daemon] try close CDC daemon process thread...");
            this.consumerRunner.shutdown();
            isStart = false;
            this.logger.info("[cdc-daemon] try close CDC daemon process thread success...");
        }
    }
}

