/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.CdcErrorExecutor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDevOpsExecutor<T, R>
implements CdcErrorExecutor<T, R> {
    final Logger logger = LoggerFactory.getLogger(AbstractDevOpsExecutor.class);
    private String tableName;
    private DataSource dataSource;
    private long timeoutMs;

    public AbstractDevOpsExecutor(String tableName, DataSource dataSource) {
        this(tableName, dataSource, 0L);
    }

    public AbstractDevOpsExecutor(String tableName, DataSource dataSource, long timeoutMs) {
        this.tableName = tableName;
        this.dataSource = dataSource;
        this.timeoutMs = timeoutMs;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    protected void checkTimeout(PreparedStatement statement) throws SQLException {
        if (this.getTimeoutMs() > 0L) {
            statement.setQueryTimeout((int)(this.getTimeoutMs() / 1000L));
        }
    }
}

